<?php

namespace Nextend\SmartSlider3Pro\Generator\Joomla\Djclassifieds;

use Nextend\Framework\Filesystem\Filesystem;
use Nextend\SmartSlider3\Generator\AbstractGeneratorGroup;
use Nextend\SmartSlider3\Generator\GeneratorFactory;
use Nextend\SmartSlider3Pro\Generator\Joomla\Djclassifieds\Sources\DjclassifiedsItems;

class GeneratorGroupDjclassifieds extends AbstractGeneratorGroup {

    protected $name = 'djclassifieds';

    protected $url = 'https://extensions.joomla.org/extension/dj-classifieds/';

    protected $isDeprecated = true;

    public function getLabel() {
        return 'DJ Classifieds';
    }

    public function getDescription() {
        return sprintf(n2_('Creates slides from %1$s content.'), 'DJ Classifieds');
    }

    public function isInstalled() {
        return Filesystem::existsFolder(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_djclassifieds');
    }

    protected function loadSources() {
        new DjclassifiedsItems($this, 'items', n2_('Items'));
    }
}

GeneratorFactory::addGenerator(new GeneratorGroupDjclassifieds);

