<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$rootUri = Uri::root();

echo HTMLHelper::_($tabApiPrefix . 'addTab', 'status', 'translation-page', Text::_('HDP_TRANSLATION', true));
echo HTMLHelper::_($tabApiPrefix . 'startTabSet', 'item-translation', array('active' => 'translation-page-'.$this->languages[0]->sef));

foreach ($this->languages as $language)
{
	$sef = $language->sef;
	echo HTMLHelper::_($tabApiPrefix . 'addTab', 'item-translation', 'translation-page-' . $sef, $language->title . ' <img src="' . $rootUri . 'media/com_helpdeskpro/assets/flags/' . $sef . '.png" />');
	?>
    <div class="control-group">
        <div class="control-label">
			<?php echo Text::_('HDP_TITLE'); ?>
        </div>
        <div class="controls">
            <input class="input-xlarge" type="text" name="title_<?php echo $sef; ?>"
                   id="title_<?php echo $sef; ?>" size="" maxlength="250"
                   value="<?php echo $this->item->{'title_' . $sef}; ?>"/>
        </div>
    </div>
	<?php
	echo HTMLHelper::_($tabApiPrefix . 'endTab');
}

echo HTMLHelper::_($tabApiPrefix . 'endTabSet');
echo HTMLHelper::_($tabApiPrefix . 'endTab');