<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskproHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;

defined('_JEXEC') or die;

class plgHelpdeskProAssignticket extends CMSPlugin
{
	public function onViewTicket($row)
	{
		HTMLHelper::_('behavior.core');
		$config   = HelpdeskproHelper::getConfig();
		$rowUsers = HelpdeskproHelperDatabase::getAllStaffs($config->staff_group_id);
		$user     = JFactory::getUser();
		$document = JFactory::getDocument();
		$document->addScript(Uri::root(true) . '/media/com_helpdeskpro/js/plug_helpdeskpro_assignticket.js');
		$document->addScriptOptions('ticket_id', $row->id);
		$document->addScriptOptions('hpdBaseUri', Uri::base(true));
		Text::script('HDP_ASSIGN_TICKET_SUCCESS');

		$displayField = $config->get('staff_display_field', 'username') ?: 'username';


		if (count($rowUsers) && $user->authorise('helpdeskpro.assignticket', 'com_helpdeskpro'))
		{
			ob_start();
			?>
			<tr>
				<th colspan="2"><?php echo Text::_('HDP_ASSIGN_TICKET_TO_STAFF'); ?></th>
			</tr>
			<?php
			?>
			<tr>
				<td colspan="2">
					<?php
					$options   = array();
					$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_SELECT_STAFF'), 'id', $displayField);
					$options   = array_merge($options, $rowUsers);
					echo HTMLHelper::_('select.genericlist', $options, 'user_id', 'class="chosen"', 'id', $displayField, $row->staff_id);
					?>
					<input type="button" id="ajaxButton" value="<?php echo Text::_('HDP_ASSIGN') ?>"
					       class="btn btn-primary">
					<img style="display: none;" class="ajax-loading" alt=""
					     src="<?php echo Uri::root(true) . '/plugins/helpdeskpro/assignticket/loading.gif'; ?>"><br>
				</td>
			</tr>
			<?php
			return ob_get_clean();
		}

		return null;
	}
}	