<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/lmsyaran/public_html/j3/templates/g5_hydrogen/custom/particles/jlmenucanvas.yaml',
    'modified' => 1735546496,
    'data' => [
        'name' => 'JL Menu Canvas',
        'description' => 'Gantry menu',
        'type' => 'particle',
        'icon' => 'fa-bars',
        'configuration' => [
            'caching' => [
                'type' => 'menu'
            ]
        ],
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable the menu particle.',
                    'default' => true
                ],
                '_tabs' => [
                    'type' => 'container.tabs',
                    'fields' => [
                        '_tab_content' => [
                            'label' => 'Content',
                            'fields' => [
                                'menu' => [
                                    'type' => 'menu.list',
                                    'label' => 'Menu',
                                    'description' => 'Select menu to be used with the particle.',
                                    'default' => '',
                                    'selectize' => [
                                        'allowEmptyOption' => true
                                    ],
                                    'options' => [
                                        '' => 'Use Default Menu',
                                        '-active-' => 'Use Active Menu'
                                    ]
                                ],
                                'base' => [
                                    'type' => 'menu.item',
                                    'label' => 'Base Item',
                                    'description' => 'Select a menu item to always be used as the base for the menu display.',
                                    'default' => '/',
                                    'options' => [
                                        '/' => 'Active'
                                    ]
                                ],
                                'startLevel' => [
                                    'type' => 'input.text',
                                    'label' => 'Start Level',
                                    'description' => 'Set the start level of the menu.',
                                    'default' => 1
                                ],
                                'maxLevels' => [
                                    'type' => 'input.text',
                                    'label' => 'Max Levels',
                                    'description' => 'Set the maximum number of menu levels to display.',
                                    'default' => 0
                                ],
                                'renderTitles' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Render Titles',
                                    'description' => 'Renders the titles/tooltips of the Menu Items for accessibility.',
                                    'default' => 0
                                ],
                                'forceTarget' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Force Target Attribute',
                                    'description' => 'Adds \'target=&quot;_self&quot;\' attribute to all menu links instead of omitting the default value. Fixes an issue with pinned tabs in Firefox where external links always open in a new tab.',
                                    'default' => 0
                                ],
                                'menu_text' => [
                                    'type' => 'input.text',
                                    'label' => 'Menu Toggle Text',
                                    'description' => 'Show the text label Menu next to the hamburger icon.',
                                    'placeholder' => 'Menu',
                                    'default' => 'MENU'
                                ],
                                'icon' => [
                                    'type' => 'input.icon',
                                    'label' => 'Menu Toggle Icon',
                                    'description' => 'Instead of using default toggle icon, you can click on the hand to pick a custom icon from the icon library.'
                                ],
                                'info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'To edit the Module please use the <a href="index.php?option=com_modules" target="_blank" data-g-urltemplate="index.php?option=com_modules&view=module&task=module.edit&id=#ID#" href="#">Joomla\'s Module Manager <i class="fa fa-fw fa-external-link" aria-hidden="true"></i></a>'
                                ],
                                'module_id' => [
                                    'type' => 'gantry.module',
                                    'label' => 'Module Id',
                                    'class' => 'g-urltemplate input-small',
                                    'picker_label' => 'Pick a Module',
                                    'description' => 'Enter module Id.',
                                    'pattern' => '\\d+',
                                    'overridable' => false
                                ],
                                'chrome' => [
                                    'type' => 'input.text',
                                    'label' => 'Chrome',
                                    'description' => 'Module chrome.',
                                    'placeholder' => 'gantry'
                                ],
                                'visibility' => [
                                    'type' => 'select.select',
                                    'label' => 'Visibility',
                                    'description' => 'Display the element only on this device width and larger.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'class' => [
                                    'type' => 'input.selectize',
                                    'label' => 'CSS Classes',
                                    'description' => 'CSS class name for the particle.'
                                ]
                            ]
                        ],
                        '_tab_style' => [
                            'label' => 'Style',
                            'overridable' => false,
                            'fields' => [
                                'toggle_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Menu Toggle Text'
                                ],
                                'toggle_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Color',
                                    'description' => 'Customize the toggle color if needed.'
                                ],
                                'toggle_color_hover' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Hover Color'
                                ],
                                'toggle_text_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the toggle text font size.'
                                ],
                                'animation_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Select the menu type displayed on click.'
                                ],
                                'menu_animation' => [
                                    'type' => 'select.select',
                                    'label' => 'Menu Animation',
                                    'default' => 'offcanvas',
                                    'options' => [
                                        'offcanvas' => 'Offcanvas',
                                        'modal' => 'Modal'
                                    ]
                                ],
                                'close_button' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Show Close Icon',
                                    'description' => 'Use this option to create a close button and enable its functionality.',
                                    'default' => true
                                ],
                                'offcanvas_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Offcanvas Animations'
                                ],
                                'overlay' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Overlay',
                                    'description' => 'Use this option to add an overlay, blanking out the page.',
                                    'default' => true
                                ],
                                'animation_mode' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation modes',
                                    'description' => 'Choose between Slide, Reveal and Push offcanvas animations.',
                                    'default' => 'slide',
                                    'options' => [
                                        'slide' => 'Slide',
                                        'push' => 'Push',
                                        'reveal' => 'Reveal',
                                        'none' => 'None'
                                    ]
                                ],
                                'flip_offcanvas' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Display on the right',
                                    'default' => false
                                ],
                                'offcanvas_minheight' => [
                                    'type' => 'input.number',
                                    'label' => 'Menu Toggle Height',
                                    'description' => 'Set the height of a Menu Toggle.',
                                    'default' => 62
                                ],
                                'customize_bar_background' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Background Color',
                                    'description' => 'Customize the background color for offcanvas bar.'
                                ],
                                'offcanvas_inverse' => [
                                    'type' => 'select.select',
                                    'label' => 'Inverse Color',
                                    'description' => 'Set light or dark color mode for nav icon, buttons and controls.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'modal_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Modal'
                                ],
                                'modal_vertically' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Center vertically',
                                    'default' => false
                                ],
                                'nav_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Nav Settings'
                                ],
                                'nav_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Menu Style',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Default',
                                        'primary' => 'Primary'
                                    ]
                                ],
                                'nav_center' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Center horizontally',
                                    'default' => 0
                                ],
                                'nav_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Nav Color',
                                    'description' => 'Customize the nav item color if needed.'
                                ],
                                'nav_color_active' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Active Color',
                                    'description' => 'Customize the nav item hover/active color if needed.'
                                ],
                                'nav_color_header' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Nav Header Color'
                                ],
                                'nav_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ]
                            ]
                        ]
                    ]
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-success',
                    'content' => 'JL Menu Canvas <strong>Version: 2.1.3</strong> Copyright (C) <a href="https://joomlead.com/" target="_blank">https://joomlead.com</a> | <a href="https://joomlead.com/g5/docs/menu-canvas-particle/" target="_blank">Documentation</a>'
                ]
            ]
        ]
    ]
];
