<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/lmsyaran/public_html/templates/g5_hydrogen/custom/particles/jlcarouseljoomla.yaml',
    'modified' => 1589206860,
    'data' => [
        'name' => 'Carousel Joomla',
        'description' => 'Create a responsive carousel slider for Joomla Articles',
        'type' => 'particle',
        'icon' => 'fa-joomla',
        'form' => [
            'overrideable' => false,
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable to the particles.',
                    'default' => true
                ],
                '_tabs' => [
                    'type' => 'container.tabs',
                    'fields' => [
                        '_tab_articles' => [
                            'label' => 'Articles',
                            'overridable' => false,
                            'fields' => [
                                'article.filter.categories' => [
                                    'type' => 'joomla.categories',
                                    'label' => 'Categories',
                                    'description' => 'Select the categories the articles should be taken from.',
                                    'overridable' => false
                                ],
                                'article.filter.articles' => [
                                    'type' => 'input.text',
                                    'label' => 'Articles',
                                    'description' => 'Enter the Joomla articles that should be shown. It should be a list of article IDs separated with a comma (i.e. 1,2,3,4,5).',
                                    'overridable' => false
                                ],
                                'article.filter.featured' => [
                                    'type' => 'select.select',
                                    'label' => 'Featured Articles',
                                    'description' => 'Select how Featured articles should be filtered.',
                                    'default' => '',
                                    'options' => [
                                        'include' => 'Include Featured',
                                        'exclude' => 'Exclude Featured',
                                        'only' => 'Only Featured'
                                    ],
                                    'overridable' => false
                                ],
                                'article.limit.total' => [
                                    'type' => 'input.text',
                                    'label' => 'Number of Articles',
                                    'description' => 'Enter the maximum number of articles to display.',
                                    'default' => 6,
                                    'pattern' => '\\d{1,2}',
                                    'overridable' => false
                                ],
                                'article.limit.start' => [
                                    'type' => 'input.text',
                                    'label' => 'Start From',
                                    'description' => 'Enter offset specifying the first article to return. The default is \'0\' (the first article).',
                                    'default' => 0,
                                    'pattern' => '\\d{1,2}',
                                    'overridable' => false
                                ],
                                'article.sort.orderby' => [
                                    'type' => 'select.select',
                                    'label' => 'Order By',
                                    'description' => 'Select how the articles should be ordered by.',
                                    'default' => 'publish_up',
                                    'options' => [
                                        'publish_up' => 'Published Date',
                                        'created' => 'Created Date',
                                        'modified' => 'Last Modified Date',
                                        'title' => 'Title',
                                        'ordering' => 'Ordering',
                                        'hits' => 'Hits',
                                        'id' => 'ID',
                                        'alias' => 'Alias'
                                    ],
                                    'overridable' => false
                                ],
                                'article.sort.ordering' => [
                                    'type' => 'select.select',
                                    'label' => 'Ordering Direction',
                                    'description' => 'Select the direction the articles should be ordered by.',
                                    'default' => 'ASC',
                                    'options' => [
                                        'ASC' => 'Ascending',
                                        'DESC' => 'Descending'
                                    ],
                                    'overridable' => false
                                ],
                                'article_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Display'
                                ],
                                'article.display.image.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Image',
                                    'description' => 'Select if and what image of the article should be shown.',
                                    'default' => 'intro',
                                    'options' => [
                                        'intro' => 'Intro',
                                        'full' => 'Full',
                                        '' => 'None'
                                    ]
                                ],
                                'article.display.text.type' => [
                                    'type' => 'select.select',
                                    'label' => 'Article Text',
                                    'description' => 'Select if and how the article text should be shown.',
                                    'default' => 'intro',
                                    'options' => [
                                        'intro' => 'Introduction',
                                        'full' => 'Full Article',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.text.limit' => [
                                    'type' => 'input.text',
                                    'label' => 'Text Limit',
                                    'description' => 'Type in the number of characters the article text should be limited to.',
                                    'default' => '50',
                                    'pattern' => '\\d+'
                                ],
                                'article.display.text.formatting' => [
                                    'type' => 'select.select',
                                    'label' => 'Text Formatting',
                                    'description' => 'Select the formatting you want to use to display the article text.',
                                    'default' => 'text',
                                    'options' => [
                                        'text' => 'Plain Text',
                                        'html' => 'HTML'
                                    ]
                                ],
                                'article.display.text.prepare' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Prepare Content',
                                    'description' => 'Use Joomla Content Plugins',
                                    'default' => false
                                ],
                                'article.display.edit' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Show Edit Link',
                                    'description' => 'Display a link to the article edit form',
                                    'default' => false
                                ],
                                'article.display.title.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Title',
                                    'description' => 'Select if the article title should be shown.',
                                    'default' => 'show',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.title.limit' => [
                                    'type' => 'input.text',
                                    'label' => 'Title Limit',
                                    'description' => 'Enter the maximum number of characters the article title should be limited to.',
                                    'pattern' => '\\d+(\\.\\d+){0,1}'
                                ],
                                'class' => [
                                    'type' => 'input.selectize',
                                    'label' => 'CSS Classes',
                                    'description' => 'CSS class name for the particle.'
                                ],
                                'extra' => [
                                    'type' => 'collection.keyvalue',
                                    'label' => 'Tag Attributes',
                                    'description' => 'Extra Tag attributes.',
                                    'key_placeholder' => 'Key (data-*, style, ...)',
                                    'value_placeholder' => 'Value',
                                    'exclude' => [
                                        0 => 'id',
                                        1 => 'class'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_settings' => [
                            'label' => 'Slider',
                            'overridable' => false,
                            'fields' => [
                                'slider_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Layout'
                                ],
                                'slider_width_mode' => [
                                    'type' => 'select.select',
                                    'label' => 'Item Width Mode',
                                    'overridable' => false,
                                    'description' => 'Define whether the width of the slider items is fixed or automatically expanded by its content widths. The height settings and Item width settings below are not working with AUTO mode.',
                                    'default' => 'fixed',
                                    'options' => [
                                        'fixed' => 'Fixed',
                                        'auto' => 'Auto'
                                    ]
                                ],
                                'slider_viewport' => [
                                    'type' => 'select.select',
                                    'label' => 'Height',
                                    'description' => 'The height will adapt automatically based on its content. Alternatively, the height can be adapt to the height of viewport. Make sure, no height is set in the section settings when using on of the viewport options.',
                                    'default' => 'auto',
                                    'options' => [
                                        'auto' => 'Auto',
                                        'full' => 'Viewport',
                                        'percent' => 'Viewport (Minus 20%)',
                                        'section' => 'Viewport (Minus 50%)'
                                    ]
                                ],
                                'slider_minheight' => [
                                    'type' => 'input.number',
                                    'label' => 'Min Height',
                                    'overridable' => false,
                                    'description' => 'Set the minimum height. This is useful if the content is too large on small devices.',
                                    'min' => 200,
                                    'max' => 800,
                                    'placeholder' => 300
                                ],
                                'column_gap' => [
                                    'type' => 'select.select',
                                    'label' => 'Column Gap',
                                    'description' => 'Set the size of the gap between the grid columns.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'default' => 'Default',
                                        'large' => 'Large',
                                        '' => 'None'
                                    ]
                                ],
                                'slider_divider' => [
                                    'type' => 'select.select',
                                    'label' => 'Dividers',
                                    'description' => 'Display dividers between grid cells.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'column_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Item Width - Set Item Width Mode to FIXED to use width settings.'
                                ],
                                'phone_portrait' => [
                                    'type' => 'select.select',
                                    'label' => 'Phone Portrait',
                                    'description' => 'Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.',
                                    'default' => '1-1',
                                    'options' => [
                                        '1-1' => '100%',
                                        '5-6' => '83%',
                                        '4-5' => '80%',
                                        '3-5' => '60%',
                                        '1-2' => '50%',
                                        '1-3' => '33%',
                                        '1-4' => '25%',
                                        '1-5' => '20%',
                                        '1-6' => '16%'
                                    ]
                                ],
                                'phone_landscape' => [
                                    'type' => 'select.select',
                                    'label' => 'Phone Landscape',
                                    'description' => 'Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Inherit',
                                        '1-1' => '100%',
                                        '5-6' => '83%',
                                        '4-5' => '80%',
                                        '3-5' => '60%',
                                        '1-2' => '50%',
                                        '1-3' => '33%',
                                        '1-4' => '25%',
                                        '1-5' => '20%',
                                        '1-6' => '16%'
                                    ]
                                ],
                                'tablet_landscape' => [
                                    'type' => 'select.select',
                                    'label' => 'Tablet Landscape',
                                    'description' => 'Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.',
                                    'default' => '1-3',
                                    'options' => [
                                        'inherit' => 'Inherit',
                                        '1-1' => '100%',
                                        '5-6' => '83%',
                                        '4-5' => '80%',
                                        '3-5' => '60%',
                                        '1-2' => '50%',
                                        '1-3' => '33%',
                                        '1-4' => '25%',
                                        '1-5' => '20%',
                                        '1-6' => '16%'
                                    ]
                                ],
                                'desktop' => [
                                    'type' => 'select.select',
                                    'label' => 'Desktop',
                                    'description' => 'Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Inherit',
                                        '1-1' => '100%',
                                        '5-6' => '83%',
                                        '4-5' => '80%',
                                        '3-5' => '60%',
                                        '1-2' => '50%',
                                        '1-3' => '33%',
                                        '1-4' => '25%',
                                        '1-5' => '20%',
                                        '1-6' => '16%'
                                    ]
                                ],
                                'large_desktop' => [
                                    'type' => 'select.select',
                                    'label' => 'Large Screens',
                                    'description' => 'Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Inherit',
                                        '1-1' => '100%',
                                        '5-6' => '83%',
                                        '4-5' => '80%',
                                        '3-5' => '60%',
                                        '1-2' => '50%',
                                        '1-3' => '33%',
                                        '1-4' => '25%',
                                        '1-5' => '20%',
                                        '1-6' => '16%'
                                    ]
                                ],
                                'slider_animation_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Animation'
                                ],
                                'slider_animation_set' => [
                                    'type' => 'select.select',
                                    'label' => 'Set',
                                    'description' => 'Slide all visible items at once. Group items into sets. The number of items within a set depends on the defined item width, e.g. 33% means that each set contains 3 items.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'slider_animation_center' => [
                                    'type' => 'select.select',
                                    'label' => 'Center',
                                    'description' => 'Center the active slide.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'slider_animation_finite' => [
                                    'type' => 'select.select',
                                    'label' => 'Finite',
                                    'description' => 'Disable infinite scrolling.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'slider_velocity' => [
                                    'type' => 'input.number',
                                    'label' => 'Velocity',
                                    'description' => 'Set the velocity in pixels per millisecond. Min 20, Max 300',
                                    'min' => 20,
                                    'max' => 300
                                ],
                                'slider_animation_autoplay' => [
                                    'type' => 'select.select',
                                    'label' => 'Autoplay',
                                    'description' => 'Enable autoplay for carousel items.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'slider_pause_onhover' => [
                                    'type' => 'select.select',
                                    'label' => 'Pause On Hover',
                                    'description' => 'Pause autoplay on hover.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'slider_animation_interval' => [
                                    'type' => 'input.number',
                                    'label' => 'Interval',
                                    'description' => 'Set the autoplay interval in seconds. Min 5 Max 15.',
                                    'min' => 5,
                                    'max' => 15,
                                    'placeholder' => 7
                                ],
                                'navigation_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Navigation'
                                ],
                                'navigation' => [
                                    'type' => 'select.select',
                                    'label' => 'Navigation',
                                    'description' => 'Select the navigation type.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'navigation_position' => [
                                    'type' => 'select.select',
                                    'label' => 'Position',
                                    'description' => 'Align the navigation\'s items.',
                                    'default' => 'center',
                                    'options' => [
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right'
                                    ]
                                ],
                                'navigation_margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Set the vertical margin.',
                                    'default' => 'top',
                                    'options' => [
                                        'small-top' => 'Small',
                                        'top' => 'Default',
                                        'medium-top' => 'Medium'
                                    ]
                                ],
                                'navigation_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Breakpoint',
                                    'description' => 'Display the navigation only on this device width and larger.',
                                    'default' => 's',
                                    'options' => [
                                        '' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'navigation_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Color',
                                    'description' => 'Set light or dark color mode.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'show_tooltip' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Show Tooltip',
                                    'description' => 'Display Image ALT as tooltip when hovering.',
                                    'default' => false
                                ],
                                'slidenav_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Slidenav'
                                ],
                                'slidenav_position' => [
                                    'type' => 'select.select',
                                    'label' => 'Position',
                                    'description' => 'Select the position of the slidenav.',
                                    'default' => 'default',
                                    'options' => [
                                        '' => 'None',
                                        'default' => 'Default',
                                        'outside' => 'Outside',
                                        'top-left' => 'Top Left',
                                        'top-right' => 'Top Right',
                                        'center-left' => 'Center Left',
                                        'center-right' => 'Center Right',
                                        'bottom-left' => 'Bottom Left',
                                        'bottom-center' => 'Bottom Center',
                                        'bottom-right' => 'Bottom Right'
                                    ]
                                ],
                                'larger_slidenav' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Larger Style',
                                    'description' => 'To increase the size of the slidenav icons.',
                                    'default' => false
                                ],
                                'slidenav_hover' => [
                                    'type' => 'select.select',
                                    'label' => 'Show on hover only',
                                    'description' => 'Show the slide nav on hover only.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'slidenav_margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Apply a margin between the slidenav and the slider container.',
                                    'default' => 'medium',
                                    'options' => [
                                        '' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large'
                                    ]
                                ],
                                'slidenav_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Breakpoint',
                                    'description' => 'Display the slidenav only on this device width and larger.',
                                    'default' => 's',
                                    'options' => [
                                        '' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'slidenav_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Color',
                                    'description' => 'Set light or dark color mode.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'slidenav_outside_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Outside Breakpoint',
                                    'description' => 'Display the slidenav only outside on this device width and larger. Otherwise it will be displayed inside.',
                                    'default' => 'xl',
                                    'options' => [
                                        '' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'slidenav_outside_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Outside Color',
                                    'description' => 'Set light or dark color if the slidenav is outside of the slider.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'slidenav_icon_info' => [
                                    'type' => 'separator.note',
                                    'content' => 'Custom previous/next icons (replace default Slidenav navigation)'
                                ],
                                'slidenav_icon_left' => [
                                    'type' => 'input.icon',
                                    'label' => 'Previous Icon'
                                ],
                                'slidenav_icon_right' => [
                                    'type' => 'input.icon',
                                    'label' => 'Next Icon'
                                ]
                            ]
                        ],
                        '_tab_overlay' => [
                            'label' => 'Overlay',
                            'overridable' => false,
                            'fields' => [
                                'overlay_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Overlay Settings'
                                ],
                                'overlay_mode' => [
                                    'type' => 'select.select',
                                    'label' => 'Mode',
                                    'description' => 'When using cover mode, you need to set the text color manually.',
                                    'default' => 'cover',
                                    'options' => [
                                        'cover' => 'Cover',
                                        'caption' => 'Caption'
                                    ]
                                ],
                                'overlay_hover' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Display overlay on hover',
                                    'description' => 'Display content overlay on hover.',
                                    'default' => false
                                ],
                                'animate_background' => [
                                    'type' => 'input.checkbox',
                                    'label' => 'Animate background only',
                                    'default' => false
                                ],
                                'overlay_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select the style for the overlay.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'jl-overlay-default' => 'Overlay Default',
                                        'jl-overlay-primary' => 'Overlay Primary',
                                        'jl-tile-default' => 'Tile Default',
                                        'jl-tile-muted' => 'Tile Muted',
                                        'jl-tile-primary' => 'Tile Primary',
                                        'jl-tile-secondary' => 'Tile Secondary'
                                    ]
                                ],
                                'overlay_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Text Color',
                                    'description' => 'Set light or dark color mode for text, buttons and controls.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'None',
                                        'light' => 'Light',
                                        'dark' => 'Dark'
                                    ]
                                ],
                                'overlay_padding' => [
                                    'type' => 'select.select',
                                    'label' => 'Padding',
                                    'description' => 'Set the padding between the overlay and its content.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Default',
                                        'small' => 'Small',
                                        'large' => 'Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'overlay_position' => [
                                    'type' => 'select.select',
                                    'label' => 'Position',
                                    'description' => 'Select the overlay or content position.',
                                    'default' => 'center',
                                    'options' => [
                                        'top' => 'Top',
                                        'bottom' => 'Bottom',
                                        'left' => 'Left',
                                        'right' => 'Right',
                                        'top-left' => 'Top Left',
                                        'top-center' => 'Top Center',
                                        'top-right' => 'Top Right',
                                        'bottom-left' => 'Bottom Left',
                                        'bottom-center' => 'Bottom Center',
                                        'bottom-right' => 'Bottom Right',
                                        'center' => 'Center',
                                        'center-left' => 'Center Left',
                                        'center-right' => 'Center Right'
                                    ]
                                ],
                                'overlay_margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Apply a margin between the overlay and the image container IF the overlay style is Selected.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large'
                                    ]
                                ],
                                'overlay_maxwidth' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width',
                                    'description' => 'Set the maximum content width.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'xxlarge' => 'XX-Large'
                                    ]
                                ],
                                'overlay_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Transition',
                                    'description' => 'Select a transition for the overlay when it appears on hover.',
                                    'default' => 'fade',
                                    'options' => [
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_style' => [
                            'label' => 'Style',
                            'overridable' => false,
                            'fields' => [
                                'image_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Image Style'
                                ],
                                'image_width' => [
                                    'type' => 'input.number',
                                    'label' => 'Width',
                                    'description' => 'Set the width of the image.',
                                    'min' => 0,
                                    'placeholder' => 'auto'
                                ],
                                'image_height' => [
                                    'type' => 'input.number',
                                    'label' => 'Height',
                                    'description' => 'Set the height of the image.',
                                    'min' => 0,
                                    'placeholder' => 'auto'
                                ],
                                'image_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Image Transition',
                                    'description' => 'Select an image transition.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'None',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down'
                                    ]
                                ],
                                'title_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Title Settings'
                                ],
                                'title_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Transition',
                                    'description' => 'Select a transition for the title when the overlay appears on hover.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%'
                                    ]
                                ],
                                'title_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Heading styles differ in font-size but may also come with a predefined color, size and font.',
                                    'default' => 'h3',
                                    'options' => [
                                        'default' => 'None',
                                        'heading-2xlarge' => '2XLarge',
                                        'heading-xlarge' => 'XLarge',
                                        'heading-large' => 'Large',
                                        'heading-medium' => 'Medium',
                                        'heading-small' => 'Small',
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6'
                                    ]
                                ],
                                'title_hover' => [
                                    'type' => 'select.selectize',
                                    'label' => 'Hover Style',
                                    'description' => 'Set the hover style for a linked title. Enable link title to use this option.',
                                    'default' => 'reset',
                                    'selectize' => [
                                        'allowEmptyOption' => true
                                    ],
                                    'options' => [
                                        'reset' => 'None',
                                        'heading' => 'Heading',
                                        '' => 'Default Link'
                                    ]
                                ],
                                'title_decoration' => [
                                    'type' => 'select.select',
                                    'label' => 'Decoration',
                                    'description' => 'Decorate the headline with a divider, bullet or a line that is vertically centered to the heading.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'divider' => 'Divider',
                                        'bullet' => 'Bullet',
                                        'line' => 'Line'
                                    ]
                                ],
                                'predefined_title_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the predefined title color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger',
                                        'background' => 'Background'
                                    ]
                                ],
                                'title_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the title color instead using predefined title color mode.'
                                ],
                                'title_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the title text font size'
                                ],
                                'title_text_transform' => [
                                    'type' => 'select.select',
                                    'label' => 'Transform',
                                    'description' => 'The following options will transform text into uppercased, capitalized or lowercased characters.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Inherit',
                                        'uppercase' => 'Uppercase',
                                        'capitalize' => 'Capitalize',
                                        'lowercase' => 'Lowercase'
                                    ]
                                ],
                                'title_element' => [
                                    'type' => 'select.select',
                                    'label' => 'HTML Element',
                                    'description' => 'Choose one of the elements to fit your semantic structure.',
                                    'default' => 'h3',
                                    'options' => [
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6',
                                        'div' => 'div'
                                    ]
                                ],
                                'title_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'meta_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Meta Settings'
                                ],
                                'meta_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Transition',
                                    'description' => 'Select a transition for the meta when the overlay appears on hover.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%'
                                    ]
                                ],
                                'meta_styles' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Display the meta text in a sentence or a horizontal list.',
                                    'default' => 'sentence',
                                    'options' => [
                                        'sentence' => 'Sentence',
                                        'list' => 'List'
                                    ]
                                ],
                                'meta_subnav_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Subnav Style',
                                    'description' => 'Select the subnav style for Meta list style.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Default',
                                        'divider' => 'Divider'
                                    ]
                                ],
                                'article.display.author.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Author',
                                    'description' => 'Select if the article author should be shown.',
                                    'default' => 'show',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'author_meta' => [
                                    'type' => 'input.text',
                                    'label' => 'Author Meta',
                                    'placeholder' => 'Written by'
                                ],
                                'article.display.date.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Date',
                                    'description' => 'Select if the article date should be shown.',
                                    'default' => 'published',
                                    'options' => [
                                        'created' => 'Show Created Date',
                                        'published' => 'Show Published Date',
                                        'modified' => 'Show Modified Date',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.date.format' => [
                                    'type' => 'select.date',
                                    'label' => 'Date Format',
                                    'description' => 'Select preferred date format. Leave empty not to display a date.',
                                    'default' => 'F d, Y',
                                    'selectize' => [
                                        'allowEmptyOption' => true
                                    ],
                                    'options' => [
                                        'l, F d, Y' => 'Date1',
                                        'l, d F' => 'Date2',
                                        'D, d F' => 'Date3',
                                        'F d' => 'Date4',
                                        'd F' => 'Date5',
                                        'd M' => 'Date6',
                                        'D, M d, Y' => 'Date7',
                                        'D, M d, y' => 'Date8',
                                        'l' => 'Date9',
                                        'l j F Y' => 'Date10',
                                        'j F Y' => 'Date11',
                                        'F d, Y' => 'Date12'
                                    ]
                                ],
                                'date_meta' => [
                                    'type' => 'input.text',
                                    'label' => 'Date Meta',
                                    'placeholder' => 'on'
                                ],
                                'article.display.category.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Category',
                                    'description' => 'Select if and how the article category should be shown.',
                                    'default' => 'link',
                                    'options' => [
                                        'show' => 'Show',
                                        'link' => 'Show with Link',
                                        '' => 'Hide'
                                    ]
                                ],
                                'category_meta' => [
                                    'type' => 'input.text',
                                    'label' => 'Category Meta',
                                    'placeholder' => 'Posted in'
                                ],
                                'article.display.hits.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Hits',
                                    'description' => 'Select if the article hits should be shown.',
                                    'default' => '',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'pre_meta_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger'
                                    ]
                                ],
                                'meta_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the meta color instead using predefined color. You need to set the Predefined Color to None before using the color customization.'
                                ],
                                'meta_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the meta text font size'
                                ],
                                'meta_alignment' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment',
                                    'description' => 'Align the meta text above/below the title or below the content.',
                                    'default' => 'bottom',
                                    'options' => [
                                        'top' => 'Above Title',
                                        'bottom' => 'Below Title',
                                        'content' => 'Below Content'
                                    ]
                                ],
                                'meta_text_transform' => [
                                    'type' => 'select.select',
                                    'label' => 'Transform',
                                    'description' => 'The following options will transform text into uppercased, capitalized or lowercased characters.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Inherit',
                                        'uppercase' => 'Uppercase',
                                        'capitalize' => 'Capitalize',
                                        'lowercase' => 'Lowercase'
                                    ]
                                ],
                                'meta_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'content_settings' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Content Settings'
                                ],
                                'content_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Transition',
                                    'description' => 'Select a transition for the content when the overlay appears on hover.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%'
                                    ]
                                ],
                                'content_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Select a predefined text style, including color, size and font-family.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'lead' => 'Lead'
                                    ]
                                ],
                                'content_text_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger',
                                        'background' => 'Background'
                                    ]
                                ],
                                'customize_content_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the content color instead using predefined text color.'
                                ],
                                'customize_content_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'min' => 0,
                                    'description' => 'Customize the content text font size'
                                ],
                                'content_text_transform' => [
                                    'type' => 'select.select',
                                    'label' => 'Transform',
                                    'description' => 'The following options will transform text into uppercased, capitalized or lowercased characters.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Inherit',
                                        'uppercase' => 'Uppercase',
                                        'capitalize' => 'Capitalize',
                                        'lowercase' => 'Lowercase'
                                    ]
                                ],
                                'content_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ],
                                'link_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Link Settings'
                                ],
                                'link_transition' => [
                                    'type' => 'select.select',
                                    'label' => 'Transition',
                                    'description' => 'Select a transition for the link when the overlay appears on hover.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%'
                                    ]
                                ],
                                'link_type' => [
                                    'type' => 'select.select',
                                    'label' => 'Type',
                                    'description' => 'Show the link as a button or choose between linking just the image and title or the whole item.',
                                    'default' => 'button',
                                    'options' => [
                                        'button' => 'Button',
                                        'content' => 'Title',
                                        'element' => 'Item'
                                    ]
                                ],
                                'buttontarget' => [
                                    'type' => 'select.selectize',
                                    'label' => 'Target',
                                    'description' => 'Open the link in a same or new window.',
                                    'placeholder' => 'Select...',
                                    'default' => '_self',
                                    'options' => [
                                        '_self' => 'Self',
                                        '_blank' => 'New Window'
                                    ]
                                ],
                                'article.display.read_more.label' => [
                                    'type' => 'input.text',
                                    'label' => 'Text',
                                    'description' => 'Specify the button label.',
                                    'default' => 'Read more',
                                    'placeholder' => 'Read More'
                                ],
                                'buttonclass' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Set the button style.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'Button Default',
                                        'primary' => 'Button Primary',
                                        'secondary' => 'Button Secondary',
                                        'danger' => 'Button Danger',
                                        'text' => 'Button Text',
                                        'link' => 'Link',
                                        'link-muted' => 'Link Muted',
                                        'link-text' => 'Link Text'
                                    ]
                                ],
                                'link_button_size' => [
                                    'type' => 'select.select',
                                    'label' => 'Button Size',
                                    'description' => 'Set the button size.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'large' => 'Large'
                                    ]
                                ],
                                'link_margin_top' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin Top',
                                    'description' => 'Set the top margin. Note that the margin will only apply if the content field immediately follows another content field.',
                                    'default' => 'default',
                                    'options' => [
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove' => 'None'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_general' => [
                            'label' => 'General',
                            'overridable' => false,
                            'fields' => [
                                'particle_title_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Particle Title Style'
                                ],
                                'particle_title' => [
                                    'type' => 'input.text',
                                    'label' => 'Title',
                                    'description' => 'Add an optional particle title.',
                                    'placeholder' => 'Enter particle title'
                                ],
                                'particle_title_style' => [
                                    'type' => 'select.select',
                                    'label' => 'Style',
                                    'description' => 'Title styles differ in font-size but may also come with a predefined color, size and font.',
                                    'default' => 'h3',
                                    'options' => [
                                        'default' => 'None',
                                        'heading-2xlarge' => '2XLarge',
                                        'heading-xlarge' => 'XLarge',
                                        'heading-large' => 'Large',
                                        'heading-medium' => 'Medium',
                                        'heading-small' => 'Small',
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6'
                                    ]
                                ],
                                'particle_title_decoration' => [
                                    'type' => 'select.select',
                                    'label' => 'Decoration',
                                    'description' => 'Decorate the headline with a divider, bullet or a line that is vertically centered to the heading.',
                                    'default' => 'none',
                                    'options' => [
                                        'none' => 'None',
                                        'divider' => 'Divider',
                                        'bullet' => 'Bullet',
                                        'line' => 'Line'
                                    ]
                                ],
                                'particle_title_align' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment',
                                    'description' => 'Center, left and right alignment for Particle title.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Inherit',
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right',
                                        'justify' => 'Justify'
                                    ]
                                ],
                                'particle_predefined_color' => [
                                    'type' => 'select.select',
                                    'label' => 'Predefined Color',
                                    'description' => 'Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.',
                                    'default' => 'default',
                                    'options' => [
                                        'default' => 'None',
                                        'muted' => 'Muted',
                                        'emphasis' => 'Emphasis',
                                        'primary' => 'Primary',
                                        'secondary' => 'Secondary',
                                        'success' => 'Success',
                                        'warning' => 'Warning',
                                        'danger' => 'Danger'
                                    ]
                                ],
                                'particle_title_color' => [
                                    'type' => 'input.colorpicker',
                                    'label' => 'Custom Color',
                                    'description' => 'Customize the title color instead using predefined color mode. Set the Predefined color to None before using this color customization mode.'
                                ],
                                'particle_title_fontsize' => [
                                    'type' => 'input.number',
                                    'label' => 'Font Size',
                                    'description' => 'Customize the particle title font size.',
                                    'min' => 0
                                ],
                                'particle_title_element' => [
                                    'type' => 'select.select',
                                    'label' => 'HTML Element',
                                    'description' => 'Choose one of the elements to fit your semantic structure.',
                                    'default' => 'h3',
                                    'options' => [
                                        'h1' => 'H1',
                                        'h2' => 'H2',
                                        'h3' => 'H3',
                                        'h4' => 'H4',
                                        'h5' => 'H5',
                                        'h6' => 'H6',
                                        'div' => 'div'
                                    ]
                                ],
                                'general_content_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'General Particle Settings'
                                ],
                                'align' => [
                                    'type' => 'select.select',
                                    'label' => 'Text Alignment',
                                    'description' => 'Center, left and right alignment may depend on a breakpoint and require a fallback.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right',
                                        'justify' => 'Justify'
                                    ]
                                ],
                                'breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment Breakpoint',
                                    'description' => 'Define the device width from which the alignment will apply.',
                                    'default' => 'always',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'fallback' => [
                                    'type' => 'select.select',
                                    'label' => 'Alignment Fallback',
                                    'description' => 'Define an alignment fallback for device widths below the breakpoint.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right',
                                        'justify' => 'Justify'
                                    ]
                                ],
                                'g_maxwidth' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width',
                                    'description' => 'Set the maximum content width.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'small' => 'Small',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'xxlarge' => 'XX-Large'
                                    ]
                                ],
                                'g_maxwidth_alignment' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width Alignment',
                                    'description' => 'Define the alignment in case the container exceeds the element\'s max-width.',
                                    'default' => 'left',
                                    'options' => [
                                        'left' => 'Left',
                                        'center' => 'Center',
                                        'right' => 'Right'
                                    ]
                                ],
                                'g_maxwidth_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Max Width Breakpoint',
                                    'description' => 'Define the device width from which the element\'s max-width will apply.',
                                    'default' => 'always',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'margin' => [
                                    'type' => 'select.select',
                                    'label' => 'Margin',
                                    'description' => 'Set the vertical margin.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'Keep existing',
                                        'small' => 'Small',
                                        'default' => 'Default',
                                        'medium' => 'Medium',
                                        'large' => 'Large',
                                        'xlarge' => 'X-Large',
                                        'remove-vertical' => 'None'
                                    ]
                                ],
                                'visibility' => [
                                    'type' => 'select.select',
                                    'label' => 'Visibility',
                                    'description' => 'Display the element only on this device width and larger.',
                                    'default' => '',
                                    'options' => [
                                        '' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ],
                                'general_animation_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Animation Settings'
                                ],
                                'animation' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation',
                                    'description' => 'Apply an animation to particles once they enter the viewport. This will animate all particles inside the section.',
                                    'default' => 'inherit',
                                    'options' => [
                                        'inherit' => 'None',
                                        'fade' => 'Fade',
                                        'scale-up' => 'Scale Up',
                                        'scale-down' => 'Scale Down',
                                        'slide-top-small' => 'Slide Top Small',
                                        'slide-bottom-small' => 'Slide Bottom Small',
                                        'slide-left-small' => 'Slide Left Small',
                                        'slide-right-small' => 'Slide Right Small',
                                        'slide-top-medium' => 'Slide Top Medium',
                                        'slide-bottom-medium' => 'Slide Bottom Medium',
                                        'slide-left-medium' => 'Slide Left Medium',
                                        'slide-right-medium' => 'Slide Right Medium',
                                        'slide-top' => 'Slide Top 100%',
                                        'slide-bottom' => 'Slide Bottom 100%',
                                        'slide-left' => 'Slide Left 100%',
                                        'slide-right' => 'Slide Right 100%',
                                        'parallax' => 'Parallax'
                                    ]
                                ],
                                'animation_delay' => [
                                    'type' => 'input.number',
                                    'label' => 'Animation Delay',
                                    'description' => 'Set the delay animations for particle. Delay time in ms.',
                                    'min' => 0,
                                    'placeholder' => 200
                                ],
                                'animation_repeat' => [
                                    'type' => 'select.select',
                                    'label' => 'Animation Repeat',
                                    'description' => 'Repeat an animation to particle once it enter the viewport.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_parallax_animation' => [
                            'label' => 'Parallax',
                            'overridable' => false,
                            'fields' => [
                                'parallax_info' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'To configure a parallax animation, make sure to set the Animation to Parallax in the <i>General</i> tab. <a href="https://joomlead.com/gantry-5-particles/particles-documentation/#parallax-settings" target="_blank">Learn more</a>'
                                ],
                                'pa_horizontal_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal Start',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min -600 and Max 600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_horizontal_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Horizontal End',
                                    'description' => 'Animate the horizontal position (translateX) in pixels. Min -600 and Max 600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_vertical_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical Start',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min -600 and Max 600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'pa_vertical_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Vertical End',
                                    'description' => 'Animate the vertical position (translateY) in pixels. Min -600 and Max 600.',
                                    'min' => -600,
                                    'max' => 600,
                                    'placeholder' => 0
                                ],
                                'scale_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale Start',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. Min 50 and Max 200',
                                    'min' => 50,
                                    'max' => 200,
                                    'placeholder' => 100
                                ],
                                'scale_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Scale End',
                                    'description' => 'Animate the scaling. 100 means 100% scale, 200 means 200% scale, and 50 means 50% scale. Min 50 and Max 200',
                                    'min' => 50,
                                    'max' => 200,
                                    'placeholder' => 100
                                ],
                                'rotate_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate Start',
                                    'description' => 'Animate the rotation clockwise in degrees. Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'rotate_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Rotate End',
                                    'description' => 'Animate the rotation clockwise in degrees. Min 0 and Max 360',
                                    'min' => 0,
                                    'max' => 360,
                                    'placeholder' => 0
                                ],
                                'opacity_start' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity Start',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'opacity_end' => [
                                    'type' => 'input.number',
                                    'label' => 'Opacity End',
                                    'description' => 'Animate the opacity. 100 means 100% opacity, 0 means 0% opacity and 50 means 50%. Min 0 and Max 100',
                                    'min' => 0,
                                    'max' => 100,
                                    'placeholder' => 100
                                ],
                                'easing' => [
                                    'type' => 'input.number',
                                    'label' => 'Easing',
                                    'description' => 'Determine how the speed of the animation behaves over time. A value below 100 is faster in the beginning and slower towards the end while a value above 100 behaves inversely. Min 10 and Max 200',
                                    'min' => 10,
                                    'max' => 200,
                                    'placeholder' => 10
                                ],
                                'pa_viewport' => [
                                    'type' => 'input.number',
                                    'label' => 'Viewport',
                                    'description' => 'Set the animation end point relative to viewport height, e.g. 50 for 50% of the viewport. Min 10 and Max 100',
                                    'min' => 10,
                                    'max' => 100,
                                    'placeholder' => 50
                                ],
                                'pa_breakpoint' => [
                                    'type' => 'select.select',
                                    'label' => 'Breakpoint',
                                    'description' => 'Display the parallax effect only on this device width and larger.',
                                    'default' => 'always',
                                    'options' => [
                                        'always' => 'Always',
                                        's' => 'Small (Phone Landscape)',
                                        'm' => 'Medium (Tablet Landscape)',
                                        'l' => 'Large (Desktop)',
                                        'xl' => 'X-Large (Large Screens)'
                                    ]
                                ]
                            ]
                        ]
                    ]
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-success',
                    'content' => 'Carousel Joomla <strong>Version: 2.1.3</strong> Copyright (C) <a href="https://joomlead.com/" target="_blank">https://joomlead.com</a> | <a href="https://joomlead.com/g5/docs/carousel-joomla-particle/" target="_blank">Documentation</a>'
                ]
            ]
        ]
    ]
];
