<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Controller;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use OSL\Controller\AdminController as AdminController;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;

defined('_JEXEC') or die;

class Controller extends AdminController
{
	/**
	 * Display information
	 *
	 */
	public function display($cachable = false, array $urlparams = array())
	{
		$document   = $this->container->document;
		$rootUri    = Uri::root(true);
		$isAdminApp = $this->container->app->isClient('administrator');

		if ($isAdminApp)
		{
			$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/admin/assets/css/style.css');
		}
		else
		{
			$config = HelpdeskproHelper::getConfig();

			if ($config->load_twttier_bootstrap_framework_in_frontend !== '0')
			{
				$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/bootstrap/css/bootstrap.css');
			}

			$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/css/style.css');
		}

		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/css/common.css');

		// Dropzone JS
		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/dropzone/basic.min.css');
		$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/dropzone/dropzone.min.css');


		$customCssFile = JPATH_ROOT . '/media/com_helpdeskpro/assets/css/custom.css';

		if (file_exists($customCssFile) && filesize($customCssFile))
		{
			$document->addStyleSheet($rootUri . '/media/com_helpdeskpro/assets/css/custom.css');
		}

		// Always load jquery
		HTMLHelper::_('jquery.framework');

		HTMLHelper::_('script', 'media/com_helpdeskpro/assets/js/helpdeskpro.min.js', false, false);

		// Dropzone JS
		HTMLHelper::_('script', 'media/com_helpdeskpro/assets/dropzone/dropzone.min.js', false, false);

		parent::display($cachable, $urlparams);

		if ($isAdminApp && $this->input->getCmd('format', 'html') != 'raw')
		{
			HelpdeskproHelper::displayCopyRight();
		}
	}

	/**
	 * Method to make a custom field search and sortable
	 *
	 */
	public function make_field_search_sort_able()
	{
		$db      = Factory::getDbo();
		$query   = $db->getQuery(true);
		$fieldId = $this->input->getInt('field_id');

		$query->select('*')
			->from('#__helpdeskpro_fields')
			->where('id = ' . (int) $fieldId);
		$db->setQuery($query);
		$field = $db->loadObject();

		if (!$field)
		{
			throw new \Exception('The field does not exist');
		}

		// Add new field to #__eb_registrants
		$fields = array_keys($db->getTableColumns('#__helpdeskpro_tickets'));

		if (!in_array($field->name, $fields))
		{
			$sql = "ALTER TABLE  `#__helpdeskpro_tickets` ADD  `$field->name` VARCHAR( 255 ) NULL;";
			$db->setQuery($sql)
				->execute();

			$query->clear()
				->select('*')
				->from('#__helpdeskpro_field_value')
				->where('field_id = ' . $fieldId);
			$db->setQuery($query);
			$rows = $db->loadObjectList();

			$fieldName = $db->quoteName($field->name);

			foreach ($rows as $row)
			{
				$query->clear()
					->update('#__helpdeskpro_tickets')
					->set($fieldName . ' = ' . $db->quote($row->field_value))
					->where('id = ' . $row->ticket_id);
				$db->setQuery($query);
				$db->execute();
			}
		}

		// Mark the field as searchable
		$query->clear()
			->update('#__helpdeskpro_fields')
			->set('is_searchable = 1')
			->where('id = ' . (int) $fieldId);
		$db->setQuery($query);
		$db->execute();

		echo sprintf('Field %s is not searchable in Tickets Management', $fieldId);
	}

	/**
	 * Upgrade database schema
	 */
	public function upgrade()
	{
		require_once JPATH_COMPONENT . '/script.helpdeskpro.php';

		\com_helpdeskproInstallerScript::updateDatabaseSchema();
	}
} 