<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\Model;

use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
use Joomla\Registry\Registry;
use OSL\Model\Model;

defined('_JEXEC') or die;

class Language extends Model
{
	protected function initialize()
	{
		$this->state->insert('filter_language', 'string', 'en-GB')
			->insert('filter_search', 'string', '');
	}

	/**
	 * Get language items and store them in an array
	 *
	 */
	public function getTrans()
	{
		$registry  = new Registry;
		$languages = [];
		$language  = $this->state->filter_language;
		$item      = 'com_helpdeskpro';
		$path      = JPATH_ROOT . '/language/en-GB/en-GB.' . $item . '.ini';
		$registry->loadFile($path, 'INI');
		$languages['en-GB'][$item] = $registry->toArray();

		if ($language != 'en-GB')
		{
			$path = JPATH_ROOT . '/language/' . $language . '/' . $language . '.' . $item . '.ini';

			if (File::exists($path))
			{
				$registry->loadFile($path);
				$languages[$language][$item] = $registry->toArray();
			}
			else
			{
				$languages[$language][$item] = [];
			}
		}

		return $languages;
	}

	/**
	 *  Get site languages
	 *
	 */
	public function getSiteLanguages()
	{
		jimport('joomla.filesystem.folder');

		$path    = JPATH_ROOT . '/language';
		$folders = Folder::folders($path);
		$result  = [];

		foreach ($folders as $folder)
		{
			if ($folder == 'pdf_fonts' || $folder == 'overrides')
			{
				continue;
			}

			$result[] = $folder;
		}

		return $result;
	}

	/**
	 * Save translation data
	 *
	 * @param array $data
	 */
	public function store($data)
	{
		$lang     = $data['filter_language'];
		$item     = 'com_helpdeskpro';
		$lang     = basename($lang);
		$filePath = JPATH_ROOT . '/language/' . $lang . '/' . $lang . '.' . $item . '.ini';
		$registry = new Registry;
		$keys     = $data['keys'];

		foreach ($keys as $key)
		{
			$value = $data[$key];
			$registry->set($key, addcslashes($value, '"'));
		}

		if (!empty($data['new_keys']))
		{
			for ($i = 0, $n = count($data['new_keys']); $i < $n; $i++)
			{
				$key   = $data['new_keys'][$i];
				$value = $data['new_values'][$i];

				if ($key && $value)
				{
					$registry->set($key, addcslashes($value, '"'));
				}
			}
		}

		File::write($filePath, $registry->toString('INI'));
	}
}