<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

JFormHelper::loadFieldClass('list');

class JFormFieldHelpdeskProArticle extends JFormFieldList
{
	/**
	 * The form field type.
	 *
	 * @var string
	 */
	protected $type = 'helpdeskproarticle';

	/**
	 * Get list of avaialble articles for selection
	 *
	 * @return array
	 */
	protected function getOptions()
	{
		$db    = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('id', 'value'))
			->select($db->quoteName('title', 'text'))
			->from('#__helpdeskpro_articles')
			->where('published = 1');
		$db->setQuery($query);

		$options   = array();
		$options[] = HTMLHelper::_('select.option', '0', Text::_('Select Articles'));

		return array_merge($options, $db->loadObjectList());
	}
}
