<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;

$editor       = Editor::getInstance(Factory::getConfig()->get('editor'));
$translatable = Multilanguage::isEnabled() && count($this->languages);

if (HelpdeskproHelper::isJoomla4())
{
	$tabApiPrefix = 'uitab.';
}
else
{
	$tabApiPrefix = 'bootstrap.';
}
?>
<form action="index.php?option=com_helpdeskpro&view=article" method="post" name="adminForm" id="adminForm" class="form form-horizontal">
    <?php
        if ($translatable)
        {
	        echo HTMLHelper::_($tabApiPrefix . 'startTabSet', 'article', array('active' => 'general-page'));
	        echo HTMLHelper::_($tabApiPrefix . 'addTab', 'article', 'general-page', Text::_('HDP_GENERAL', true));
        }
        ?>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_TITLE'); ?>
            </div>
            <div class="controls">
                <input class="input-xxlarge form-control" type="text" name="title" id="title" size="40" maxlength="250"
                       value="<?php echo $this->item->title; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_ALIAS'); ?>
            </div>
            <div class="controls">
                <input class="form-control" type="text" name="alias" id="alias" size="40" maxlength="250"
                       value="<?php echo $this->item->alias; ?>"/>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo  Text::_('HDP_CATEGORY'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['category_id']; ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_TEXT'); ?>
            </div>
            <div class="controls">
                <?php echo $editor->display('text', $this->item->text, '100%', '250', '75', '10'); ?>
            </div>
        </div>
        <div class="control-group">
            <div class="control-label">
                <?php echo Text::_('HDP_PUBLISHED'); ?>
            </div>
            <div class="controls">
                <?php echo $this->lists['published']; ?>
            </div>
        </div>
        <?php
        if ($translatable)
        {
	        echo HTMLHelper::_($tabApiPrefix . 'endTab');
	        echo $this->loadTemplate('translation', ['editor' => $editor]);
	        echo HTMLHelper::_($tabApiPrefix . 'endTabSet');
        }
        ?>
		<?php echo HTMLHelper::_('form.token'); ?>
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<input type="hidden" name="task" value=""/>
</form>