<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

HTMLHelper::_('bootstrap.tooltip');

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('formbehavior.chosen', 'select');
}

$ordering = ($this->state->filter_order == 'tbl.ordering');

if ($ordering)
{
	$saveOrderingUrl = 'index.php?option=com_helpdeskpro&task=category.save_order_ajax';

	if (HelpdeskproHelper::isJoomla4())
	{
		\Joomla\CMS\HTML\HTMLHelper::_('draggablelist.draggable');
	}
	else
	{
		HTMLHelper::_('sortablelist.sortable', 'categoryList', 'adminForm', strtolower($this->state->filter_order_Dir), $saveOrderingUrl, false, true);
	}
}

$customOptions = array(
	'filtersHidden'       => true,
	'defaultLimit'        => $this->container->appConfig->get('list_limit', 20),
	'searchFieldSelector' => '#filter_search',
	'orderFieldSelector'  => '#filter_full_ordering'
);
HTMLHelper::_('searchtools.form', '#adminForm', $customOptions);

$this->ordering = array();

if (count($this->items))
{
	foreach ($this->items as &$item)
	{
		$this->ordering[$item->parent_id][] = $item->id;
	}
}
?>
<form action="index.php?option=com_helpdeskpro&view=categories" method="post" name="adminForm" id="adminForm">
	<div class="row-fluid">
		<div id="j-sidebar-container" class="span2">
			<?php echo $this->sidebar; ?>
		</div>
		<div id="j-main-container" class="span10">
			<div id="filter-bar" class="btn-toolbar js-stools">
				<div class="filter-search btn-group pull-left">
					<label for="filter_search"
					       class="element-invisible"><?php echo Text::_('HDP_SEARCH_CATEGORIES_DESC'); ?></label>
					<input type="text" name="filter_search" id="filter_search"
					       placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>"
					       value="<?php echo $this->escape($this->state->filter_search); ?>" class="hasTooltip form-control"
					       title="<?php echo HTMLHelper::tooltipText('HDP_FILTER_SEARCH_CATEGORIES_DESC'); ?>"/>
				</div>
				<div class="btn-group pull-left">
					<button type="submit" class="btn hasTooltip"
					        title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><span
							class="icon-search"></span></button>
					<button type="button" class="btn hasTooltip"
					        title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_CLEAR'); ?>"
					        onclick="document.getElementById('filter_search').value='';this.form.submit();"><span
							class="icon-remove"></span></button>
				</div>
				<div class="btn-group pull-right hidden-phone">
					<?php echo $this->lists['filter_parent_id']; ?>
					<?php echo $this->lists['filter_category_type']; ?>
					<?php echo $this->lists['filter_state']; ?>
				</div>
			</div>
			<div class="clearfix"></div>
			<table class="adminlist table table-striped" id="categoryList">
				<thead>
				<tr>
					<th width="1%" class="nowrap center hidden-phone">
						<?php echo HTMLHelper::_('searchtools.sort', '', 'tbl.ordering', $this->state->filter_order_Dir, $this->state->filter_order, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
					</th>
					<th width="20">
						<input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);"/>
					</th>
					<th class="title">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_TITLE'), 'tbl.title', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="title">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_CATEGORY_TYPE'), 'tbl.category_type', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="title" width="15%">
						<?php echo Text::_('HDP_NUMBER_TICKETS'); ?>
					</th>
					<th width="5%">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_PUBLISHED'), 'tbl.published', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th width="2%">
						<?php echo HTMLHelper::_('searchtools.sort', Text::_('HDP_ID'), 'tbl.id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
				</tr>
				</thead>
				<tfoot>
				<tr>
					<td colspan="7">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
				</tfoot>
                <tbody <?php if ($ordering) :?> class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" data-nested="false"<?php endif; ?>>
				<?php
				$k             = 0;
				$categoryTypes = array(
					0 => Text::_('HDP_BOTH'),
					1 => Text::_('HDP_TICKETS'),
					2 => Text::_('HDP_KNOWLEDGE_BASE'),
				);
				for ($i = 0, $n = count($this->items); $i < $n; $i++)
				{
					$row       = $this->items[$i];
					$link      = Route::_('index.php?option=com_helpdeskpro&view=category&id=' . $row->id);
					$checked   = HTMLHelper::_('grid.id', $i, $row->id);
					$published = HTMLHelper::_('jgrid.published', $row->published, $i);

					// Get the parents of item for sorting
					if ($row->level > 1)
					{
						$parentsStr = "";
						$_currentParentId = $row->parent_id;
						$parentsStr = " " . $_currentParentId;
						for ($i2 = 0; $i2 < $row->level; $i2++)
						{
							foreach ($this->ordering as $k => $v)
							{
								$v = implode("-", $v);
								$v = "-" . $v . "-";
								if (strpos($v, "-" . $_currentParentId . "-") !== false)
								{
									$parentsStr .= " " . $k;
									$_currentParentId = $k;
									break;
								}
							}
						}
					}
					else
					{
						$parentsStr = "";
					}

					if (HelpdeskproHelper::isJoomla4())
                    {
                    ?>
                        <tr class="row<?php echo $i % 2; ?>" data-draggable-group="<?php echo $row->parent_id; ?>" item-id="<?php echo $row->id ?>" parents="<?php echo $parentsStr ?>" level="<?php echo $row->level ?>">
                    <?php
                    }
					else
                    {
                    ?>
                        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $row->parent_id; ?>" item-id="<?php echo $row->id ?>" parents="<?php echo $parentsStr ?>" level="<?php echo $row->level ?>">
                    <?php
                    }
					?>
						<td class="order nowrap center hidden-phone">
							<?php
							$iconClass = '';

							if (!$ordering)
							{
								$iconClass = ' inactive tip-top hasTooltip"';
							}
							?>
							<span class="sortable-handler<?php echo $iconClass ?>">
						<i class="icon-menu"></i>
						</span>
							<?php if ($ordering) : ?>
								<input type="text" style="display:none" name="order[]" size="5" value="<?php echo $row->ordering ?>" class="width-20 text-area-order "/>
							<?php endif; ?>
						</td>
						<td>
							<?php echo $checked; ?>
						</td>
						<td>
							<a href="<?php echo $link; ?>">
								<?php echo $row->treename; ?>
							</a>
						</td>
						<td>
							<?php echo $categoryTypes[$row->category_type]; ?>
						</td>
						<td class="center">
							<?php echo $row->total_tickets; ?>
						</td>
						<td class="center">
							<?php echo $published; ?>
						</td>
						<td class="center">
							<?php echo $row->id; ?>
						</td>
					</tr>
					<?php
					$k = 1 - $k;
				}
				?>
				</tbody>
			</table>
		</div>
	</div>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->state->filter_order; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->state->filter_order_Dir; ?>"/>
	<input type="hidden" id="filter_full_ordering" name="filter_full_ordering" value=""/>
	<?php echo HTMLHelper::_('form.token'); ?>
</form>