<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;

ToolbarHelper::title(   Text::_( 'Translation management'), 'generic.png' );

ToolbarHelper::addNew('new_item', 'New Item');
ToolbarHelper::apply('apply', 'JTOOLBAR_APPLY');
ToolbarHelper::save('save');
ToolbarHelper::cancel('cancel');

$pullLeft  = 'pull-left';
$pullRight = 'pull-right';

HTMLHelper::_('jquery.framework');
HTMLHelper::_('behavior.core');

Factory::getDocument()->addScript(Uri::root(true).'/media/com_helpdeskpro/js/admin-language-default.js');
?>
<form action="index.php?option=com_helpdeskpro&view=language" method="post" name="adminForm" id="adminForm">
    <div id="j-main-container">
        <div id="filter-bar" class="btn-toolbar">
            <div class="filter-search btn-group pull-left">
                <label for="filter_search" class="element-invisible"><?php echo Text::_('EB_FILTER_SEARCH_LANGUAGE_DESC');?></label>
                <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->filter_search); ?>" class="hasTooltip" title="<?php echo HTMLHelper::tooltipText('EB_SEARCH_LANGUAGE_DESC'); ?>" />
            </div>
            <div class="btn-group pull-left">
                <button id="pf-clear-button" type="button" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_CLEAR'); ?>"><span class="icon-remove"></span></button>
            </div>
            <div class="btn-group pull-right">
				<?php
				echo $this->lists['filter_item'];
				echo $this->lists['filter_language'];
				?>
            </div>
        </div>
        <div class="clearfix"></div>
        <table class="table table-striped" id="lang_table">
            <thead>
            <tr>
                <th class="key" style="width:20%; text-align: left;">Key</th>
                <th class="key" style="width:40%; text-align: left;">Original</th>
                <th class="key" style="width:40%; text-align: left;">Translation</th>
            </tr>
            </thead>
            <tbody id="pf-translation-table">
			<?php
			$original = $this->trans['en-GB'][$this->item] ;
			$trans = $this->trans[$this->lang][$this->item] ;


			foreach ($original as  $key=>$value) {
				?>
                <tr>
                    <td class="key" style="text-align: left;"><?php echo $key; ?></td>
                    <td style="text-align: left;"><?php echo $value; ?></td>
                    <td>
						<?php
						if (isset($trans[$key])) {
							$translatedValue = $trans[$key];
							$missing = false ;
						} else {
							$translatedValue = $value;
							$missing = true ;
						}
						?>
                        <input type="hidden" name="keys[]" value="<?php echo $key; ?>" />
                        <input type="text" name="<?php echo $key; ?>" class="input-xxlarge" size="100" value="<?php echo $translatedValue; ; ?>" />
						<?php
						if ($missing) {
							?>
                            <span style="color:red;">*</span>
							<?php
						}
						?>
                    </td>
                </tr>
				<?php
			}
			?>
            </tbody>
        </table>
        <input type="hidden" name="task" value="" />
		<?php echo HTMLHelper::_( 'form.token' ); ?>
    </div>
</form>