<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

$cbIntegration = file_exists(JPATH_ROOT . '/components/com_comprofiler/comprofiler.php');
$editor        = Editor::getInstance(Factory::getConfig()->get('editor'));
$user          = Factory::getUser();
$document      = Factory::getDocument();
$rootUri       = Uri::root(true);

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('formbehavior.chosen', 'select');
}

HTMLHelper::_('behavior.keepalive');
HTMLHelper::_('behavior.core');

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('behavior.modal', 'a.hdp-modal');
}

if (!$this->config->use_html_editor && $this->config->process_bb_code)
{
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/jquery.selection.js');
	$document->addScript($rootUri . '/media/com_helpdeskpro/assets/js/helpdeskpro.bbcode.js');
}

$document->addScript($rootUri . '/media/com_helpdeskpro/js/admin-ticket-default.js');

Text::script('HDP_ENTER_COMMENT_FOR_TICKET', true);

$maxNumberOfFiles     = $this->config->max_number_attachments ? $this->config->max_number_attachments : 1;
$this->captchaInvalid = false;
?>
<div id="hdp_container" class="container-fluid">
	<form action="index.php?option=com_helpdeskpro&view=ticket" method="post" name="adminForm" id="adminForm"
	      enctype="multipart/form-data" class="form form-horizontal">
		<!--Toolbar buttons-->
		<div class="row-fluid admintable">
			<?php
				$layoutData = array(
					'categories'    => $this->categories,
					'rowStatuses'   => $this->rowStatuses,
					'rowPriorities' => $this->rowPriorities,
					'isCustomer'    => false,
					'item'          => $this->item,
					'user'          => $user,
					'rowLabels'     => $this->rowLabels,
					'convertToKb'	=> $this->canConvertToKb
				);
				echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/toolbar.php', $layoutData);
			?>
		</div>
		<div class="row-fluid">
			<div id="hdp_left_panel">
				<table class="adminform" width="100%">
					<tr>
						<td style="padding-bottom: 15px;">
							<strong>
								[#<?php echo $this->item->id ?>] - <?php echo $this->item->subject; ?>
							</strong>
						</td>
					</tr>
					<tr>
						<td>
							<?php
							$layoutData = array(
								'item'    => $this->item,
								'rootUri' => $rootUri,
								'config'  => $this->config
							);
							echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_detail.php', $layoutData);
							?>
						</td>
					</tr>
					<tr>
						<th>
							<h2 class="hdp_heading hdp_comments_heading"><?php echo Text::_('HDP_COMMENTS'); ?>
								<a href="javascript:HDP.showMessageBox();">
									<span id="hdp_add_comment_link"><?php echo Text::_('HDP_ADD_COMMENT'); ?></span>
									<img width="32" height="32"
									     src="<?php echo $rootUri . '/media/com_helpdeskpro/assets/images/icons/icon_add.jpg' ?>">
								</a>
							</h2>
						</th>
					</tr>
					<?php
					$layoutData = array(
						'canComment' => true,
						'captchaInvalid' => false,
						'config'    => $this->config,
						'maxNumberOfFiles' => $maxNumberOfFiles,
						'rootUri' => $rootUri,
						'editor' => $editor,
						'message' => '',
						'captcha' => isset($this->captcha) ? $this->captcha : ''
					);

					// Comment form
					echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_add_comment.php', $layoutData);

					// List of comments
					$layoutData = array(
						'messages'      => $this->messages,
						'user'          => $user,
						'cbIntegration' => $cbIntegration,
						'rootUri'       => $rootUri,
						'config'        => $this->config
					);
					echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_comments.php', $layoutData);
					?>
				</table>
			</div>
			<div id="hdp_right_panel" class="span3">
				<?php
				// Customer information
				$layoutData = array(
					'item'        => $this->item,
					'fields'      => $this->fields,
					'fieldValues' => $this->fieldValues,
					'rootUri'     => $rootUri,
					'config'      => $this->config,
					'results'     => $this->results
				);

				echo HelpdeskproHelperHtml::loadCommonLayout('common/tmpl/ticket_customer_info.php', $layoutData);
				?>
			</div>
		</div>
		<input type="hidden" name="option" value="com_helpdeskpro"/>
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>"/>
		<input type="hidden" name="task" value=""/>
		<input type="hidden" name="new_value" value="0"/>
		<?php echo HTMLHelper::_('form.token'); ?>
	</form>
</div>