<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Tickets;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Utilities\ArrayHelper;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskproHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

defined('_JEXEC') or die;

/***
 * @property \OSSolution\HelpdeskPro\Admin\Model\Tickets $model
 */
class Html extends \OSL\View\ListView
{
	protected function beforeRender()
	{
		parent::beforeRender();

		$user = $this->container->user;

		$config = HelpdeskproHelper::getConfig();

		// Category filter
		$filters = array();

		if (!$user->authorise('core.admin', 'com_helpdeskpro'))
		{
			$managedCategoryIds = HelpdeskproHelper::getTicketCategoryIds($user->get('username'));
			$managedCategoryIds = ArrayHelper::toInteger($managedCategoryIds);

			$filters[] = 'id IN (' . implode(',', $managedCategoryIds) . ')';
		}
		$rows = HelpdeskproHelperDatabase::getAllCategories('title', $filters);

		$this->lists['filter_category_id'] = HelpdeskproHelperHtml::buildCategoryDropdown($this->state->filter_category_id, 'filter_category_id', 'class="input-large form-select" onchange="submit();"', $rows);

		// Ticket status filter
		$rowStatuses = HelpdeskproHelperDatabase::getAllStatuses();

		if (count($rowStatuses))
		{
			$options   = array();
			$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_TICKET_STATUS'), 'id', 'title');
			$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_ALL_STATUSES'), 'id', 'title');
			$options   = array_merge($options, $rowStatuses);

			$this->lists['filter_status_id'] = HTMLHelper::_('select.genericlist', $options, 'filter_status_id',
				array(
					'option.text.toHtml' => false,
					'option.text'        => 'title',
					'option.key'         => 'id',
					'list.attr'          => 'class="input-medium form-select" onchange="submit();"',
					'list.select'        => $this->state->filter_status_id));
		}

		// Ticket priority filter
		$rowPriorities = HelpdeskproHelperDatabase::getAllPriorities();

		if (count($rowPriorities))
		{
			$options   = array();
			$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_ALL_PRIORITIES'), 'id', 'title');
			$options   = array_merge($options, $rowPriorities);

			$this->lists['filter_priority_id'] = HTMLHelper::_('select.genericlist', $options, 'filter_priority_id',
				array(
					'option.text.toHtml' => false,
					'option.text'        => 'title',
					'option.key'         => 'id',
					'list.attr'          => 'class="input-medium form-select" onchange="submit();"',
					'list.select'        => $this->state->filter_priority_id));
		}

		$statusList = array();

		foreach ($rowStatuses as $status)
		{
			$statusList[$status->id] = $status->title;
		}

		$priorityList = array();

		foreach ($rowPriorities as $priority)
		{
			$priorityList[$priority->id] = $priority->title;
		}

		// Label filter
		$rowLabels = HelpdeskproHelperDatabase::getAllLabels();

		if (count($rowLabels))
		{
			$options                        = array();
			$options[]                      = HTMLHelper::_('select.option', 0, Text::_('HDP_SELECT_LABEL'), 'id', 'title');
			$options                        = array_merge($options, $rowLabels);
			$this->lists['filter_label_id'] = HTMLHelper::_('select.genericlist', $options, 'filter_label_id',
				array(
					'option.text.toHtml' => false,
					'option.text'        => 'title',
					'option.key'         => 'id',
					'list.attr'          => 'class="input-medium form-select" onchange="submit();"',
					'list.select'        => $this->state->filter_label_id));
		}

		/**
		 * Filter ticket by staff
		 */
		if (PluginHelper::isEnabled('helpdeskpro', 'assignticket'))
		{
			$staffDisplayField              = $config->get('staff_display_field', 'username') ?: 'username';
			$staffs                         = HelpdeskproHelperDatabase::getAllStaffs($config->staff_group_id);
			$options                        = array();
			$options[]                      = HTMLHelper::_('select.option', 0, Text::_('HDP_SELECT_STAFF'), 'id', $staffDisplayField);
			$options                        = array_merge($options, $staffs);
			$this->lists['filter_staff_id'] = HTMLHelper::_('select.genericlist', $options, 'filter_staff_id', 'class="input-medium form-select" onchange="submit();"', 'id', $staffDisplayField, $this->state->filter_staff_id);

			$rowStaffs = array();

			foreach ($staffs as $staff)
			{
				$rowStaffs[$staff->id] = $staff->{$staffDisplayField};
			}

			$this->staffs          = $rowStaffs;
			$this->showStaffColumn = true;
		}

		$this->fields       = HelpdeskproHelperDatabase::getFieldsOnListView();
		$this->fieldValues  = $this->model->getFieldsData($this->fields);
		$this->statusList   = $statusList;
		$this->priorityList = $priorityList;
		$this->config       = $config;

		return true;
	}

	/**
	 * Override addToolbar method to add custom toolbar for tickets management
	 */
	protected function addToolbar()
	{
		ToolbarHelper::title(Text::_('HDP_TICKET_MANAGEMENT'), 'link tickets');
		ToolbarHelper::addNew('ticket.add');
		ToolbarHelper::deleteList(Text::_('HDP_DELETE_CONFIRM'), 'ticket.delete');
		ToolbarHelper::custom('ticket.export', 'download', 'download', 'Export Tickets', false);

		if ($this->container->user->authorise('core.admin', 'com_helpdeskpro'))
		{
			ToolbarHelper::preferences('com_helpdeskpro');
		}
	}
}