<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$ordering = $this->state->filter_order == 'tbl.ordering';

HTMLHelper::_('bootstrap.tooltip');

if (!HelpdeskproHelper::isJoomla4())
{
	HTMLHelper::_('formbehavior.chosen', 'select');
}
?>
<form action="index.php?option=com_helpdeskpro&view=tickets" method="post" name="adminForm" id="adminForm">
	<div class="row-fluid">
		<div id="j-sidebar-container" class="span2">
			<?php echo $this->sidebar; ?>
		</div>
		<div id="j-main-container" class="span10">
			<div id="filter-bar" class="btn-toolbar">
				<div class="filter-search btn-group pull-left">
					<label for="filter_search" class="element-invisible"><?php echo Text::_('HDP_SEARCH_TICKETS_DESC');?></label>
					<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo Text::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->filter_search); ?>" class="hasTooltip form-control" title="<?php echo HTMLHelper::tooltipText('HDP_FILTER_SEARCH_TICKETS_DESC'); ?>" />
				</div>
				<div class="btn-group pull-left">
					<button type="submit" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>"><span class="icon-search"></span></button>
					<button type="button" class="btn hasTooltip" title="<?php echo HTMLHelper::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><span class="icon-remove"></span></button>
				</div>
				<div class="btn-group pull-right hidden-phone">
					<?php
						echo $this->lists['filter_category_id'];

						if (isset($this->lists['filter_status_id']))
						{
							echo $this->lists['filter_status_id'];
						}

						if (isset($this->lists['filter_priority_id']))
						{
							echo $this->lists['filter_priority_id'];
						}

						if (isset($this->lists['filter_label_id']))
						{
							echo $this->lists['filter_label_id'];
						}

						if (!empty($this->showStaffColumn))
						{
							echo $this->lists['filter_staff_id'];
						}
					?>
				</div>
			</div>
			<div class="clearfix"></div>
			<table class="adminlist table table-striped">
				<thead>
				<tr>
					<th width="5">
						<?php echo Text::_('NUM'); ?>
					</th>
					<th width="20">
						<input type="checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);"/>
					</th>
					<th class="title" style="text-align: left;">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_TITLE'), 'tbl.subject', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="title" style="text-align: left;">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_CATEGORY'), 'tbl.category_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="title" style="text-align: left;">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_USER'), 'c.username', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<?php
                    foreach ($this->fields as $field)
                    {
                    ?>
                        <th class="title">
                            <?php
                                if ($field->is_searchable)
                                {
	                                echo HTMLHelper::_('grid.sort', Text::_($field->title), 'tbl.' . $field->name, $this->state->filter_order_Dir, $this->state->filter_order);
                                }
                                else
                                {
	                                echo $field->title;
                                }
                            ?>
                        </th>
                    <?php
                    }
					?>
					<th class="title">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_CREATED_DATE'), 'tbl.created_date', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
					<th class="title">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_MODIFIED_DATE'), 'tbl.modified_date', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
                    <?php
                    if (isset($this->lists['filter_status_id']))
                    {
                    ?>
                        <th width="8%">
                            <?php echo HTMLHelper::_('grid.sort', Text::_('HDP_STATUS'), 'tbl.status_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                        </th>
                    <?php
                    }

                    if (isset($this->lists['filter_priority_id']))
                    {
                    ?>
                        <th width="8%">
                            <?php echo HTMLHelper::_('grid.sort', Text::_('HDP_PRIORITY'), 'tbl.priority_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
                        </th>
                    <?php
                    }

                    if (!empty($this->showStaffColumn))
					{
					?>
						<th width="8%">
							<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_STAFF'), 'tbl.staff_id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
						</th>
					<?php
					}
					?>
					<th width="2%">
						<?php echo HTMLHelper::_('grid.sort', Text::_('HDP_ID'), 'tbl.id', $this->state->filter_order_Dir, $this->state->filter_order); ?>
					</th>
				</tr>
				</thead>
				<tfoot>
				<tr>
					<td colspan="<?php echo 10 + count($this->fields); ?>">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
				</tfoot>
				<tbody>
				<?php
				$k = 0;
				for ($i = 0, $n = count($this->items); $i < $n; $i++)
				{
					$row     = $this->items[$i];
					$link = Route::_('index.php?option=com_helpdeskpro&view=ticket&id=' . $row->id);
					$checked = HTMLHelper::_('grid.id', $i, $row->id);
					if ($row->user_id)
					{
						$accountLink = 'index.php?option=com_users&task=user.edit&id=' . $row->user_id;
					}
					?>
					<tr class="<?php echo "row$k"; ?> hdp-ticket-status-<?php $row->status_id; ?>">
						<td>
							<?php echo $this->pagination->getRowOffset($i); ?>
						</td>
						<td>
							<?php echo $checked; ?>
						</td>
						<td>
							<a href="<?php echo $link; ?>"><?php echo $row->subject; ?></a>
							<?php
							if ($row->label_id)
							{
								?>
								<span class="label_box"
								      style="background-color: #<?php echo $row->color_code; ?>"><?php echo $row->label_title; ?></span>
								<?php
							}
							?>
						</td>
						<td>
							<?php echo $row->category_title; ?>
						</td>
						<td>
							<span class="submitter_name"><?php echo $row->name; ?>
								<?php
								if ($row->username)
								{
								?>
									<a href="<?php echo $accountLink; ?>"
									   title="View Profile"><span>[<strong><?php echo $row->username; ?></strong>]</span></a>
								<?php
								}
								?>
							</span>
							<span class="submitter_email"><a
									href="mailto:<?php echo $row->email; ?>"><?php echo $row->email; ?></a></span>
						</td>
						<?php
                        foreach ($this->fields as $field)
                        {
                        ?>
                            <td>
                                <?php echo isset($this->fieldValues[$row->id][$field->id]) ? $this->fieldValues[$row->id][$field->id] : ''; ?>
                            </td>
                        <?php
                        }
						?>
						<td align="center">
							<?php echo HTMLHelper::_('date', $row->created_date, $this->config->date_format); ?>
						</td>
						<td align="center">
							<?php echo HTMLHelper::_('date', $row->modified_date, $this->config->date_format); ?>
						</td>
                        <?php
                            if (isset($this->lists['filter_status_id']))
                            {
                            ?>
                                <td>
		                            <?php echo @$this->statusList[$row->status_id]; ?>
                                </td>
                            <?php
                            }

                            if (isset($this->lists['filter_priority_id']))
                            {
                            ?>
                                <td>
		                            <?php echo $this->priorityList[$row->priority_id]; ?>
                                </td>
                            <?php
                            }

                            if (!empty($this->showStaffColumn))
                            {
                            ?>
                                <td>
                                    <?php echo $this->staffs[$row->staff_id]; ?>
                                </td>
                            <?php
                            }
						?>
						<td align="center">
							<?php echo $row->id; ?>
						</td>
					</tr>
					<?php
					$k = 1 - $k;
				}
				?>
				</tbody>
			</table>
		</div>
	</div>	
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->state->filter_order; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->state->filter_order_Dir; ?>"/>
	<?php echo HTMLHelper::_('form.token'); ?>
</form>