<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

use Joomla\CMS\Factory;

// Require the OSL library
if (!defined('OSL_INCLUDED') && !@include_once(JPATH_LIBRARIES . '/osl/init.php'))
{
	throw new RuntimeException('OSL library is not installed', 500);
}

// Turn on for development, turn off for production
error_reporting(0);

// Register auto-loader
JLoader::registerPrefix('HDP', JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/libraries');
JLoader::register('JFile', JPATH_LIBRARIES . '/joomla/filesystem/file.php');
JLoader::register('HelpdeskProHelperBootstrap', JPATH_ROOT . '/components/com_helpdeskpro/Helper/bootstrap.php');
JLoader::registerAlias('HelpdeskproHelper', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Helper');
JLoader::registerAlias('HelpdeskproHelperHtml', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Html');
JLoader::registerAlias('HelpdeskproRoute', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Route');
JLoader::registerAlias('HelpdeskproHelperHtml', 'OSSolution\\HelpdeskPro\\Site\\Helper\\Html');
JLoader::registerAlias('OSSolution\\HelpdeskPro\\Site\\Controller\\Ticket', 'OSSolution\\HelpdeskPro\\Admin\\Controller\\Ticket');
JLoader::registerAlias('OSSolution\\HelpdeskPro\\Site\\Model\\Tickets', 'OSSolution\\HelpdeskPro\\Admin\\Model\\Tickets');
JLoader::registerAlias('OSSolution\\HelpdeskPro\\Site\\Model\\Ticket', 'OSSolution\\HelpdeskPro\\Admin\\Model\\Ticket');

// Disable STRICT_TRANS_TABLES mode
if (version_compare(JVERSION, '4.0.0-dev', 'ge'))
{
	$db = Factory::getDbo();
	$db->setQuery("SET sql_mode=(SELECT REPLACE(@@sql_mode,'STRICT_TRANS_TABLES',''));");
	$db->execute();
}

// Make necessary changes to request data before passing it to controller for processing
OSL\Utils\Helper::prepareRequestData();