<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>
<link type="text/css" href="./persian-datepicker.css" rel="stylesheet" />

<script type="text/javascript" src="./jquery-1.6.2.min.js"></script>

<script type="text/javascript" src="./persian-datepicker.js"></script>

<link type="text/css" rel="stylesheet" href="./persianDatepicker.css" />
<script type="text/javascript" src="./jquery-1.10.1.min.js"></script>
<script type="text/javascript" src="./persianDatepicker.min.js"></script>



<div class="form-group">
  <label class="control-label col-md-2" for="invoice_status_id"> <?php echo JText::_( 'STATUS' ); ?> </label>
  <div class="controls col-md-4">
    <select name="status"
            id="invoice_status_id"
            class="form-control"
            :class="{'disabled': invoice.status == ''}"
            v-model="invoice.status">
      <option value=""><?php echo JText::_('CALCULATE_AUTOMATICALLY');?> ({{ status_name }})</option>
      <option
        v-for="status in $root.statuses"
        :value="status.id">{{ status.name }}</option>
    </select>
  </div>
  <label class="control-label col-md-2" for="language"> <?php echo JText::_( 'LANGUAGE' ); ?> </label>
  <div class="controls col-md-4">
    <select name="language" id="language" class="form-control" v-model="invoice.language">
      <option value=""></option>
      <?php
      $lang = JFactory::getLanguage();
      $langs = $lang->getKnownLanguages(JPATH_SITE) ;

      foreach($langs as $language){?>
      <option value="<?php echo $language['tag'];?>"><?php echo $language['name'];?></option>
      <?php } ?>
    </select>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-2" for="invoice_num"> <?php echo JText::_( 'FORMATED_'.$this->layout_type .'_NUMBER' ); ?> </label>
  <div class="controls col-md-4">
    <input  class="form-control "
            type="text"
            name="invoice_num"
            id="invoice_num"
            size="20"
            maxlength="250"
            v-model="invoice.invoice_num" />
  </div>
  <label class="control-label col-md-2" for="real_invoice_num"> <?php echo JText::_( 'REAL_'.$this->layout_type .'_NUMBER' ); ?> </label>
  <div class="controls col-md-4">
    <input  class="form-control "
            type="number"
            name="real_invoice_num"
            id="real_invoice_num"
            size="20"
            maxlength="250"
            v-model="invoice.real_invoice_num" />
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-2" for="invoice_date_"> <?php echo JText::_( $this->layout_type .'_DATE'); ?> </label>
  <div class="controls col-md-4">
   <div class="input-group" >
      <input  class="form-control "
              type="text"
              name="invoice_date"
              id="invoice_date_"
              data-date-format="yyyy-mm-dd"
              v-model="invoice.invoice_date"
              placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="invoice_date_btn_"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
  <label class="control-label col-md-2" for="invoice_duedate_"> <?php echo JText::_( $this->layout_type .'_DUEDATE'); ?> </label>
  <div class="controls col-md-4">
   <div class="input-group">
      <input  class="form-control "
              type="text"
              name="invoice_duedate"
              id="invoice_duedate_"
              data-date-format="yyyy-mm-dd"
              v-model="invoice.invoice_duedate"
              placeholder="<?php echo JText::_('NOT_SETTED'); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="invoice_duedate_btn_"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-2" for="template_id"> <?php echo JText::_( 'TEMPLATE' ); ?> </label>
  <div class="controls col-md-4">
    <select name="template_id" id="template_id" class="form-control" v-model="invoice.template_id">
      <?php
      for ($i=0, $n=count( $this->templates );$i < $n; $i++)  {
      $row = &$this->templates[$i]; ?>
      <option value="<?php echo $row->id;?>"><?php echo $row->name;?></option>
      <?php } ?>
    </select>
  </div>
  <label class="control-label col-md-2" for="currency_id"> <?php echo JText::_( 'CURRENCY' ); ?> </label>
  <div class="controls col-md-4">
    <select name="currency_id"
            id="currency_id"
            class="form-control"
            v-model="invoice.currency_id"
      <?php if(!$this->params->get('multiple_currency', false)){ ?>disabled="disabled"<?php } ?>>

      <option
        v-for="currency in $root.currencies"
        :value="currency.id">[{{ currency.currency_code }}] {{ currency.currency_name }} ({{ currency.currency_symbol }})</option>

    </select>
    <input  type="hidden"
            name="currency_id"
            :value="invoice.currency_id">
  </div>
  <?php if(!$this->params->get('multiple_currency', false)){ ?>
  <span class="help-block col-md-offset-8 col-md-4"><?php echo JText::_('MULTIPLE_CURRENCY_EXPLANATION'); ?></span>
  <?php } ?>
</div>

<hr />

<?php include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_invoices'.DS.'templates'.DS.'invoice'.DS.'publish.php'); ?>

<hr />

<div class="form-group">
  <label class="control-label col-md-2" for="external_type"> <?php echo JText::_( 'EXTERNAL_TYPE' ); ?> </label>
  <div class="controls col-md-4">
    <input class="form-control" type="text" name="external_type" id="external_type" maxlength="250" v-model="invoice.external_type" placeholder="<?php echo JText::_( 'EXTERNAL_TYPE_PLACEHOLDER' ); ?>" readonly />
  </div>

  <div v-show="invoice.external_id">
    <label class="control-label col-md-2" for="external_id"> <?php echo JText::_( 'EXTERNAL_ID' ); ?> </label>
    <div class="controls col-md-4">
      <input class="form-control input-small" type="text" name="external_id" id="external_id" maxlength="250" v-model="invoice.external_id" readonly />
    </div>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-2" for="external_ref"> <?php echo JText::_( 'EXTERNAL_REF' ); ?> </label>
  <div class="controls col-md-4">
    <input class="form-control input-small" type="text" name="external_ref" id="external_ref"  maxlength="250" v-model="invoice.external_ref" />
  </div>
</div>
