<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

?>

<div class="form-group">
  <label class="control-label col-md-3" for="invoice_status_id"> <?php echo JText::_( 'STATUS' ); ?> </label>
  <div class="controls col-md-9">
    <select name="status" id="invoice_status_id" class="form-control">
      <option></option>
      <?php
for ($i=0, $n=count( $this->status );$i < $n; $i++) {
$row = &$this->status[$i];
$selected = ""; 
if($row == $this->invoice->status) $selected = "selected";?>
      <option <?php echo $selected;?> value="<?php echo $row;?>"><?php echo JText::_($row);?></option>
      <?php } ?>
    </select>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="invoice_num"> <?php echo JText::_( 'FORMATED_'.$this->layout_type .'_NUMBER' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control " type="text" name="invoice_num" id="invoice_num" size="20" maxlength="250" value="<?php echo $this->invoice->invoice_num;?>" />
  </div>
  <label class="control-label col-md-3" for="real_invoice_num"> <?php echo JText::_( 'REAL_'.$this->layout_type .'_NUMBER' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control " type="text" name="real_invoice_num" id="real_invoice_num" size="20" maxlength="250" value="<?php echo $this->invoice->real_invoice_num;?>" />
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="invoice_date_<?php echo $this->invoice->id; ?>"> <?php echo JText::_( $this->layout_type .'_DATE'); ?> </label>
  <div class="controls col-md-9">
   <div class="input-group" >
      <input  class="form-control " 
              type="text" 
              name="invoice_date" 
              id="invoice_date_<?php echo $this->invoice->id; ?>" 
              data-date-format="yyyy-mm-dd"
              value="<?php echo $this->invoice->invoice_date;?>" 
              placeholder="<?php echo JText::_( $this->layout_type .'_DATE' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="invoice_date_btn_<?php echo $this->invoice->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
</div>

<script type="text/javascript">

  jQuery('#invoice_date_<?php echo $this->invoice->id; ?>').persianDatepicker().on('changeDate', function(ev) {
    jQuery('#invoice_date_<?php echo $this->invoice->id; ?>').persianDatepicker('hide');
  });

  jQuery("#invoice_date_btn_<?php echo $this->invoice->id; ?>").click(function() {
    jQuery('#invoice_date_<?php echo $this->invoice->id; ?>').persianDatepicker('show');
  });

</script>

<div class="form-group">
  <label class="control-label col-md-3" for="invoice_duedate_<?php echo $this->invoice->id; ?>"> <?php echo JText::_( $this->layout_type .'_DUEDATE'); ?> </label>
  <div class="controls col-md-9">
   <div class="input-group">
      <input class="form-control " 
      type="text" 
      name="invoice_duedate" 
      id="invoice_duedate_<?php echo $this->invoice->id; ?>" 
      data-date-format="yyyy-mm-dd"
      value="<?php echo $this->invoice->invoice_duedate;?>" 
      placeholder="<?php echo JText::_( $this->layout_type .'_DUEDATE' ); ?>"/>

        <span class="input-group-btn">
          <span class="btn btn-default" id="invoice_duedate_btn_<?php echo $this->invoice->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
        </span>
    </div>
  </div>
</div>

<script>

  jQuery('#invoice_duedate_<?php echo $this->invoice->id; ?>').persianDatepicker().on('changeDate', function(ev) {
    jQuery('#invoice_duedate_<?php echo $this->invoice->id; ?>').persianDatepicker('hide');
  });
  
  jQuery("#invoice_duedate_btn_<?php echo $this->invoice->id; ?>").click(function() {
    jQuery('#invoice_duedate_<?php echo $this->invoice->id; ?>').persianDatepicker('show');
  });
</script>

<div class="form-group">
  <label class="control-label col-md-3" for="template_id"> <?php echo JText::_( 'TEMPLATE' ); ?> </label>
  <div class="controls col-md-9">
    <select name="template_id" id="template_id" class="form-control">
      <?php
for ($i=0, $n=count( $this->templates );$i < $n; $i++)  {
$row = &$this->templates[$i];
$selected = ""; 
if($row->id == $this->invoice->template_id) $selected = "selected";?>
      <option <?php echo $selected;?> value="<?php echo $row->id;?>"><?php echo $row->name;?></option>
      <?php } ?>
    </select>
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="language"> <?php echo JText::_( 'LANGUAGE' ); ?> </label>
  <div class="controls col-md-9">
    <select name="language" id="language" class="form-control">
      <option value=""></option>
      <?php
      $lang = JFactory::getLanguage();
      $langs = $lang->getKnownLanguages(JPATH_SITE) ;
  
foreach($langs as $language){
$selected = ""; 
if($language['tag'] == $this->invoice->language) $selected = "selected";?>
      <option <?php echo $selected;?> value="<?php echo $language['tag'];?>"><?php echo $language['name'];?></option>
      <?php } ?>
    </select>
  </div>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="currency_before"> <?php echo JText::_( 'CURRENCY_SYMBOL_BEFORE' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control " onchange="change_currency()" type="text" name="currency_before" id="currency_before" placeholder="<?php echo JText::_( 'BEFORE' ); ?>" value="<?php echo $this->invoice->currency_before;?>" />
  </div>
  <label class="control-label col-md-3" for="currency_after"> <?php echo JText::_( 'CURRENCY_SYMBOL_AFTER' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control " onchange="change_currency()" type="text" name="currency_after" id="currency_after" placeholder="<?php echo JText::_( 'AFTER' ); ?>" value="<?php echo $this->invoice->currency_after;?>" />
  </div>
</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-3" for="external_type"> <?php echo JText::_( 'EXTERNAL_TYPE' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control" type="text" name="external_type" id="external_type" maxlength="250" value="<?php echo $this->invoice->external_type;?>" placeholder="<?php echo JText::_( 'EXTERNAL_TYPE_PLACEHOLDER' ); ?>" readonly />
  </div>
  <?php if($this->invoice->external_id){ ?>
  <label class="control-label col-md-3" for="external_id"> <?php echo JText::_( 'EXTERNAL_ID' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control input-small" type="text" name="external_id" id="external_id" maxlength="250" value="<?php echo $this->invoice->external_id;?>" readonly />
  </div>
  <?php } ?>
</div>

<div class="form-group">
  <label class="control-label col-md-3" for="external_ref"> <?php echo JText::_( 'EXTERNAL_REF' ); ?> </label>
  <div class="controls col-md-3">
    <input class="form-control input-small" type="text" name="external_ref" id="external_ref"  maxlength="250" value="<?php echo $this->invoice->external_ref;?>" />
  </div>
</div>
    