<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

$numtaxes = count($this->taxes);
switch ($numtaxes) {
  case 0:
    $boxclass = "col-md-3" ;
    break;
  case 1:
    $boxclass = "col-md-sp5" ;
    break;
  case 2:
    $boxclass = "col-md-2" ;
    break;

  default:
    $boxclass = "col-md-2" ;
    break;
}
?>

<div class="row at_totals ">

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-info">
    <div class="row ">

        <div class="col-xs-12">
          <div class=" resume-number ">

            <div class="big_number summary-number total_invoices" id="summary_num_invoices">{{ contact.summary.num_invoices }}</div>
            <span class="resume-title"><?php echo JText::_('NUM_INVOICES'); ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right ">
    <div class="dashboard-box dashboard-inverse">
    <div class="row ">

        <div class="col-xs-12">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_total_invoices">{{ contact.invoice_total() | currency }}</div>
            <span class="resume-title"><?php echo JText::_('TOTAL_INVOICES'); ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php foreach($this->taxes as $tax){ ?>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-warning">
    <div class="row ">

        <div class="col-xs-12">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_tax_<?php echo $tax->id; ?>">{{ contact.total_tax(<?php echo $tax->id; ?>) | currency }}</div>
            <span class="resume-title"><?php echo $tax->name; ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php } ?>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-success">
    <div class="row ">

        <div class="col-xs-12">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_total_income">{{ contact.total_income() | currency }}</div>
            <span class=" resume-title"><?php echo JText::_('TOTAL_INCOME'); ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="<?php echo $boxclass; ?> col-sm-6 text-right hidden-xs">
    <div class="dashboard-box dashboard-important">
    <div class="row ">

        <div class="col-xs-12">
          <div class=" resume-number ">

            <div class="big_number summary-number" id="summary_pending_income">{{ contact.pending_income() | currency }}</div>
            <span class="resume-title"><?php echo JText::_('PENDING_INCOME'); ?></span>
            <span class="timeframe-title">&nbsp;</span>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
