<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

?>
<div class="form-group form-group-lg">
  <label class="control-label col-md-3" for="to_name"> <?php echo JText::_( 'RECIPIENT_NAME' ); ?></label>
  <div class="controls col-md-9">
    <input class="form-control" type="text" name="to_name" id="to_name" size="80" maxlength="250" value="<?php echo $this->invoice->to_name;?>" placeholder="<?php echo JText::_( 'RECIPIENT_NAME_PLACEHOLDER' ); ?>" <?php if(!$this->invoice->id) echo "autofocus='autofocus'"; ?> />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="to_company"> <?php echo JText::_( 'COMPANY' ); ?></label>
  <div class="controls col-md-9">
    <input class="form-control" type="text" name="to_company" id="to_company" size="80" maxlength="250" value="<?php echo $this->invoice->to_company;?>" placeholder="<?php echo JText::_( 'COMPANY' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="to_address"> <?php echo JText::_( 'RECIPIENT_ADDRESS' ); ?></label>
  <div class="controls col-md-9">
    <textarea class="form-control"  name="to_address" id="to_address" cols="40" rows="4"  placeholder="<?php echo JText::_( 'RECIPIENT_ADDRESS' ); ?>"><?php echo $this->invoice->to_address; ?></textarea>
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="to_city"> <?php echo JText::_( 'LOCATION_CITY' ); ?></label>
  <div class="controls col-md-9">
    <div class="row">
      <div class="col-xs-6">
        <input class="form-control " type="text" name="to_zipcode" id="to_zipcode" size="80" maxlength="250" value="<?php echo $this->invoice->to_zipcode;?>" placeholder="<?php echo JText::_( 'RECIPIENT_ZIPCODE_PLACEHOLDER' ); ?>" />
      </div>
      <div class="col-xs-6">
        <input class="form-control " type="text" name="to_city" id="to_city" size="80" maxlength="250" value="<?php echo $this->invoice->to_city;?>" placeholder="<?php echo JText::_( 'RECIPIENT_CITY_PLACEHOLDER' ); ?>" />
      </div>
    </div>
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="to_country"> <?php echo JText::_( 'LOCATION_COUNTRY' ); ?></label>
  <div class="controls col-md-9">
    <div class="row">
      <div class="col-xs-6">
        <input class="form-control " type="text" name="to_state" id="to_state" size="80" maxlength="250" value="<?php echo $this->invoice->to_state;?>" placeholder="<?php echo JText::_( 'RECIPIENT_STATE_PLACEHOLDER' ); ?>" />
      </div>
      <div class="col-xs-6">
        <input class="form-control " type="text" name="to_country" id="to_country" size="80" maxlength="250" value="<?php echo $this->invoice->to_country;?>" placeholder="<?php echo JText::_( 'RECIPIENT_COUNTRY_PLACEHOLDER' ); ?>" />
      </div>
    </div>
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="to_email"> <?php echo JText::_( 'EMAIL' ); ?></label>
  <div class="controls col-md-9">
    <input class="form-control" type="email" name="to_email" id="to_email" size="80" maxlength="250" value="<?php echo $this->invoice->to_email;?>" placeholder="<?php echo JText::_( 'EMAIL' ); ?>" />
  </div>
</div>
<div class="form-group">
  <label class="control-label col-md-3" for="to_phone"> <?php echo JText::_( 'PHONE' ); ?></label>
  <div class="controls col-md-9">
    <input class="form-control" type="text" name="to_phone" id="to_phone" size="80" maxlength="250" value="<?php echo $this->invoice->to_phone;?>" placeholder="<?php echo JText::_( 'PHONE' ); ?>" />
  </div>
</div>
<div class="form-group has-feedback" id="vatid_container">
  <label class="control-label col-md-3" for="to_vatid"> <?php echo JText::_( 'VATID' ); ?></label>
  <div class="controls col-md-9">
    <?php if ($this->params->get('euvat_verification', 1)): ?>
      <div class="input-group">
        <input class="form-control" type="text" name="to_vatid" id="to_vatid" size="80" maxlength="250" value="<?php echo $this->invoice->to_vatid;?>" placeholder="<?php echo JText::_( 'VATID' ); ?>" />
        <span class="input-group-btn">
          <button class="btn btn-default" type="button" onClick="validate_eu_vat();"><?php echo JText::_('VERIFY_EU_VAT_ID'); ?></button>
        </span>
      </div><!-- /input-group -->
      <span class="glyphicon glyphicon-ok form-control-feedback" aria-hidden="true"></span>
      <span class="glyphicon glyphicon-refresh glyphicon-spin form-control-feedback hide" id="spinner_euvat"></span>
      <span id="inputGroupSuccess1Status" class="sr-only">(success)</span>
    <?php else: ?>
      <input class="form-control" type="text" name="to_vatid" id="to_vatid" size="80" maxlength="250" value="<?php echo $this->invoice->to_vatid;?>" placeholder="<?php echo JText::_( 'VATID' ); ?>" />
    <?php endif; ?>
  </div>
</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-3" ><?php echo JText::_( 'CONTACT_OPTIONS' ); ?></label>
  <input class="form-control" type="hidden" name="user_id" id="user_id" value="<?php echo $this->invoice->user_id;?>" />

  <div class="controls col-md-3">
    <div class="btn-group" id="sign_group" data-toggle="buttons" style="width:100%">
      <label class="btn btn-info <?php if($this->invoice->user_id) echo "active"; ?>" style="width:25%" id="label_contact_1" for="vincular_cliente_checkbox" data-original-title="<? echo JText::_('LINK_TO_EXISTING_CONTACT'); ?>" data-toggle="tooltip"><span class="glyphicon glyphicon-user" ></span>
          <input <?php if($this->invoice->user_id) echo "checked='checked'"; ?> class="radio_toggle" type="radio"  value="1" name="vincular_cliente_checkbox" id="vincular_cliente_checkbox" />
      </label>
      <label class="btn btn-info <?php if($this->invoice->vincular_cliente_checkbox == 2) echo "active"; ?>" style="width:25%" id="label_contact_2" for="vincular_cliente_checkbox2" data-original-title="<? echo JText::_('CREATE_NEW_CONTACT'); ?>" data-toggle="tooltip"><span class="glyphicon glyphicon-plus-sign" ></span>
        <input <?php if($this->invoice->vincular_cliente_checkbox == 2) echo "checked='checked'"; ?> class="radio_toggle" autocomplete="off" type="radio" value="2" name="vincular_cliente_checkbox" id="vincular_cliente_checkbox2" />
      </label>
      <label class="btn btn-info" style="width:25%" id="label_contact_3" for="vincular_cliente_checkbox3" data-original-title="<? echo JText::_('UPDATE_CONTACT_DATA'); ?>" data-toggle="tooltip"><span class="glyphicon glyphicon-refresh" ></span>
        <input class="radio_toggle" autocomplete="off" type="radio" value="3" name="vincular_cliente_checkbox" id="vincular_cliente_checkbox3" />
      </label>
      <label class="btn btn-info" style="width:25%" id="label_contact_4" for="vincular_cliente_checkbox4" data-original-title="<? echo JText::_('DO_NOT_LINK_TO_CONTACT'); ?>" data-toggle="tooltip"><span class="glyphicon glyphicon-remove" ></span>
        <input class="radio_toggle" autocomplete="off" type="radio" value="0" name="vincular_cliente_checkbox" id="vincular_cliente_checkbox4" />
      </label>
    </div>
  </div>

  <label class="control-label col-md-2" ><?php echo JText::_( 'CONTACT' ); ?></label>

  <div class="controls col-md-4">
    <input type="text" class="form-control " readonly id="vincular_cliente" size="30" value="<?php echo $this->invoice->contact_name; ?>" placeholder="<?php echo JText::_( 'CONTACT_NAME_PLACEHOLDER' ); ?>" />
  </div>

</div>

<hr />

<div class="form-group">
  <label class="control-label col-md-3" for="search_user"><?php echo JText::_( 'LINK_TO_JOOMLA_USER' ); ?></label>
  <div class="controls col-md-9">
    <div class="row">

      <div class="col-md-4">

        <input type="text" class="form-control " readonly id="username" size="40" value="<?php if($this->invoice->joomla_user_id) echo $this->invoice->username . " [".$this->invoice->joomla_user_id."]"; ?>" placeholder="<?php echo JText::_( 'JOOMLA_USERNAME_PLACEHOLDER' ); ?>" />
        <input class="inputbox input-mini small-margin-top" type="hidden" name="joomla_user_id" id="joomla_user_id" size="4" maxlength="11" value="<?php echo $this->invoice->joomla_user_id;?>" />

      </div>

      <div class="col-md-8">

        <div class="controls">
          <input class="form-control" type="text" name="search_user" id="search_user"  value="" size="30" placeholder="<?php echo JText::_('TYPE_TO_SEARCH_USER'); ?>" />
        </div>

        <div id="log_clientes"></div>

      </div>
    </div>
  </div>

</div>

<script type="text/javascript">

var namesBloodhound = new Bloodhound({
    datumTokenizer: Bloodhound.tokenizers.obj.whitespace('name'),
    queryTokenizer: Bloodhound.tokenizers.whitespace,
    limit: 10,

    remote: {
        url: 'index.php?option=com_invoices&controller=invoice&task=search_contact&searchword=%QUERY',
        wildcard: '%QUERY'
    }
});

/**
 * Initializes the typeahead
 */
function initializeRecipientNameTypeahead() {
    namesBloodhound.initialize();

    jQuery('#to_name').typeahead(null, {
        name: 'contacts',
        displayKey: 'name',
        source: namesBloodhound.ttAdapter(),
        templates: {
          suggestion: Handlebars.compile(jQuery("#contact-suggestion-template").html())
        }
    }).on('typeahead:select', function(ev, suggestion) {
        load_contact(suggestion);
    });
}

initializeRecipientNameTypeahead();


var usersBloodhound = new Bloodhound({
    datumTokenizer: Bloodhound.tokenizers.obj.whitespace('name'),
    queryTokenizer: Bloodhound.tokenizers.whitespace,
    limit: 10,

    remote: {
        url: 'index.php?option=com_invoices&controller=invoice&task=search_user&searchword=%QUERY',
        wildcard: '%QUERY'
    }
});

/**
 * Initializes the typeahead
 */
function initializeUsernameTypeahead() {
    usersBloodhound.initialize();

    jQuery('#search_user').typeahead(null, {
        name: 'users',
        displayKey: 'name',
        source: usersBloodhound.ttAdapter()
    }).on('typeahead:select', function(ev, suggestion) {

        load_user(suggestion);
    });
}

initializeUsernameTypeahead();

jQuery("#button_search_user").on("click", function(event){
    search_user();
  });

  jQuery("#search_user").on("keypress", function(event){
    if(event.keyCode == 13) search_user();
  });

</script>
