<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view' );

class TemplatesViewTemplate extends JViewLegacy
{

  protected $input;

	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$this->input = $mainframe->input;

	}

	function display($tpl = null)
	{
    $params = $params = JComponentHelper::getParams( 'com_invoices' );

		//cridem el CSS
		$document	= JFactory::getDocument();

		//get the invoice
		$this->template			= $this->get('Data');

		$isNew		= ($this->template->id < 1);

		$text = $isNew ? JText::_( 'New' ) : JText::_( 'Edit' );
		$title = $isNew ? JText::_( 'Template' ) : $this->template->name;

		JToolbarHelper::title(   $title . ': <small><small>[ ' . $text.' ]</small></small>','templates' );
		JToolbarHelper::save();

		if ($isNew)  {
			JToolbarHelper::cancel();
		} else {
			JToolbarHelper::apply();
			JToolbarHelper::cancel( 'cancel', JText::_('CLOSE') );

		}

    // $layout = $this->input->get('layout', 'form');

    $this->setLayout($this->input->get('layout', 'form'));

		parent::display($tpl);
	}

}
