<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		course.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Registry\Registry;
use Joomla\String\StringHelper;
use Joomla\Utilities\ArrayHelper;

/**
 * Moojla Course Model
 */
class MoojlaModelCourse extends JModelAdmin
{
	/**
	 * The tab layout fields array.
	 *
	 * @var      array
	 */
	protected $tabLayoutFields = array(
		'details' => array(
			'left' => array(
				'cat_id',
				'cat_name',
				'currency',
				'self_enrolment',
				'startdate',
				'summary_files',
				'teachers'
			),
			'right' => array(
				'cost',
				'remoteid',
				'guest',
				'in_enrol_date',
				'enddate',
				'summary'
			),
			'above' => array(
				'alias',
				'shortname',
				'fullname',
				'permanent_fields',
				'catid'
			)
		),
		'video' => array(
			'left' => array(
				'useglobalvideo',
				'videotype',
				'preventdownload',
				'addcontrols',
				'preloadvideo',
				'autoplay',
				'muted'
			)
		),
		'moodle_access' => array(
			'left' => array(
				'availabilityinfolink',
				'redirect_after_enrol',
				'showlogintab',
				'loginurl',
				'alterurl',
				'enterlbl',
				'buylbl'
			),
			'right' => array(
				'cangotomoodle',
				'popupbutton',
				'showregtab',
				'registrationurl',
				'loginlbl',
				'freeenterlbl',
				'enrollbl'
			)
		),
		'audio' => array(
			'left' => array(
				'useglobalaudio',
				'preventdownloadaudio',
				'preloadaudio',
				'autoplayaudio'
			)
		),
		'templates' => array(
			'left' => array(
				'course_templatestyle_forcourseconfig'
			),
			'right' => array(
				'course_detail_layout'
			)
		)
	);

	/**
	 * @var        string    The prefix to use with controller messages.
	 * @since   1.6
	 */
	protected $text_prefix = 'COM_MOOJLA';

	/**
	 * The type alias for this content type.
	 *
	 * @var      string
	 * @since    3.2
	 */
	public $typeAlias = 'com_moojla.course';

	/**
	 * Returns a Table object, always creating it
	 *
	 * @param   type    $type    The table type to instantiate
	 * @param   string  $prefix  A prefix for the table class name. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JTable  A database object
	 *
	 * @since   1.6
	 */
	public function getTable($type = 'course', $prefix = 'MoojlaTable', $config = array())
	{
		// add table path for when model gets used from other component
		$this->addTablePath(JPATH_ADMINISTRATOR . '/components/com_moojla/tables');
		// get instance of the table
		return JTable::getInstance($type, $prefix, $config);
	}


/***[JCBGUI.admin_view.php_model.129.$$$$]***/
  public function myDelete($pk){
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('rules', 'id')));
    $query->from($db->quoteName('#__assets'));
    $query->where($db->quoteName('name') . ' = ' . $db->quote('com_moojla'));
    $db->setQuery($query);
    $results = $db->loadObjectList();

    $acls = json_decode($results[0]->rules);

    $deleteAcl = null;
    $permission = 'core.delete';
    if(!property_exists($acls, $permission))
    {
      $acls->$permission = new stdClass();
    }

    $pub = '1';

    $acls->$permission->$pub = 1;
    $obj = new stdClass();
    $obj->id = $results[0]->id;
    $obj->rules = json_encode($acls);
    JFactory::getDbo()->updateObject('#__assets', $obj, 'id');

    $obj = new stdClass();
    $obj->id = $pk;
    $obj->published = -2;
    JFactory::getDbo()->updateObject('#__moojla_course', $obj, 'id'); // trash item

    $pks = array($pk);
    $res = $this->delete($pks);

    $obj = new stdClass();
    $obj->id = $results[0]->id;
    $obj->rules = $results[0]->rules;
    JFactory::getDbo()->updateObject('#__assets', $obj, 'id');

    return $res;
  }


  public function setFieldValue($fieldId, $itemId, $value)
  {
    JLoader::register('FieldsHelper', JPATH_ADMINISTRATOR.'/components/com_fields/helpers/fields.php');
    JLoader::register('FieldsModelField', JPATH_ADMINISTRATOR.'/components/com_fields/models/field.php');
    $fieldModle = new FieldsModelField;

    $field  = $fieldModle->getItem($fieldId);
    $params = $field->params;

    if (is_array($params))
    {
      $params = new Registry($params);
    }

    $needsDelete = false;
    $needsInsert = false;
    $needsUpdate = false;

    $oldValue = $fieldModle->getFieldValue($fieldId, $itemId);
    $value    = (array) $value;

    if ($oldValue === null)
    {
      // No records available, doing normal insert
      $needsInsert = true;
    }
    elseif (count($value) == 1 && count((array) $oldValue) == 1)
    {
      // Only a single row value update can be done when not empty
      $needsUpdate = is_array($value[0]) ? count($value[0]) : strlen($value[0]);
      $needsDelete = !$needsUpdate;
    }
    else
    {
      // Multiple values, we need to purge the data and do a new
      // insert
      $needsDelete = true;
      $needsInsert = true;
    }

    if ($needsDelete)
    {
      // Deleting the existing record as it is a reset
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);

      $query->delete($query->qn('#__fields_values'))
        ->where($query->qn('field_id') . ' = ' . (int) $fieldId)
        ->where($query->qn('item_id') . ' = ' . $query->q($itemId));

      $db->setQuery($query)->execute();
    }

    if ($needsInsert)
    {
      $newObj = new stdClass;

      $newObj->field_id = (int) $fieldId;
      $newObj->item_id  = $itemId;

      foreach ($value as $v)
      {
        $newObj->value = $v;
        $db = JFactory::getDbo();
        $db->insertObject('#__fields_values', $newObj);
      }
    }

    if ($needsUpdate)
    {
      $updateObj = new stdClass;

      $updateObj->field_id = (int) $fieldId;
      $updateObj->item_id  = $itemId;
      $updateObj->value    = reset($value);
      $db = JFactory::getDbo();
      $db->updateObject('#__fields_values', $updateObj, array('field_id', 'item_id'));
    }

    FieldsHelper::clearFieldsCache();

    return true;
  }
/***[/JCBGUI$$$$]***/

    
	/**
	 * Method to get a single record.
	 *
	 * @param   integer  $pk  The id of the primary key.
	 *
	 * @return  mixed  Object on success, false on failure.
	 *
	 * @since   1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk))
		{
			if (!empty($item->params) && !is_array($item->params))
			{
				// Convert the params field to an array.
				$registry = new Registry;
				$registry->loadString($item->params);
				$item->params = $registry->toArray();
			}

			if (!empty($item->metadata))
			{
				// Convert the metadata field to an array.
				$registry = new Registry;
				$registry->loadString($item->metadata);
				$item->metadata = $registry->toArray();
			}

			if (!empty($item->permanent_fields))
			{
				// Convert the permanent_fields field to an array.
				$permanent_fields = new Registry;
				$permanent_fields->loadString($item->permanent_fields);
				$item->permanent_fields = $permanent_fields->toArray();
			}
		}

		return $item;
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 * @param   array    $options   Optional array of options for the form creation.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true, $options = array('control' => 'jform'))
	{
		// set load data option
		$options['load_data'] = $loadData;
		// check if xpath was set in options
		$xpath = false;
		if (isset($options['xpath']))
		{
			$xpath = $options['xpath'];
			unset($options['xpath']);
		}
		// check if clear form was set in options
		$clear = false;
		if (isset($options['clear']))
		{
			$clear = $options['clear'];
			unset($options['clear']);
		}

		// Get the form.
		$form = $this->loadForm('com_moojla.course', 'course', $options, $clear, $xpath);

		if (empty($form))
		{
			return false;
		}

		$jinput = JFactory::getApplication()->input;

		// The front end calls this model and uses a_id to avoid id clashes so we need to check for that first.
		if ($jinput->get('a_id'))
		{
			$id = $jinput->get('a_id', 0, 'INT');
		}
		// The back end uses id so we use that the rest of the time and set it to 0 by default.
		else
		{
			$id = $jinput->get('id', 0, 'INT');
		}

		$user = JFactory::getUser();

		// Check for existing item.
		// Modify the form based on Edit State access controls.
		if ($id != 0 && (!$user->authorise('core.edit.state', 'com_moojla.course.' . (int) $id))
			|| ($id == 0 && !$user->authorise('core.edit.state', 'com_moojla')))
		{
			// Disable fields for display.
			$form->setFieldAttribute('ordering', 'disabled', 'true');
			$form->setFieldAttribute('published', 'disabled', 'true');
			// Disable fields while saving.
			$form->setFieldAttribute('ordering', 'filter', 'unset');
			$form->setFieldAttribute('published', 'filter', 'unset');
		}
		// If this is a new item insure the greated by is set.
		if (0 == $id)
		{
			// Set the created_by to this user
			$form->setValue('created_by', null, $user->id);
		}
		// Modify the form based on Edit Creaded By access controls.
		if (!$user->authorise('core.edit.created_by', 'com_moojla'))
		{
			// Disable fields for display.
			$form->setFieldAttribute('created_by', 'disabled', 'true');
			// Disable fields for display.
			$form->setFieldAttribute('created_by', 'readonly', 'true');
			// Disable fields while saving.
			$form->setFieldAttribute('created_by', 'filter', 'unset');
		}
		// Modify the form based on Edit Creaded Date access controls.
		if (!$user->authorise('core.edit.created', 'com_moojla'))
		{
			// Disable fields for display.
			$form->setFieldAttribute('created', 'disabled', 'true');
			// Disable fields while saving.
			$form->setFieldAttribute('created', 'filter', 'unset');
		}
		// Only load these values if no id is found
		if (0 == $id)
		{
			// Set redirected view name
			$redirectedView = $jinput->get('ref', null, 'STRING');
			// Set field name (or fall back to view name)
			$redirectedField = $jinput->get('field', $redirectedView, 'STRING');
			// Set redirected view id
			$redirectedId = $jinput->get('refid', 0, 'INT');
			// Set field id (or fall back to redirected view id)
			$redirectedValue = $jinput->get('field_id', $redirectedId, 'INT');
			if (0 != $redirectedValue && $redirectedField)
			{
				// Now set the local-redirected field default value
				$form->setValue($redirectedField, null, $redirectedValue);
			}
		}
		return $form;
	}

	/**
	 * Method to get the script that have to be included on the form
	 *
	 * @return string	script files
	 */
	public function getScript()
	{
		return 'media/com_moojla/js/course.js';
	}
    
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to delete the record. Defaults to the permission set in the component.
	 *
	 * @since   1.6
	 */
	protected function canDelete($record)
	{
		if (!empty($record->id))
		{
			if ($record->published != -2)
			{
				return;
			}

			$user = JFactory::getUser();
			// The record has been set. Check the record permissions.
			return $user->authorise('course.delete', 'com_moojla.course.' . (int) $record->id);
		}
		return false;
	}

	/**
	 * Method to test whether a record can have its state edited.
	 *
	 * @param   object  $record  A record object.
	 *
	 * @return  boolean  True if allowed to change the state of the record. Defaults to the permission set in the component.
	 *
	 * @since   1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();
		$recordId = (!empty($record->id)) ? $record->id : 0;

		if ($recordId)
		{
			// The record has been set. Check the record permissions.
			$permission = $user->authorise('core.edit.state', 'com_moojla.course.' . (int) $recordId);
			if (!$permission && !is_null($permission))
			{
				return false;
			}
		}
		// In the absense of better information, revert to the component permissions.
		return parent::canEditState($record);
	}
    
	/**
	 * Method override to check if you can edit an existing record.
	 *
	 * @param	array	$data	An array of input data.
	 * @param	string	$key	The name of the key for the primary key.
	 *
	 * @return	boolean
	 * @since	2.5
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// Check specific edit permission then general edit permission.
		$user = JFactory::getUser();

		return $user->authorise('course.edit', 'com_moojla.course.'. ((int) isset($data[$key]) ? $data[$key] : 0)) or $user->authorise('course.edit',  'com_moojla');
	}
    
	/**
	 * Prepare and sanitise the table data prior to saving.
	 *
	 * @param   JTable  $table  A JTable object.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function prepareTable($table)
	{
		$date = JFactory::getDate();
		$user = JFactory::getUser();
		
		if (isset($table->name))
		{
			$table->name = htmlspecialchars_decode($table->name, ENT_QUOTES);
		}
		
		if (isset($table->alias) && empty($table->alias))
		{
			$table->generateAlias();
		}
		
		if (empty($table->id))
		{
			$table->created = $date->toSql();
			// set the user
			if ($table->created_by == 0 || empty($table->created_by))
			{
				$table->created_by = $user->id;
			}
			// Set ordering to the last item if not set
			if (empty($table->ordering))
			{
				$db = JFactory::getDbo();
				$query = $db->getQuery(true)
					->select('MAX(ordering)')
					->from($db->quoteName('#__moojla_course'));
				$db->setQuery($query);
				$max = $db->loadResult();

				$table->ordering = $max + 1;
			}
		}
		else
		{
			$table->modified = $date->toSql();
			$table->modified_by = $user->id;
		}
        
		if (!empty($table->id))
		{
			// Increment the items version number.
			$table->version++;
		}
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.6
	 */
	protected function loadFormData() 
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_moojla.edit.course.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
			// run the perprocess of the data
			$this->preprocessData('com_moojla.course', $data);
		}

		return $data;
	}

	/**
	 * Method to get the unique fields of this table.
	 *
	 * @return  mixed  An array of field names, boolean false if none is set.
	 *
	 * @since   3.0
	 */
	protected function getUniqueFields()
	{
		return array('remoteid');
	}
	
	/**
	 * Method to delete one or more records.
	 *
	 * @param   array  &$pks  An array of record primary keys.
	 *
	 * @return  boolean  True if successful, false if an error occurs.
	 *
	 * @since   12.2
	 */
	public function delete(&$pks)
	{

/***[JCBGUI.admin_view.php_before_delete.129.$$$$]***/
  require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/course.php";
  require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/section.php";
  require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/module.php";
  require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/content.php";
  foreach($pks as $id)
  {
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('remoteid')))
      ->from($db->quoteName('#__moojla_course'))
      ->where($db->quoteName('id') . ' = ' . $id);
    $db->setQuery($query);
    $courseid = $db->loadResult();

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName(array('id', 'section_id')))
      ->from($db->quoteName('#__moojla_section'))
      ->where($db->quoteName('courseid') . ' = ' . $courseid);
    $db->setQuery($query);
    $moojlasectionids = $db->loadObjectList();
    foreach($moojlasectionids as $section)
    {
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select($db->quoteName(array('id', 'module_id')))
        ->from($db->quoteName('#__moojla_module'))
        ->where($db->quoteName('module_section_id') . ' = ' . $section->section_id);
      $db->setQuery($query);
      $moojlamoduleids = $db->loadObjectList();
      foreach($moojlamoduleids as $module)
      {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select($db->quoteName(array('id')))
          ->from($db->quoteName('#__moojla_content'))
          ->where($db->quoteName('contents_module_id') . ' = ' . $module->module_id);
        $db->setQuery($query);
        $moojlacontentids = $db->loadObjectList();
        foreach($moojlacontentids as $content)
        {
          $contentIns = new MoojlaModelContent();
          $contentIns->myDelete($content->id);
        }
        $moduleIns = new MoojlaModelModule();
        $moduleIns->myDelete($module->id);
      }
      $sectionIns = new MoojlaModelSection();
      $sectionIns->myDelete($section->id);
    }
  }
/***[/JCBGUI$$$$]***/

		if (!parent::delete($pks))
		{
			return false;
		}
		
		return true;
	}

	/**
	 * Method to change the published state of one or more records.
	 *
	 * @param   array    &$pks   A list of the primary keys to change.
	 * @param   integer  $value  The value of the published state.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   12.2
	 */
	public function publish(&$pks, $value = 1)
	{
		if (!parent::publish($pks, $value))
		{
			return false;
		}
		
		return true;
        }
    
	/**
	 * Method to perform batch operations on an item or a set of items.
	 *
	 * @param   array  $commands  An array of commands to perform.
	 * @param   array  $pks       An array of item ids.
	 * @param   array  $contexts  An array of item contexts.
	 *
	 * @return  boolean  Returns true on success, false on failure.
	 *
	 * @since   12.2
	 */
	public function batch($commands, $pks, $contexts)
	{
		// Sanitize ids.
		$pks = array_unique($pks);
		ArrayHelper::toInteger($pks);

		// Remove any values of zero.
		if (array_search(0, $pks, true))
		{
			unset($pks[array_search(0, $pks, true)]);
		}

		if (empty($pks))
		{
			$this->setError(JText::_('JGLOBAL_NO_ITEM_SELECTED'));
			return false;
		}

		$done = false;

		// Set some needed variables.
		$this->user			= JFactory::getUser();
		$this->table			= $this->getTable();
		$this->tableClassName		= get_class($this->table);
		$this->contentType		= new JUcmType;
		$this->type			= $this->contentType->getTypeByTable($this->tableClassName);
		$this->canDo			= MoojlaHelper::getActions('course');
		$this->batchSet			= true;

		if (!$this->canDo->get('core.batch'))
		{
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_INSUFFICIENT_BATCH_INFORMATION'));
			return false;
		}
        
		if ($this->type == false)
		{
			$type = new JUcmType;
			$this->type = $type->getTypeByAlias($this->typeAlias);
		}

		$this->tagsObserver = $this->table->getObserverOfClass('JTableObserverTags');

		if (!empty($commands['move_copy']))
		{
			$cmd = ArrayHelper::getValue($commands, 'move_copy', 'c');

			if ($cmd == 'c')
			{
				$result = $this->batchCopy($commands, $pks, $contexts);

				if (is_array($result))
				{
					foreach ($result as $old => $new)
					{
						$contexts[$new] = $contexts[$old];
					}
					$pks = array_values($result);
				}
				else
				{
					return false;
				}
			}
			elseif ($cmd == 'm' && !$this->batchMove($commands, $pks, $contexts))
			{
				return false;
			}

			$done = true;
		}

		if (!$done)
		{
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_INSUFFICIENT_BATCH_INFORMATION'));

			return false;
		}

		// Clear the cache
		$this->cleanCache();

		return true;
	}

	/**
	 * Batch copy items to a new category or current.
	 *
	 * @param   integer  $values    The new values.
	 * @param   array    $pks       An array of row IDs.
	 * @param   array    $contexts  An array of item contexts.
	 *
	 * @return  mixed  An array of new IDs on success, boolean false on failure.
	 *
	 * @since 12.2
	 */
	protected function batchCopy($values, $pks, $contexts)
	{
		if (empty($this->batchSet))
		{
			// Set some needed variables.
			$this->user 		= JFactory::getUser();
			$this->table 		= $this->getTable();
			$this->tableClassName	= get_class($this->table);
			$this->canDo		= MoojlaHelper::getActions('course');
		}

		if (!$this->canDo->get('course.create') && !$this->canDo->get('course.batch'))
		{
			return false;
		}

		// get list of unique fields
		$uniqueFields = $this->getUniqueFields();
		// remove move_copy from array
		unset($values['move_copy']);

		// make sure published is set
		if (!isset($values['published']))
		{
			$values['published'] = 0;
		}
		elseif (isset($values['published']) && !$this->canDo->get('core.edit.state'))
		{
				$values['published'] = 0;
		}

		if (isset($values['category']) && (int) $values['category'] > 0 && !static::checkCategoryId($values['category']))
		{
			return false;
		}
		elseif (isset($values['category']) && (int) $values['category'] > 0)
		{
			// move the category value to correct field name
			$values['catid'] = $values['category'];
			unset($values['category']);
		}
		elseif (isset($values['category']))
		{
			unset($values['category']);
		}

		$newIds = array();
		// Parent exists so let's proceed
		while (!empty($pks))
		{
			// Pop the first ID off the stack
			$pk = array_shift($pks);

			$this->table->reset();

			// only allow copy if user may edit this item.
			if (!$this->user->authorise('course.edit', $contexts[$pk]))
			{
				// Not fatal error
				$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_BATCH_MOVE_ROW_NOT_FOUND', $pk));
				continue;
			}

			// Check that the row actually exists
			if (!$this->table->load($pk))
			{
				if ($error = $this->table->getError())
				{
					// Fatal error
					$this->setError($error);
					return false;
				}
				else
				{
					// Not fatal error
					$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_BATCH_MOVE_ROW_NOT_FOUND', $pk));
					continue;
				}
			}

			if (isset($values['catid']))
			{
				list($this->table->shortname, $this->table->alias) = $this->generateNewTitle($values['catid'], $this->table->alias, $this->table->shortname);
			}
			else
			{
				list($this->table->shortname, $this->table->alias) = $this->generateNewTitle($this->table->catid, $this->table->alias, $this->table->shortname);
			}

			// insert all set values
			if (MoojlaHelper::checkArray($values))
			{
				foreach ($values as $key => $value)
				{
					if (strlen($value) > 0 && isset($this->table->$key))
					{
						$this->table->$key = $value;
					}
				}
			}

			// update all unique fields
			if (MoojlaHelper::checkArray($uniqueFields))
			{
				foreach ($uniqueFields as $uniqueField)
				{
					$this->table->$uniqueField = $this->generateUnique($uniqueField,$this->table->$uniqueField);
				}
			}

			// Reset the ID because we are making a copy
			$this->table->id = 0;

			// TODO: Deal with ordering?
			// $this->table->ordering = 1;

			// Check the row.
			if (!$this->table->check())
			{
				$this->setError($this->table->getError());

				return false;
			}

			if (!empty($this->type))
			{
				$this->createTagsHelper($this->tagsObserver, $this->type, $pk, $this->typeAlias, $this->table);
			}

			// Store the row.
			if (!$this->table->store())
			{
				$this->setError($this->table->getError());

				return false;
			}

			// Get the new item ID
			$newId = $this->table->get('id');

			// Add the new ID to the array
			$newIds[$pk] = $newId;
		}

		// Clean the cache
		$this->cleanCache();

		return $newIds;
	}

	/**
	 * Batch move items to a new category
	 *
	 * @param   integer  $value     The new category ID.
	 * @param   array    $pks       An array of row IDs.
	 * @param   array    $contexts  An array of item contexts.
	 *
	 * @return  boolean  True if successful, false otherwise and internal error is set.
	 *
	 * @since 12.2
	 */
	protected function batchMove($values, $pks, $contexts)
	{
		if (empty($this->batchSet))
		{
			// Set some needed variables.
			$this->user		= JFactory::getUser();
			$this->table		= $this->getTable();
			$this->tableClassName	= get_class($this->table);
			$this->canDo		= MoojlaHelper::getActions('course');
		}

		if (!$this->canDo->get('course.edit') && !$this->canDo->get('course.batch'))
		{
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_BATCH_CANNOT_EDIT'));
			return false;
		}

		// make sure published only updates if user has the permission.
		if (isset($values['published']) && !$this->canDo->get('core.edit.state'))
		{
			unset($values['published']);
		}
		// remove move_copy from array
		unset($values['move_copy']);

		if (isset($values['category']) && (int) $values['category'] > 0 && !static::checkCategoryId($values['category']))
		{
			return false;
		}
		elseif (isset($values['category']) && (int) $values['category'] > 0)
		{
			// move the category value to correct field name
			$values['catid'] = $values['category'];
			unset($values['category']);
		}
		elseif (isset($values['category']))
		{
			unset($values['category']);
		}


		// Parent exists so we proceed
		foreach ($pks as $pk)
		{
			if (!$this->user->authorise('course.edit', $contexts[$pk]))
			{
				$this->setError(JText::_('JLIB_APPLICATION_ERROR_BATCH_CANNOT_EDIT'));
				return false;
			}

			// Check that the row actually exists
			if (!$this->table->load($pk))
			{
				if ($error = $this->table->getError())
				{
					// Fatal error
					$this->setError($error);
					return false;
				}
				else
				{
					// Not fatal error
					$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_BATCH_MOVE_ROW_NOT_FOUND', $pk));
					continue;
				}
			}

			// insert all set values.
			if (MoojlaHelper::checkArray($values))
			{
				foreach ($values as $key => $value)
				{
					// Do special action for access.
					if ('access' === $key && strlen($value) > 0)
					{
						$this->table->$key = $value;
					}
					elseif (strlen($value) > 0 && isset($this->table->$key))
					{
						$this->table->$key = $value;
					}
				}
			}


			// Check the row.
			if (!$this->table->check())
			{
				$this->setError($this->table->getError());

				return false;
			}

			if (!empty($this->type))
			{
				$this->createTagsHelper($this->tagsObserver, $this->type, $pk, $this->typeAlias, $this->table);
			}

			// Store the row.
			if (!$this->table->store())
			{
				$this->setError($this->table->getError());

				return false;
			}
		}

		// Clean the cache
		$this->cleanCache();

		return true;
	}
	
	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.6
	 */
	public function save($data)
	{
		$input	= JFactory::getApplication()->input;
		$filter	= JFilterInput::getInstance();
        
		// set the metadata to the Item Data
		if (isset($data['metadata']) && isset($data['metadata']['author']))
		{
			$data['metadata']['author'] = $filter->clean($data['metadata']['author'], 'TRIM');
            
			$metadata = new JRegistry;
			$metadata->loadArray($data['metadata']);
			$data['metadata'] = (string) $metadata;
		}

		// Set the permanent_fields items to data.
		if (isset($data['permanent_fields']) && is_array($data['permanent_fields']))
		{
			$permanent_fields = new JRegistry;
			$permanent_fields->loadArray($data['permanent_fields']);
			$data['permanent_fields'] = (string) $permanent_fields;
		}
		elseif (!isset($data['permanent_fields']))
		{
			// Set the empty permanent_fields to data
			$data['permanent_fields'] = '';
		}


/***[JCBGUI.admin_view.php_save.129.$$$$]***/
	$moodleimgurl = $data["summary_files"];
	if($moodleimgurl)
    {
      $olddlpath = JPATH_ROOT.'/media/com_moojla/images/'.urldecode(basename($moodleimgurl));
      $dlpath = JPATH_ROOT.'/media/com_moojla/images/'.$data["remoteid"].'_'.urldecode(basename($moodleimgurl));
      if(!file_exists($dlpath) && !file_exists($olddlpath))
      {
        $ch = curl_init($moodleimgurl);
        $fp = fopen($dlpath, 'wb');
        curl_setopt($ch, CURLOPT_FILE, $fp);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_exec($ch);
        curl_close($ch);
        fclose($fp);
        $data["summary_files"] = basename($moodleimgurl) ? '/media/com_moojla/images/'.$data["remoteid"].'_'.basename($moodleimgurl) : '';
      }
      else
      {
        $data["summary_files"] = file_exists($dlpath) ? '/media/com_moojla/images/'.$data["remoteid"].'_'.basename($moodleimgurl) : '/media/com_moojla/images/'.basename($moodleimgurl);
      }
    }
    


    JPluginHelper::importPlugin("notifly");
    $dispatcher = JEventDispatcher::getInstance();
    $args = array('com_moojla.coursecreated', $data, true);
    $dispatcher->trigger("onContentAfterSave", $args);
/***[/JCBGUI$$$$]***/

        
		// Set the Params Items to data
		if (isset($data['params']) && is_array($data['params']))
		{
			$params = new JRegistry;
			$params->loadArray($data['params']);
			$data['params'] = (string) $params;
		}

		// Alter the shortname for save as copy
		if ($input->get('task') === 'save2copy')
		{
			$origTable = clone $this->getTable();
			$origTable->load($input->getInt('id'));

			if ($data['shortname'] == $origTable->shortname)
			{
				list($shortname, $alias) = $this->generateNewTitle($data['catid'], $data['alias'], $data['shortname']);
				$data['shortname'] = $shortname;
				$data['alias'] = $alias;
			}
			else
			{
				if ($data['alias'] == $origTable->alias)
				{
					$data['alias'] = '';
				}
			}

			$data['published'] = 0;
		}

		// Automatic handling of alias for empty fields
		if (in_array($input->get('task'), array('apply', 'save', 'save2new')) && (int) $input->get('id') == 0)
		{
			if ($data['alias'] == null || empty($data['alias']))
			{
				if (JFactory::getConfig()->get('unicodeslugs') == 1)
				{
					$data['alias'] = JFilterOutput::stringURLUnicodeSlug($data['shortname']);
				}
				else
				{
					$data['alias'] = JFilterOutput::stringURLSafe($data['shortname']);
				}

				$table = JTable::getInstance('course', 'moojlaTable');

				if ($table->load(array('alias' => $data['alias'], 'catid' => $data['catid'])) && ($table->id != $data['id'] || $data['id'] == 0))
				{
					$msg = JText::_('COM_MOOJLA_COURSE_SAVE_WARNING');
				}

				list($shortname, $alias) = $this->generateNewTitle($data['catid'], $data['alias'], $data['shortname']);
				$data['alias'] = $alias;

				if (isset($msg))
				{
					JFactory::getApplication()->enqueueMessage($msg, 'warning');
				}
			}
		}

		// Alter the unique field for save as copy
		if ($input->get('task') === 'save2copy')
		{
			// Automatic handling of other unique fields
			$uniqueFields = $this->getUniqueFields();
			if (MoojlaHelper::checkArray($uniqueFields))
			{
				foreach ($uniqueFields as $uniqueField)
				{
					$data[$uniqueField] = $this->generateUnique($uniqueField,$data[$uniqueField]);
				}
			}
		}
		
		if (parent::save($data))
		{
			return true;
		}
		return false;
	}
	
	/**
	 * Method to generate a unique value.
	 *
	 * @param   string  $field name.
	 * @param   string  $value data.
	 *
	 * @return  string  New value.
	 *
	 * @since   3.0
	 */
	protected function generateUnique($field,$value)
	{

		// set field value unique
		$table = $this->getTable();

		while ($table->load(array($field => $value)))
		{
			$value = StringHelper::increment($value);
		}

		return $value;
	}

	/**
	 * Method to change the title/s & alias.
	 *
	 * @param   string         $alias        The alias.
	 * @param   string/array   $title        The title.
	 *
	 * @return	array/string  Contains the modified title/s and/or alias.
	 *
	 */
	protected function _generateNewTitle($alias, $title = null)
	{

		// Alter the title/s & alias
		$table = $this->getTable();

		while ($table->load(array('alias' => $alias)))
		{
			// Check if this is an array of titles
			if (MoojlaHelper::checkArray($title))
			{
				foreach($title as $nr => &$_title)
				{
					$_title = StringHelper::increment($_title);
				}
			}
			// Make sure we have a title
			elseif ($title)
			{
				$title = StringHelper::increment($title);
			}
			$alias = StringHelper::increment($alias, 'dash');
		}
		// Check if this is an array of titles
		if (MoojlaHelper::checkArray($title))
		{
			$title[] = $alias;
			return $title;
		}
		// Make sure we have a title
		elseif ($title)
		{
			return array($title, $alias);
		}
		// We only had an alias
		return $alias;
	}
}
