<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		course_group_maps.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Course_group_maps Model
 */
class MoojlaModelCourse_group_maps extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
        {
			$config['filter_fields'] = array(
				'a.id','id',
				'a.published','published',
				'a.ordering','ordering',
				'a.created_by','created_by',
				'a.modified_by','modified_by',
				'a.role','role',
				'g.fullname','moojlacourse',
				'h.title','course_group'
			);
		}

		parent::__construct($config);
	}


/***[JCBGUI.admin_view.php_model_list.135.$$$$]***/
public function group_users($group_id)
{
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query->select('count(*) as num_of_group_users');
    $query->from($db->quoteName('#__user_usergroup_map', 'ugm'));
    $query->where($db->quoteName('ugm.group_id').'='.$db->quote($group_id));

    $db->setQuery($query);
    $result = $db->loadObject();
    
  return "<span style='background: #43a4c1;color: #fff;border-radius: 9px;padding: 2px 9px'>{$result->num_of_group_users} ".JText::_('COM_MOOJLA_GROUP_USERS')."</span>";
}

public function group_courses($group_id, $course_id)
{

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);

    $query->select('id');
    $query->from($db->quoteName('#__moojla_course_group_map', 'mgm'));
    $query->where($db->quoteName('mgm.course_group').'='.$db->quote($group_id));

    $db->setQuery($query);

    $results = $db->loadObjectList();

    if (count($results) > 1)
    {
        $html= jtext::_('COM_MOOJLA_GROUP_TOTAL_COURSES')." <span style='background: #f20d38;color: #fff;border-radius: 9px;padding: 2px 9px'>".count($results)."</span> ".jtext::_('COM_MOOJLA_ROW_ID');

        foreach ($results as $result) {
            $html .= "<span style='background: #48a835;color: #fff;border-radius: 9px;padding: 2px 9px'>{$result->id}</span> ";
        }
        return $html;
    }
}/***[/JCBGUI$$$$]***/


	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   An optional ordering field.
	 * @param   string  $direction  An optional direction (asc|desc).
	 *
	 * @return  void
	 *
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication();

		// Adjust the context to support modal layouts.
		if ($layout = $app->input->get('layout'))
		{
			$this->context .= '.' . $layout;
		}

		// Check if the form was submitted
		$formSubmited = $app->input->post->get('form_submited');

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access', 0, 'int');
		if ($formSubmited)
		{
			$access = $app->input->post->get('access');
			$this->setState('filter.access', $access);
		}

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$created_by = $this->getUserStateFromRequest($this->context . '.filter.created_by', 'filter_created_by', '');
		$this->setState('filter.created_by', $created_by);

		$created = $this->getUserStateFromRequest($this->context . '.filter.created', 'filter_created');
		$this->setState('filter.created', $created);

		$sorting = $this->getUserStateFromRequest($this->context . '.filter.sorting', 'filter_sorting', 0, 'int');
		$this->setState('filter.sorting', $sorting);

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$role = $this->getUserStateFromRequest($this->context . '.filter.role', 'filter_role');
		if ($formSubmited)
		{
			$role = $app->input->post->get('role');
			$this->setState('filter.role', $role);
		}

		$moojlacourse = $this->getUserStateFromRequest($this->context . '.filter.moojlacourse', 'filter_moojlacourse');
		if ($formSubmited)
		{
			$moojlacourse = $app->input->post->get('moojlacourse');
			$this->setState('filter.moojlacourse', $moojlacourse);
		}

		$course_group = $this->getUserStateFromRequest($this->context . '.filter.course_group', 'filter_course_group');
		if ($formSubmited)
		{
			$course_group = $app->input->post->get('course_group');
			$this->setState('filter.course_group', $course_group);
		}

		// List state information.
		parent::populateState($ordering, $direction);
	}
	
	/**
	 * Method to get an array of data items.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 */
	public function getItems()
	{
		// check in items
		$this->checkInNow();

		// load parent items
		$items = parent::getItems();

		// set selection value to a translatable value
		if (MoojlaHelper::checkArray($items))
		{
			foreach ($items as $nr => &$item)
			{
				// convert role
				$item->role = $this->selectionTranslation($item->role, 'role');
			}
		}

        
		// return items
		return $items;
	}

	/**
	 * Method to convert selection values to translatable string.
	 *
	 * @return translatable string
	 */
	public function selectionTranslation($value,$name)
	{
		// Array of role language strings
		if ($name === 'role')
		{
			$roleArray = array(
				0 => 'COM_MOOJLA_COURSE_GROUP_MAP_SELECT_ROLE',
				5 => 'COM_MOOJLA_COURSE_GROUP_MAP_STUDENT',
				3 => 'COM_MOOJLA_COURSE_GROUP_MAP_TEACHER',
				1 => 'COM_MOOJLA_COURSE_GROUP_MAP_MANAGER'
			);
			// Now check if value is found in this array
			if (isset($roleArray[$value]) && MoojlaHelper::checkString($roleArray[$value]))
			{
				return $roleArray[$value];
			}
		}
		return $value;
	}
	
	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return	string	An SQL query
	 */
	protected function getListQuery()
	{
		// Get the user object.
		$user = JFactory::getUser();
		// Create a new query object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);

		// Select some fields
		$query->select('a.*');

		// From the moojla_item table
		$query->from($db->quoteName('#__moojla_course_group_map', 'a'));

		// From the moojla_course table.
		$query->select($db->quoteName('g.fullname','moojlacourse_fullname'));
		$query->join('LEFT', $db->quoteName('#__moojla_course', 'g') . ' ON (' . $db->quoteName('a.moojlacourse') . ' = ' . $db->quoteName('g.remoteid') . ')');

		// From the usergroups table.
		$query->select($db->quoteName('h.title','course_group_title'));
		$query->join('LEFT', $db->quoteName('#__usergroups', 'h') . ' ON (' . $db->quoteName('a.course_group') . ' = ' . $db->quoteName('h.id') . ')');

		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published))
		{
			$query->where('a.published = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where('(a.published = 0 OR a.published = 1)');
		}
		// Filter by search.
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->quote('%' . $db->escape($search) . '%');
				$query->where('(a.moojlacourse LIKE '.$search.' OR g.fullname LIKE '.$search.' OR a.course_group LIKE '.$search.' OR h.title LIKE '.$search.')');
			}
		}

		// Filter by Role.
		$_role = $this->getState('filter.role');
		if (is_numeric($_role))
		{
			if (is_float($_role))
			{
				$query->where('a.role = ' . (float) $_role);
			}
			else
			{
				$query->where('a.role = ' . (int) $_role);
			}
		}
		elseif (MoojlaHelper::checkString($_role))
		{
			$query->where('a.role = ' . $db->quote($db->escape($_role)));
		}
		elseif (MoojlaHelper::checkArray($_role))
		{
			// Secure the array for the query
			$_role = array_map( function ($val) use(&$db) {
				if (is_numeric($val))
				{
					if (is_float($val))
					{
						return (float) $val;
					}
					else
					{
						return (int) $val;
					}
				}
				elseif (MoojlaHelper::checkString($val))
				{
					return $db->quote($db->escape($val));
				}
			}, $_role);
			// Filter by the Role Array.
			$query->where('a.role IN (' . implode(',', $_role) . ')');
		}

		// Add the list ordering clause.
		$orderCol = $this->state->get('list.ordering', 'a.id');
		$orderDirn = $this->state->get('list.direction', 'desc');
		if ($orderCol != '')
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}

		return $query;
	}
	
	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * @return  string  A store id.
	 *
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.id');
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.ordering');
		$id .= ':' . $this->getState('filter.created_by');
		$id .= ':' . $this->getState('filter.modified_by');
		// Check if the value is an array
		$_role = $this->getState('filter.role');
		if (MoojlaHelper::checkArray($_role))
		{
			$id .= ':' . implode(':', $_role);
		}
		// Check if this is only an number or string
		elseif (is_numeric($_role)
		 || MoojlaHelper::checkString($_role))
		{
			$id .= ':' . $_role;
		}
		$id .= ':' . $this->getState('filter.moojlacourse');
		$id .= ':' . $this->getState('filter.course_group');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to checkin all items left checked out longer then a set time.
	 *
	 * @return  a bool
	 *
	 */
	protected function checkInNow()
	{
		// Get set check in time
		$time = JComponentHelper::getParams('com_moojla')->get('check_in');

		if ($time)
		{

			// Get a db connection.
			$db = JFactory::getDbo();
			// reset query
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from($db->quoteName('#__moojla_course_group_map'));
			$db->setQuery($query);
			$db->execute();
			if ($db->getNumRows())
			{
				// Get Yesterdays date
				$date = JFactory::getDate()->modify($time)->toSql();
				// reset query
				$query = $db->getQuery(true);

				// Fields to update.
				$fields = array(
					$db->quoteName('checked_out_time') . '=\'0000-00-00 00:00:00\'',
					$db->quoteName('checked_out') . '=0'
				);

				// Conditions for which records should be updated.
				$conditions = array(
					$db->quoteName('checked_out') . '!=0', 
					$db->quoteName('checked_out_time') . '<\''.$date.'\''
				);

				// Check table
				$query->update($db->quoteName('#__moojla_course_group_map'))->set($fields)->where($conditions); 

				$db->setQuery($query);

				$db->execute();
			}
		}

		return false;
	}
}
