<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		muserfields.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Muserfields Form Field class for the Moojla component
 */
class JFormFieldMuserfields extends JFormFieldList
{
	/**
	 * The muserfields field type.
	 *
	 * @var		string
	 */
	public $type = 'muserfields';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
				// Get the user object.
		$fields = array ('firstname', 'lastname', 'email', 'icq', 'skype', 'yahoo', 'aim', 'msn', 'phone1', 'phone2', 'institution', 'department', 
					 'address', 'city', 'country', 'lang', 'timezone', 'idnumber', 'description', 'lastnamephonetic', 'firstnamephonetic', 'middlename', 'alternatename');

		$input = JFactory::getApplication()->input;
		$id = $input->get('id', 0);
		
		$options = array();
		$options[] = JHtml::_('select.option', '', 'Select an option');
		$items = array();
		JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');
		$data = array(
			"wsfunction"          => "moojla_get_custom_fields",
			"moodlewsrestformat"  => "json",
		);
		$items = json_decode(MoojlaHelper::sendRequestToMoodle($data)->response);
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('muserfields')));
		$query->from($db->quoteName('#__moojla_user_field_map'));
		$query->where($db->quoteName('id') . ' <> ' . $db->quote($id));
		$query->where($db->quoteName('published') . ' = 1');
		$db->setQuery($query);
		$selectedbefore = $db->loadColumn();
		
		foreach($fields as $field)
		{
			if(!in_array('sm_'.$field, $selectedbefore))
				$options[] = JHtml::_('select.option', 'sm_'.$field, $field);
		}
		foreach($items as $item)
		{
			if(!in_array('cm_'.$item->id, $selectedbefore))
				$options[] = JHtml::_('select.option', 'cm_'.$item->id, $item->name);
		}
		return $options;
	}
}
