<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		user_fields_map.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * User_fields_map Model
 */
class MoojlaModelUser_fields_map extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
        {
			$config['filter_fields'] = array(
				'a.id','id',
				'a.published','published',
				'a.ordering','ordering',
				'a.created_by','created_by',
				'a.modified_by','modified_by',
				'a.iscv','iscv',
				'g.name','juserfields',
				'h.id','muserfields'
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   An optional ordering field.
	 * @param   string  $direction  An optional direction (asc|desc).
	 *
	 * @return  void
	 *
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication();

		// Adjust the context to support modal layouts.
		if ($layout = $app->input->get('layout'))
		{
			$this->context .= '.' . $layout;
		}

		// Check if the form was submitted
		$formSubmited = $app->input->post->get('form_submited');

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access', 0, 'int');
		if ($formSubmited)
		{
			$access = $app->input->post->get('access');
			$this->setState('filter.access', $access);
		}

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$created_by = $this->getUserStateFromRequest($this->context . '.filter.created_by', 'filter_created_by', '');
		$this->setState('filter.created_by', $created_by);

		$created = $this->getUserStateFromRequest($this->context . '.filter.created', 'filter_created');
		$this->setState('filter.created', $created);

		$sorting = $this->getUserStateFromRequest($this->context . '.filter.sorting', 'filter_sorting', 0, 'int');
		$this->setState('filter.sorting', $sorting);

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$iscv = $this->getUserStateFromRequest($this->context . '.filter.iscv', 'filter_iscv');
		if ($formSubmited)
		{
			$iscv = $app->input->post->get('iscv');
			$this->setState('filter.iscv', $iscv);
		}

		$juserfields = $this->getUserStateFromRequest($this->context . '.filter.juserfields', 'filter_juserfields');
		if ($formSubmited)
		{
			$juserfields = $app->input->post->get('juserfields');
			$this->setState('filter.juserfields', $juserfields);
		}

		$muserfields = $this->getUserStateFromRequest($this->context . '.filter.muserfields', 'filter_muserfields');
		if ($formSubmited)
		{
			$muserfields = $app->input->post->get('muserfields');
			$this->setState('filter.muserfields', $muserfields);
		}

		// List state information.
		parent::populateState($ordering, $direction);
	}
	
	/**
	 * Method to get an array of data items.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 */
	public function getItems()
	{
		// check in items
		$this->checkInNow();

		// load parent items
		$items = parent::getItems();

		// set selection value to a translatable value
		if (MoojlaHelper::checkArray($items))
		{
			foreach ($items as $nr => &$item)
			{
				// convert iscv
				$item->iscv = $this->selectionTranslation($item->iscv, 'iscv');
			}
		}


/***[JCBGUI.admin_view.php_getitems_after_all.134.$$$$]***/
    foreach($items as $index => $it)
    {
      $items[$index]->juserfields_name = substr($it->juserfields, 3);
      $items[$index]->muserfields_id = substr($it->muserfields, 3);
    }
/***[/JCBGUI$$$$]***/

        
		// return items
		return $items;
	}

	/**
	 * Method to convert selection values to translatable string.
	 *
	 * @return translatable string
	 */
	public function selectionTranslation($value,$name)
	{
		// Array of iscv language strings
		if ($name === 'iscv')
		{
			$iscvArray = array(
				1 => 'COM_MOOJLA_USER_FIELD_MAP_YES',
				0 => 'COM_MOOJLA_USER_FIELD_MAP_NO'
			);
			// Now check if value is found in this array
			if (isset($iscvArray[$value]) && MoojlaHelper::checkString($iscvArray[$value]))
			{
				return $iscvArray[$value];
			}
		}
		return $value;
	}
	
	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return	string	An SQL query
	 */
	protected function getListQuery()
	{
		// Get the user object.
		$user = JFactory::getUser();
		// Create a new query object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);

		// Select some fields
		$query->select('a.*');

		// From the moojla_item table
		$query->from($db->quoteName('#__moojla_user_field_map', 'a'));

		// From the fields table.
		$query->select($db->quoteName('g.name','juserfields_name'));
		$query->join('LEFT', $db->quoteName('#__fields', 'g') . ' ON (' . $db->quoteName('a.juserfields') . ' = ' . $db->quoteName('g.id') . ')');

		// From the moojla_user_field_map table.
		$query->select($db->quoteName('h.id','muserfields_id'));
		$query->join('LEFT', $db->quoteName('#__moojla_user_field_map', 'h') . ' ON (' . $db->quoteName('a.muserfields') . ' = ' . $db->quoteName('h.id') . ')');

		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published))
		{
			$query->where('a.published = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where('(a.published = 0 OR a.published = 1)');
		}
		// Filter by search.
		$search = $this->getState('filter.search');
		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->quote('%' . $db->escape($search) . '%');
				$query->where('(a.juserfields LIKE '.$search.' OR g.name LIKE '.$search.' OR a.muserfields LIKE '.$search.' OR h.id LIKE '.$search.')');
			}
		}

		// Filter by Iscv.
		$_iscv = $this->getState('filter.iscv');
		if (is_numeric($_iscv))
		{
			if (is_float($_iscv))
			{
				$query->where('a.iscv = ' . (float) $_iscv);
			}
			else
			{
				$query->where('a.iscv = ' . (int) $_iscv);
			}
		}
		elseif (MoojlaHelper::checkString($_iscv))
		{
			$query->where('a.iscv = ' . $db->quote($db->escape($_iscv)));
		}

		// Add the list ordering clause.
		$orderCol = $this->state->get('list.ordering', 'a.id');
		$orderDirn = $this->state->get('list.direction', 'desc');
		if ($orderCol != '')
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}

		return $query;
	}
	
	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * @return  string  A store id.
	 *
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.id');
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.ordering');
		$id .= ':' . $this->getState('filter.created_by');
		$id .= ':' . $this->getState('filter.modified_by');
		$id .= ':' . $this->getState('filter.iscv');
		$id .= ':' . $this->getState('filter.juserfields');
		$id .= ':' . $this->getState('filter.muserfields');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to checkin all items left checked out longer then a set time.
	 *
	 * @return  a bool
	 *
	 */
	protected function checkInNow()
	{
		// Get set check in time
		$time = JComponentHelper::getParams('com_moojla')->get('check_in');

		if ($time)
		{

			// Get a db connection.
			$db = JFactory::getDbo();
			// reset query
			$query = $db->getQuery(true);
			$query->select('*');
			$query->from($db->quoteName('#__moojla_user_field_map'));
			$db->setQuery($query);
			$db->execute();
			if ($db->getNumRows())
			{
				// Get Yesterdays date
				$date = JFactory::getDate()->modify($time)->toSql();
				// reset query
				$query = $db->getQuery(true);

				// Fields to update.
				$fields = array(
					$db->quoteName('checked_out_time') . '=\'0000-00-00 00:00:00\'',
					$db->quoteName('checked_out') . '=0'
				);

				// Conditions for which records should be updated.
				$conditions = array(
					$db->quoteName('checked_out') . '!=0', 
					$db->quoteName('checked_out_time') . '<\''.$date.'\''
				);

				// Check table
				$query->update($db->quoteName('#__moojla_user_field_map'))->set($fields)->where($conditions); 

				$db->setQuery($query);

				$db->execute();
			}
		}

		return false;
	}
}
