<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		course_group_maps.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Course_group_maps Controller
 */
class MoojlaControllerCourse_group_maps extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_MOOJLA_COURSE_GROUP_MAPS';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Course_group_map', $prefix = 'MoojlaModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}


/***[JCBGUI.admin_view.php_controller_list.135.$$$$]***/
  function migrateFromJoomdle()
  {

    JLoader::register('MoojlaModelCourse_group_map', JPATH_ADMINISTRATOR.'/components/com_moojla/models/course_group_map.php');

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->quoteName('remoteid'));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('published') . ' = 1');
    $db->setQuery($query);
    $remoteids = $db->loadColumn();

    $counter = 0;
    $msgtype = 'success';

    try
    {
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('*');
      $query->from($db->quoteName('#__joomdle_course_groups'));
      $query->where($db->quoteName('course_id') . ' IN (' . implode(',', $remoteids) . ')');
      $db->setQuery($query);
      $joomdle_maps = $db->loadAssocList();


      /*$joomdle_maps = array(
              array(
                'id'          =>  1,
                'course_id'   =>  124,
                'group_id'    =>  52,
                'type'        =>  'teacher'
              ),
              array(
                'id'          =>  2,
                'course_id'   =>  195,
                'group_id'    =>  143,
                'type'        =>  'student'
              ),
              array(
                'id'          =>  3,
                'course_id'   =>  195,
                'group_id'    =>  142,
                'type'        =>  'teacher'
              ),
            );*/


      foreach($joomdle_maps as $row)
      {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->quoteName('#__moojla_course_group_map'));
        $query->where($db->quoteName('published') . ' = 1');
        $query->where($db->quoteName('moojlacourse') . ' = ' . $row['course_id']);
        $query->where($db->quoteName('role') . ' = ' . ($row['type'] == 'teacher' ? 3 : 5));

        $db->setQuery($query);
        $found = $db->loadAssocList();
        if(!$found)
        {
          $cgm = new MoojlaModelCourse_group_map;
          $data = array(
            'course_group'  =>  $row['group_id'],
            'moojlacourse'  =>  $row['course_id'],
            'role'          =>  ($row['type'] == 'teacher' ? 3 : 5)
          );
          $cgm->save($data);
          $counter += 1;
        }
      }

      $message = JText::sprintf('COM_MOOJLA_S_GROUP_MAP_MIGRATED_FROM_JOOMDLE_SUCCESSFULLY', $counter);
    }
    catch(Exception $e)
    {
      $message = $e->getMessage();
      $msgtype = 'error';
      // dump($e->getMessage(), 'fail');
    }

    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=course_group_maps", false), $message, $msgtype);
  }

  function fetch()
  {
    $params = JComponentHelper::getParams('com_moojla');
    $step = $params->get('coursegroupferchstep', 5);
    $logpath = trim($params->get('coursegrouplog'));
    
    JLoader::register('MoojlaModelCourse_group_map', JPATH_ADMINISTRATOR.'/components/com_moojla/models/course_group_map.php');
    $sql = "
    SELECT
        SUBSTRING_INDEX(t1.row, '-', 1) as remoteid,
        SUBSTRING_INDEX(t1.row, '-', -1) as role 
    FROM
        (
        SELECT
            CONCAT(c.remoteid, '-', r.role) AS ROW
        FROM
            `#__moojla_course` AS c
        CROSS JOIN(
            SELECT
                3 AS role
            UNION
            SELECT
                3
            UNION
            SELECT
                5
        ) AS r
        WHERE c.published = 1
    ) AS t1
    WHERE t1.row NOT IN 
    (
        SELECT
            CONCAT(cgm.moojlacourse, '-', cgm.role) AS er
        FROM
            `#__moojla_course_group_map` AS cgm
		INNER JOIN `#__usergroups` AS ug
        	ON ug.id = cgm.course_group
				WHERE cgm.published = 1
    )";

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query = $sql;
    $db->setQuery($query);
    $not_mapped = $db->loadAssocList();

    $not_mapped_remoteids = array_column($not_mapped, 'remoteid');

    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->clear();
    $query->select($db->quoteName( array('remoteid', 'shortname')));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('published') . ' = 1');
    $query->where($db->quoteName('remoteid') . ' IN (' . implode(',', $not_mapped_remoteids) . ')');
    $db->setQuery($query);
    $not_mapped_names = $db->loadAssocList('remoteid');

    JPluginHelper::importPlugin("moojlaevents");
    $dispatcher = JEventDispatcher::getInstance();
    if(isset($_GET['c']))
      $c = $_GET['c'];
    else
    	$c = 0;
    $app = JFactory::getApplication();
    
    foreach($not_mapped as $np)
    {
      $course_name = $not_mapped_names[$np['remoteid']]['shortname'];
      $group_name = $course_name . ' (' .($np['role'] == 3 ? 'TEACHERS' : 'STUDENTS') . ')';
      $group_id		= $dispatcher->trigger("addGroup", array($np['remoteid'], $group_name, ($np['role'] == 3 ? 'teachers' : 'students')));

      $cgmap = new MoojlaModelCourse_group_map;
      $data = array(
        'moojlacourse'  =>  $np['remoteid'],
        'course_group'  =>  current($group_id),
        'role'          =>  $np['role']
      );
      
      $db = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select($db->quoteName('id'));
      $query->from($db->quoteName('#__moojla_course_group_map'));
      $query->where($db->quoteName('moojlacourse') . ' = ' . $db->quote($np['remoteid']));	
      $query->where($db->quoteName('role') . ' = ' . $np['role']);	
      $query->where($db->quoteName('published') . ' = 1');
      $db->setQuery($query);
      $exist = $db->loadResult();
      if($exist)
      {
        $data['id'] = $exist;
      }

      $date = new DateTime();
      $date = $date->format("y:m:d h:i:s");
      if($cgmap->save($data))
      {
        if($logpath)
        {
          file_put_contents($logpath, print_r($date, True).PHP_EOL, FILE_APPEND);
          file_put_contents($logpath, "Added data: ".print_r($data, True).PHP_EOL, FILE_APPEND);
        }
      }
      else
      {
        if($logpath)
        {
          file_put_contents($logpath, print_r($date, True).PHP_EOL, FILE_APPEND);
          file_put_contents($logpath, "Failed and error is: ".print_r($cgmap->getError(), True).PHP_EOL, FILE_APPEND); 
        }
      }
      $c += 1;
      if($c % $step == 0)
      {
        // $app->redirect(JRoute::_("index.php?option=com_moojla&view=course_group_maps&task=course_group_maps.fetch&c=$c", false));
        $context = stream_context_create(
          array(
            'http' => array(
              'follow_location' => false
            )
          )
        );
        $content = file_get_contents(JRoute::_("index.php?option=com_moojla&view=course_group_maps&task=course_group_maps.fetch&c=$c", false), false, $context);
      }
    }

    $counter = count($not_mapped);
    $message = JText::sprintf('COM_MOOJLA_S_GROUP_MAP_ADDED_SUCCESSFULLY', $counter);
    $app = JFactory::getApplication();
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=course_group_maps", false), $message, 'success');
  }
/***[/JCBGUI$$$$]***/

}
