<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		mycustomtemplatestyle.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Mycustomtemplatestyle Form Field class for the Moojla component
 */
class JFormFieldMycustomtemplatestyle extends JFormFieldList
{
	/**
	 * The mycustomtemplatestyle field type.
	 *
	 * @var		string
	 */
	public $type = 'mycustomtemplatestyle';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		// Get the user object.
		$user = JFactory::getUser();
		// Get the databse object.
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('a.id','a.title'),array('id','course_templatestyle_title')));
		$query->from($db->quoteName('#__template_styles', 'a'));
		$query->where($db->quoteName('a.client_id') . ' = 0');
		$query->order('a.title ASC');
		// Implement View Level Access (if set in table)
		if (!$user->authorise('core.options', 'com_templates'))
		{
			$columns = $db->getTableColumns('#__template_styles');
			if(isset($columns['access']))
			{
				$groups = implode(',', $user->getAuthorisedViewLevels());
				$query->where('a.access IN (' . $groups . ')');
			}
		}
		$db->setQuery((string)$query);
		$items = $db->loadObjectList();
		$options = array();
		$tmp_op = array();
		if ($items)
		{
			$first = current($items);
			$lbl = explode(' - ', $first->course_templatestyle_title)[0];
			$options[] = JHtml::_('select.option', '', JText::_('JOPTION_USE_DEFAULT'));
			$groups = array();
			foreach($items as $item)
			{
				$thislbl = explode(' - ', $item->course_templatestyle_title)[0];
				 $groups[$thislbl][] = ['id' => $item->id, 'course_templatestyle_title' => $item->course_templatestyle_title];
			}
			foreach($groups as $gkey => $group)
			{
				$options[] = JHtmlSelect::optgroup($gkey);
				foreach($group as $item)
				{          
					$options[] = JHtml::_('select.option', $item['id'], $item['course_templatestyle_title']);
				}
				$options[] = JHtmlSelect::optgroup($gkey);
			}
////
		}
		return $options;
	}
}
