<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of articles.
 *
 * @since  1.6
 */
class NotiflyViewIntegrations extends JViewLegacy
{

	/**
	 * An array of items
	 *
	 * @var  array
	 */
	protected $items;

	/**
	 * The pagination object
	 *
	 * @var  JPagination
	 */
	protected $pagination;

	/**
	 * The model state
	 *
	 * @var  object
	 */
	protected $state;

	/**
	 * Form object for search filters
	 *
	 * @var  JForm
	 */
	public $filterForm;

	/**
	 * The active search filters
	 *
	 * @var  array
	 */
	public $activeFilters;

	/**
	 * The sidebar markup
	 *
	 * @var  string
	 */
	protected $sidebar;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed  A string if successful, otherwise an Error object.
	 */
	public function display($tpl = null)
	{
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->state         = $this->get('State');
		// $this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');
		
		NotiflyHelper::addSubmenu('integrations');
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();

		return parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		$canDo = JHelperContent::getActions('com_notifly', 'integrations');
		$user  = JFactory::getUser();

		// Get the toolbar object instance
		$bar = JToolbar::getInstance('toolbar');

		JToolbarHelper::title(JText::_('COM_NOTIFLY_INTEGRATIONS_TITLE'), 'stack integrations');

		// if ($canDo->get('core.create') || count($user->getAuthorisedCategories('com_notifly', 'core.create')) > 0)
		// {
		// 	JToolbarHelper::addNew('article.add');
		// }

		// if ($canDo->get('core.edit') || $canDo->get('core.edit.own'))
		// {
		// 	JToolbarHelper::editList('article.edit');
		// }

		// if ($canDo->get('core.edit.state'))
		// {
		// 	JToolbarHelper::publish('articles.publish', 'JTOOLBAR_PUBLISH', true);
		// 	JToolbarHelper::unpublish('articles.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		// 	JToolbarHelper::custom('articles.featured', 'featured.png', 'featured_f2.png', 'JFEATURE', true);
		// 	JToolbarHelper::custom('articles.unfeatured', 'unfeatured.png', 'featured_f2.png', 'JUNFEATURE', true);
		// 	JToolbarHelper::archiveList('articles.archive');
		// 	JToolbarHelper::checkin('articles.checkin');
		// }

		// Add a batch button
		// if ($user->authorise('core.create', 'com_notifly')
		// 	&& $user->authorise('core.edit', 'com_notifly')
		// 	&& $user->authorise('core.edit.state', 'com_notifly'))
		// {
		// 	$title = JText::_('JTOOLBAR_BATCH');

		// 	// Instantiate a new JLayoutFile instance and render the batch button
		// 	$layout = new JLayoutFile('joomla.toolbar.batch');

		// 	$dhtml = $layout->render(array('title' => $title));
		// 	$bar->appendButton('Custom', $dhtml, 'batch');
		// }
		
		if ($user->authorise('core.admin', 'com_notifly') || $user->authorise('core.options', 'com_notifly'))
		{
			JToolbarHelper::preferences('com_notifly');
		}

		$help_url  = 'https://www.themexpert.com/docs';
		JToolbarHelper::help( 'COM_NOTIFLY_HELP_SITE', false, $help_url );
	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array(
			'a.ordering'     => JText::_('JGRID_HEADING_ORDERING'),
			'a.state'        => JText::_('JSTATUS'),
			'a.title'        => JText::_('JGLOBAL_TITLE'),
			'category_title' => JText::_('JCATEGORY'),
			'access_level'   => JText::_('JGRID_HEADING_ACCESS'),
			'a.created_by'   => JText::_('JAUTHOR'),
			'language'       => JText::_('JGRID_HEADING_LANGUAGE'),
			'a.created'      => JText::_('JDATE'),
			'a.id'           => JText::_('JGRID_HEADING_ID'),
			'a.featured'     => JText::_('JFEATURED')
		);
	}
}
