<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JLoader::register('NotiflyMessageHelper', JPATH_COMPONENT_ADMINISTRATOR . '/helpers/message.php');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', '.multipleAccessLevels', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_ACCESS')));
JHtml::_('formbehavior.chosen', '.multipleAuthors', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_AUTHOR')));
JHtml::_('formbehavior.chosen', '.multipleCategories', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_CATEGORY')));
JHtml::_('formbehavior.chosen', '.multipleTags', null, array('placeholder_text_multiple' => JText::_('JOPTION_SELECT_TAG')));
JHtml::_('formbehavior.chosen', 'select');

$user      = JFactory::getUser();
$userId    = $user->get('id');

JHtml::_('jquery.framework');
JHtml::_('script', 'com_notifly/showdown.min.js', array('version' => 'auto', 'relative' => true));
?>

<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=events'); ?>" method="post" name="adminForm" id="adminForm">
	<div id="cf" class="events tx-flex">
		<?php if (!empty( $this->sidebar)) : ?>
		<div class="tx-sidebar">
			<?php echo $this->sidebar; ?>
		</div>
		<div class="tx-main">
			<?php else : ?>
		<div class="tx-main">
			<?php endif; ?>
			<div class="page-header">
			  <h1>Events</h1>
			  <?php
				// Search tools bar
				// echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
				?>
			  <nav class="navbar navbar-default">
			  	<div class="container-fluid">
			  		<div class="collapse navbar-collapse">
			  			<div class="navbar-form navbar-left">
			  				<?php 
			  				$filters = $this->filterForm->getGroup('filter');
			  				?>
			  				<?php foreach ($filters as $fieldName => $field) : ?>
							<?php if ($fieldName == 'filter_extension_id') : ?>
								<?php $dataShowOn = ''; ?>
								<?php if ($field->showon) : ?>
									<?php JHtml::_('jquery.framework'); ?>
									<?php JHtml::_('script', 'jui/cms.js', array('version' => 'auto', 'relative' => true)); ?>
									<?php $dataShowOn = " data-showon='" . json_encode(JFormHelper::parseShowOnConditions($field->showon, $field->formControl, $field->group)) . "'"; ?>
								<?php endif; ?>
								<div class="js-stools-field-filter"<?php echo $dataShowOn; ?>>
									<?php echo $field->input; ?>
								</div>
							<?php endif; ?>
						<?php endforeach; ?>
					  	</div>
					  	<div class="navbar-form navbar-right">
					  		<!-- 
					  		<div class="input-group">
						      <input name="filter[search]" id="filter_search" type="text" class="form-control" placeholder="Search events...">
						      <span class="input-group-btn">
						        <button class="btn btn-default" type="button">Search</button>
						      </span>
						    </div>
						     -->
						     <!-- /input-group -->
					  	</div>
			  		</div>
			  	</div>
			  </nav>
			</div>
			<div class="page-content">
				<?php echo NotiflyHelper::showWarning(); ?>
				
				<table class="table table-hover">
					<tbody>
					<?php foreach ($this->items as $i => $item) : ?>
						<?php $token = JFactory::getSession()->getFormToken(); ?>
						<?php 
						if(!$item->image_url) $img = "//logo.clearbit.com/themesgrove.com"; else $img = $item->image_url;
						 ?>
						<tr>
							<td width="70%">
								<div class="row">
									<div class="col-md-2">
							      		<h3><img class="media-object img-circle" 
							      			src="<?php echo $img ?>" alt="Image" 
							      			style="width: 64px; height: 64px; margin: 0 auto;"
						      			/></h3>
								  </div>
								  <div class="col-md-10">
								    <h4 class="muted text-uppercase"><?php echo $item->template; ?></h4>
								    <p class="event-message"><?php echo NotiflyMessageHelper::parseMessage($item->message, $item); ?></p>
								  </div>
								</div>
							</td>
							<td width="15%">
								<strong>Created</strong> <br> <?php echo date("D, M jS Y", strtotime($item->created)); ?>
							</td>
							<td width="15%">
								<a href="index.php?option=com_notifly&task=event.edit&id=<?php echo $item->id; ?>&<?php echo $token; ?>=1" class="btn btn-primary"><i class="cfi-edit"></i> Edit</a>
								<a href="index.php?option=com_notifly&task=event.delete&cid=<?php echo $item->id; ?>&<?php echo $token; ?>=1" class="btn btn-warning"><i class="cfi-trash-2"></i></a>
							</td>
						</tr>
					<?php endforeach; ?>
					</tbody>
				</table>
			
			<?php echo $this->pagination->getListFooter(); ?>
			
			</div>
			
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<?php echo JHtml::_('form.token'); ?>
		</div>
	</div>
</form>
<script type="text/javascript">window.convertFromMarkdown();</script>
