<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Gallery\Field;

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;

defined('CBLIB') or die();

class GalleryField extends \cbFieldHandler
{

	/**
	 * Accessor:
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output               'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $reason               'profile' for user profile view, 'edit' for profile edit, 'register' for registration, 'search' for searches
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed
	 */
	public function getField( &$field, &$user, $output, $reason, $list_compare_types )
	{
		if ( $output === 'htmledit' ) {
			return null;
		}

		$asset			=	str_replace( '[field_id]', $field->getInt( 'fieldid', 0 ), $field->params->getString( 'gallery_asset' ) );

		if ( ! $asset ) {
			$asset		=	'profile.' . $user->getInt( 'id', 0 ) . '.field.' . $field->getInt( 'fieldid', 0 );
		}

		$gallery		=	new Gallery( $asset, $user );

		$gallery->parse( $field->params, 'gallery_' );

		$gallery->set( 'field', $field->getInt( 'fieldid', 0 ) );

		$layout			=	$field->params->getString( 'gallery_layout', 'gallery' );

		if ( ( $output === 'html' ) && ( $reason !== 'list' ) && ( $layout !== 'count' ) ) {
			if ( ( ! Application::Config()->getInt( 'showEmptyFields', 1 ) ) && ( ! $gallery->folders( 'count' ) ) && ( ! $gallery->items( 'count' ) ) && ( ! CBGallery::canCreateFolders( $gallery ) ) && ( ! CBGallery::canCreateItems( 'all', 'both', $gallery ) ) ) {
				return null;
			}

			$return		=	$gallery->gallery();

			if ( ! $return ) {
				return null;
			}

			return $this->formatFieldValueLayout( $this->_formatFieldOutput( $field->getString( 'name' ), $return, $output, false ), $reason, $field, $user );
		}

		$return			=	$this->_formatFieldOutput( $field->getString( 'name' ), $gallery->items( 'count' ), $output, false );

		if ( $output === 'html' ) {
			$return		=	$this->formatFieldValueLayout( $return, $reason, $field, $user );
		}

		return $return;
	}
}