<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Gallery\Table\FolderTable;
use CB\Plugin\Gallery\Table\ItemTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryGallery
{

	/**
	 * @param FolderTable|null   $folder
	 * @param FolderTable[]|null $folders
	 * @param cbPageNav|null     $foldersPageNav
	 * @param ItemTable[]        $items
	 * @param cbPageNav          $itemsPageNav
	 * @param string             $searching
	 * @param array              $input
	 * @param UserTable          $viewer
	 * @param Gallery            $gallery
	 * @param CBplug_cbgallery   $plugin
	 * @param string             $output
	 */
	public static function showGallery( $folder, $folders, $foldersPageNav, $items, $itemsPageNav, $searching, $input, $viewer, $gallery, $plugin, $output = null )
	{
		global $_CB_framework, $_PLUGINS;

		if ( $gallery->getInt( 'published' ) === -1 ) {
			$canCreateFolders					=	false;
			$canCreateItems						=	false;
		} else {
			$canCreateFolders					=	( ( $folder === null ) && CBGallery::canCreateFolders( $gallery ) );
			$canCreateItems						=	CBGallery::canCreateItems( 'all', 'both', $gallery );
		}

		$canSearchFolders						=	( $gallery->getBool( 'folders', true ) && ( $folder === null ) && $gallery->getBool( 'folders_search', true ) && ( $gallery->folders( 'count' ) || $searching ) );
		$canSearchItems							=	( $gallery->getBool( ( $folder ? 'folders_' : null ) . 'items_search', true ) && ( $gallery->items( 'count' ) || $searching ) );

		$integrations							=	$_PLUGINS->trigger( 'gallery_onBeforeDisplayGallery', array( &$folder, &$folders, &$foldersPageNav, &$items, &$itemsPageNav, &$searching, &$input, $viewer, $gallery, $output ) );

		$returnUrl								=	base64_encode( $gallery->location() );

		$return									=	'<div class="gallery' . htmlspecialchars( $gallery->id() ) . '" data-cbgallery-gallery="' . htmlspecialchars( $gallery->id() ) . '">'
												.		implode( '', $integrations );

		if ( $folder !== null ) {
			$return								.=		HTML_cbgalleryFolder::showFolder( $folder, $viewer, $gallery, $plugin, $output );
		}

		if ( $canCreateFolders || $canCreateItems || $canSearchFolders || $canSearchItems ) {
			$return								.=		'<div class="d-flex flex-wrap no-gutters mb-3 galleryHeader">';

			if ( $canCreateFolders || $canCreateItems ) {
				$buttons						=	array();

				if ( $canCreateItems ) {
					$canUpload					=	CBGallery::canCreateItems( 'all', 'upload', $gallery );
					$canLink					=	CBGallery::canCreateItems( 'all', 'link', $gallery );

					$createButton				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'items', 'func' => 'new', 'folder' => $gallery->getInt( 'folder', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="btn btn-success btn-sm-block galleryButton galleryButtonNewItem"><span class="fa fa-plus-circle"></span> ';

					if ( $canUpload && $canLink ) {
						$createButton			.=		CBTxt::T( 'Upload / Link New Media' );
					} elseif ( $canUpload ) {
						$createButton			.=		CBTxt::T( 'Upload New Media' );
					} elseif ( $canLink ) {
						$createButton			.=		CBTxt::T( 'Link New Media' );
					}

					$createButton				.=	'</a>';

					$buttons[]					=	$createButton;
				}

				if ( $canCreateFolders ) {
					$buttons[]					=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'new', 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="btn btn-success btn-sm-block galleryButton galleryButtonNewAlbum"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Create New Album' ) . '</a>';
				}

				$return							.=			'<div class="col-12 ' . ( ( $canSearchFolders || $canSearchItems ) ? ( $input['type'] ? 'col-sm-6' : 'col-sm-8' ) . ' mb-2 mb-sm-0' : null ) . '">'
												.				implode( ' ', $buttons )
												.			'</div>';
			}

			if ( $canSearchFolders || $canSearchItems ) {
				$return							.=			'<div class="col-12 ' . ( ! ( $canCreateFolders || $canCreateItems ) ? ( $input['type'] ? 'offset-sm-6 ' : 'offset-sm-8 ' ) : null ) . ( $input['type'] ? 'col-sm-6' : 'col-sm-4' ) . ' text-sm-right">'
												.				'<form action="' . htmlspecialchars( $gallery->location() ) . '" method="post" name="gallerySearchForm' . htmlspecialchars( $gallery->id() ) . '" class="m-0 gallerySearchForm">'
												.					'<input type="hidden" name="gallery" value="' . htmlspecialchars( $gallery->id() ) . '" />'
												.					'<div class="input-group">'
												.						$input['search']
												.						$input['type']
												.						'<div class="input-group-append">'
												.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
												.						'</div>'
												.					'</div>'
												.				'</form>'
												.			'</div>';
			}

			$return								.=		'</div>';
		}

		if ( $folders !== null ) {
			$return								.=		HTML_cbgalleryFolders::showFolders( $folders, $foldersPageNav, $viewer, $gallery, $plugin, $output );
		}

		if ( $items || ( $folder !== null ) || ( $folders === null ) || $searching ) {
			if ( $folders !== null ) {
				$return							.=		'<hr class="mt-3 mb-3" />';
			}

			$return								.=		HTML_cbgalleryItems::showItems( $folder, $items, $itemsPageNav, $viewer, $gallery, $plugin, $output );
		}

		$return									.=		implode( '', $_PLUGINS->trigger( 'gallery_onAfterDisplayGallery', array( $folder, $folders, $foldersPageNav, $items, $itemsPageNav, $searching, $input, $viewer, $gallery, $output ) ) )
												.	'</div>';

		echo $return;
	}
}