<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CBLib\Input\Get;
use CBLib\Registry\GetterInterface;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\InviteTable;
use CB\Plugin\GroupJive\Table\NotificationTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );
$_PLUGINS->loadPluginGroup( 'user/plug_cbgroupjive/plugins' );

class CBplug_cbgroupjive extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		$format				=	$this->getInput()->getString( 'format' );

		if ( $format !== 'raw' ) {
			outputCbJs();
			outputCbTemplate();
		}

		$action				=	$this->getInput()->getString( 'action' );
		$function			=	$this->getInput()->getString( 'func' );
		$id					=	$this->getInput()->getInt( 'id', 0 );

		if ( $user === null ) {
			$user			=	CBuser::getMyUserDataInstance();
		}

		if ( $format !== 'raw' ) {
			ob_start();
		}

		// TODO: For B/C: remove in 4.0.0
		$cat				=	$this->getInput()->getInt( 'cat', 0 );
		$grp				=	$this->getInput()->getInt( 'grp', 0 );

		switch ( $action ) {
			case 'overview': // TODO: For B/C: remove in 4.0.0
			case 'allcategories':
				$action		=	'categories';
				$function	=	'all';
				break;
			case 'allgroups':
				$action		=	'groups';
				$function	=	'all';
				break;
			case 'panel': // TODO: For B/C: remove in 4.0.0
			case 'mygroups':
				$action		=	'groups';
				$function	=	'my';
				break;
			case 'ownedgroups':
				$action		=	'groups';
				$function	=	'owned';
				break;
			case 'joinedgroups':
				$action		=	'groups';
				$function	=	'joined';
				break;
			case 'invitedgroups':
				$action		=	'groups';
				$function	=	'invited';
				break;
			case 'groupsapproval':
				$action		=	'groups';
				$function	=	'approval';
				break;
			case 'newgroup':
				$action		=	'groups';
				$function	=	'new';

				if ( $id ) {
					$this->getInput()->set( 'category', $id );
				}
				break;
			case 'editgroup':
				$action		=	'groups';
				$function	=	'edit';
				break;
			case 'messagegroup':
				$action		=	'groups';
				$function	=	'message';
				break;
			case 'groupnotifications':
				$action		=	'groups';
				$function	=	'notifications';
				break;
			case 'categories': // TODO: For B/C: remove in 4.0.0
				if ( $cat ) {
					$id		=	$cat;
				}
				break;
			case 'groups': // TODO: For B/C: remove in 4.0.0
				if ( $cat ) {
					$this->getInput()->set( 'category', $cat );
				}

				if ( $grp ) {
					$id		=	$grp;
				}
				break;
			default: // TODO: For B/C: remove in 4.0.0
				if ( $cat ) {
					$this->getInput()->set( 'category', $cat );
				}

				if ( $grp ) {
					$this->getInput()->set( 'group', $grp );
				}
				break;
		}

		switch ( $action ) {
			case 'groups':
				switch ( $function ) {
					case 'reject':
						$this->rejectGroupInvites( $id, $user );
						break;
					case 'cancel':
						$this->cancelGroupJoin( $id, $user );
						break;
					case 'join':
						$this->joinGroup( $id, $user );
						break;
					case 'leave':
						$this->leaveGroup( $id, $user );
						break;
					case 'publish':
						$this->stateGroup( 1, $id, $user );
						break;
					case 'unpublish':
						$this->stateGroup( 0, $id, $user );
						break;
					case 'delete':
						$this->deleteGroup( $id, $user );
						break;
					case 'new':
						$this->showGroupEdit( null, $user );
						break;
					case 'edit':
						$this->showGroupEdit( $id, $user );
						break;
					case 'save':
						cbSpoofCheck( 'plugin' );
						$this->saveGroupEdit( $id, $user );
						break;
					case 'message':
						$this->showGroupMessage( $id, $user );
						break;
					case 'send':
						cbSpoofCheck( 'plugin' );
						$this->sendGroupMessage( $id, $user );
						break;
					case 'notifications':
						$this->showGroupNotifications( $id, $user );
						break;
					case 'all':
					case 'my':
					case 'owned':
					case 'joined':
					case 'invited':
					case 'approval':
						$this->showGroups( $function, $user );
						break;
					case 'show':
					default:
						$this->showGroup( $id, $user );
						break;
				}
				break;
			case 'users':
				switch ( $function ) {
					case 'ban':
						$this->statusUser( -1, $id, $user );
						break;
					case 'active':
					case 'member':
						$this->statusUser( 1, $id, $user );
						break;
					case 'moderator':
						$this->statusUser( 2, $id, $user );
						break;
					case 'admin':
						$this->statusUser( 3, $id, $user );
						break;
					case 'owner':
						$this->statusUser( 4, $id, $user );
						break;
					case 'delete':
						$this->deleteUser( $id, $user );
						break;
				}
				break;
			case 'invites':
				switch ( $function ) {
					case 'send':
						$this->sendInvite( $id, $user );
						break;
					case 'new':
						$this->showInviteEdit( null, $user );
						break;
					case 'edit':
						$this->showInviteEdit( $id, $user );
						break;
					case 'save':
						cbSpoofCheck( 'plugin' );
						$this->saveInviteEdit( $id, $user );
						break;
					case 'delete':
						$this->deleteInvite( $id, $user );
						break;
				}
				break;
			case 'notifications':
				if ( $function === 'save' ) {
					cbSpoofCheck( 'plugin' );
					$this->saveNotifications( $id, $user );
				}
				break;
			case 'categories':
			default:
				switch ( $function ) {
					case 'all':
						$this->showCategories( $user );
						break;
					case 'show':
					default:
						$this->showCategory( $id, $user );
						break;
				}
				break;
		}

		if ( $format !== 'raw' ) {
			$html			=	ob_get_clean();

			$class			=	$this->params->getString( 'general_class' );

			$return			=	'<div class="cbGroupJive' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
							.		$html
							.	'</div>';

			echo $return;
		}
	}

	/**
	 * prepare frontend categories render
	 *
	 * @param UserTable $user
	 */
	private function showCategories( $user )
	{
		global $_CB_framework, $_CB_database;

		CBGroupJive::getTemplate( 'categories' );

		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$limit					=	$this->params->getInt( 'categories_limit', 30 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( 'gj_categories_limitstart{com_comprofiler}', 'gj_categories_limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( 'gj_categories_search{com_comprofiler}', 'gj_categories_search' );
		$where					=	null;

		$categories				=	$this->getInput()->getString( 'categories' );

		if ( $search && $this->params->getInt( 'categories_search', 1 ) ) {
			$where				.=	"\n " . ( ( ! $isModerator ) || $categories ? "AND" : "WHERE" ) . " ( c." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR c." . $_CB_database->NameQuote( 'description' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );

		$query					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c";

		if ( ! $isModerator ) {
			$query				.=	"\n WHERE c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND c." . $_CB_database->NameQuote( 'access' ) . " IN " . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) );
		}

		if ( $categories ) {
			$query				.=	"\n " . ( ! $isModerator ? "AND" : "WHERE" ) . " c." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $categories ) );
		}

		$query					.=	$where;
		$_CB_database->setQuery( $query );
		$total					=	(int) $_CB_database->loadResult();

		$pageNav				=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( 'gj_categories_' );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'all', 'categories' => $this->getInput()->getString( 'categories' ), 'gj_categories_search' => ( $searching ? $search : null ) ) ) );

		switch( $this->params->getInt( 'categories_orderby', 1 ) ) {
			case 2:
				$orderBy		=	'c.' . $_CB_database->NameQuote( 'ordering' ) . ' DESC';
				break;
			case 3:
				$orderBy		=	'c.' . $_CB_database->NameQuote( 'name' ) . ' ASC';
				break;
			case 4:
				$orderBy		=	'c.' . $_CB_database->NameQuote( 'name' ) . ' DESC';
				break;
			case 5:
				$orderBy		=	$_CB_database->NameQuote( '_groups' ) . ' ASC';
				break;
			case 6:
				$orderBy		=	$_CB_database->NameQuote( '_groups' ) . ' DESC';
				break;
			case 1:
			default:
				$orderBy		=	'c.' . $_CB_database->NameQuote( 'ordering' ) . ' ASC';
				break;
		}

		$groups					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' );

		if ( ( ! $isModerator ) && $user->getInt( 'id', 0 ) ) {
			$groups				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
								.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
		}

		$groups					.=	"\n WHERE g." . $_CB_database->NameQuote( 'category' ) . " = c." . $_CB_database->NameQuote( 'id' )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $isModerator ) {
			if ( $user->getInt( 'id', 0 ) ) {
				$groups			.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
								.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
								.		' OR u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3'
								.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )';
			} else {
				$groups			.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3";
			}
		}

		$query					=	'SELECT c.*'
								.	', ( ' . $groups . ' ) AS _groups'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c";

		if ( ! $isModerator ) {
			$query				.=	"\n WHERE c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND c." . $_CB_database->NameQuote( 'access' ) . " IN " . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) );
		}

		if ( $categories ) {
			$query				.=	"\n " . ( ! $isModerator ? "AND" : "WHERE" ) . " c." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $categories ) );
		}

		$query					.=	$where
								.	"\n ORDER BY " . $orderBy;
		if ( $this->params->getInt( 'categories_paging', 1 ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows					=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\CategoryTable', array( $_CB_database ) );

		CBGroupJive::prefetchCategories( $rows );
		CBGroupJive::prefetchUsers( $rows );

		$input['search']		=	'<input type="text" name="gj_categories_search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Categories...' ) ) . '" class="form-control" />';

		HTML_groupjiveCategories::showCategories( $rows, $pageNav, $searching, $input, $user, $this );
	}

	/**
	 * prepare frontend category render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showCategory( $id, $user )
	{
		global $_CB_framework, $_CB_database;

		$row					=	CBGroupJive::getCategory( $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$returnUrl				=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'all' ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! $isModerator ) {
				if ( ( ! $row->getInt( 'published', 0 ) ) || ( ! CBGroupJive::canAccess( $row->getInt( 'access', 0 ), $user->getInt( 'id', 0 ) ) ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to this category.' ), 'error' );
				}
			}
		} elseif ( ( ! $isModerator ) && ( ! $this->params->getInt( 'groups_uncategorized', 1 ) ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Category does not exist.' ), 'error' );
		}

		CBGroupJive::getTemplate( 'category' );

		$prefix					=	'gj_category_' . $row->getInt( 'id', 0 ) . '_';
		$limit					=	$this->params->getInt( 'categories_groups_limit', 30 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$where					=	null;

		if ( $search && $this->params->getInt( 'categories_groups_search', 1 ) ) {
			$where				.=	"\n AND ( g." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR g." . $_CB_database->NameQuote( 'description' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );

		$query					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' );

		if ( ( ! $isModerator ) && $user->getInt( 'id', 0 ) ) {
			$query				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
								.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
		}

		$query					.=	"\n WHERE g." . $_CB_database->NameQuote( 'category' ) . " = " . $row->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $isModerator ) {
			if ( $user->getInt( 'id', 0 ) ) {
				$query			.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
								.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
								.		' OR u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3'
								.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )';
			} else {
				$query			.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3";
			}
		}

		$query					.=	$where;
		$_CB_database->setQuery( $query );
		$total					=	(int) $_CB_database->loadResult();

		$pageNav				=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ), $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		switch( $this->params->getInt( 'categories_groups_orderby', 4 ) ) {
			case 1:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'ordering' ) . ' ASC';
				break;
			case 2:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'ordering' ) . ' DESC';
				break;
			case 3:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'date' ) . ' ASC';
				break;
			case 5:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'name' ) . ' ASC';
				break;
			case 6:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'name' ) . ' DESC';
				break;
			case 7:
				$orderBy		=	$_CB_database->NameQuote( '_users' ) . ' ASC';
				break;
			case 8:
				$orderBy		=	$_CB_database->NameQuote( '_users' ) . ' DESC';
				break;
			case 4:
			default:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'date' ) . ' DESC';
				break;
		}

		$users					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS uc"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS uccb"
								.	' ON uccb.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS ucj"
								.	' ON ucj.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE uc." . $_CB_database->NameQuote( 'group' ) . " = g." . $_CB_database->NameQuote( 'id' )
								.	"\n AND uccb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND uccb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND ucj." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $isModerator ) {
			if ( $user->getInt( 'id', 0 ) ) {
				$users			.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.		' OR u.' . $_CB_database->NameQuote( 'status' ) . ' >= 2'
								.		' OR uc.' . $_CB_database->NameQuote( 'status' ) . ' >= 1 )';
			} else {
				$users			.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " >= 1";
			}
		}

		if ( ! $this->params->getInt( 'groups_users_owner', 1 ) ) {
			$users				.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " != 4";
		}

		$query					=	'SELECT g.*'
								.	', ' . ( $user->getInt( 'id', 0 ) ? 'u.' . $_CB_database->NameQuote( 'status' ) : 'NULL' ) . ' AS _user_status'
								.	', ' . ( $user->getInt( 'id', 0 ) ? 'i.' . $_CB_database->NameQuote( 'id' ) : 'NULL' ) . ' AS _invite_id'
								.	', ( ' . $users . ' ) AS _users'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' );

		if ( $user->getInt( 'id', 0 ) ) {
			$query				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
								.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
		}

		$query					.=	"\n WHERE g." . $_CB_database->NameQuote( 'category' ) . " = " . $row->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $isModerator ) {
			if ( $user->getInt( 'id', 0 ) ) {
				$query			.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
								.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
								.		' OR u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3'
								.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )';
			} else {
				$query			.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3";
			}
		}

		$query					.=	$where
								.	"\n ORDER BY " . $orderBy;
		if ( $this->params->getInt( 'categories_groups_paging', 1 ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows					=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\GroupTable', array( $_CB_database ) );

		CBGroupJive::prefetchGroups( $rows );
		CBGroupJive::prefetchUsers( $rows );

		$input['search']		=	'<input type="text" name="' . $prefix . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Groups...' ) ) . '" class="form-control" />';

		HTML_groupjiveCategory::showCategory( $row, $rows, $pageNav, $searching, $input, $user, $this );
	}

	/**
	 * prepare frontend groups render
	 *
	 * @param int
	 * @param UserTable $user
	 */
	private function showGroups( $mode, $user )
	{
		global $_CB_framework, $_CB_database;

		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );

		switch ( $mode ) {
			case 'approval':
				if ( ! $isModerator ) {
					CBGroupJive::returnRedirect( 'index.php', CBTxt::T( 'Only moderators can approve groups.' ), 'error' );
				}

				$prefix			=	'gj_groups_approval_';
				break;
			case 'invited':
				if ( ! $user->getInt( 'id', 0 ) ) {
					cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'invited' ) ) ) ) ), CBTxt::T( 'Please Login or Register to view your group invites.' ) );
				}

				$prefix			=	'gj_groups_invited_';
				break;
			case 'joined':
				if ( ! $user->getInt( 'id', 0 ) ) {
					cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'joined' ) ) ) ) ), CBTxt::T( 'Please Login or Register to view your joined groups.' ) );
				}

				$prefix			=	'gj_groups_joined_';
				break;
			case 'owned':
				if ( ! $user->getInt( 'id', 0 ) ) {
					cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'owned' ) ) ) ) ), CBTxt::T( 'Please Login or Register to view your groups.' ) );
				}

				$prefix			=	'gj_groups_owned_';
				break;
			case 'my':
				if ( ! $user->getInt( 'id', 0 ) ) {
					cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'my' ) ) ) ) ), CBTxt::T( 'Please Login or Register to view your groups.' ) );
				}

				$prefix			=	'gj_groups_my_';
				break;
			case 'all':
			default:
				$mode			=	'all';
				$prefix			=	'gj_groups_all_';
				break;
		}

		CBGroupJive::getTemplate( 'groups' );

		$limit					=	$this->params->getInt( 'groups_limit', 30 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$where					=	null;

		if ( $search && $this->params->getInt( 'groups_search', 1 ) ) {
			$where				.=	"\n AND ( g." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR g." . $_CB_database->NameQuote( 'description' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );

		$categories				=	$this->getInput()->getString( 'categories' );
		$groups					=	$this->getInput()->getString( 'groups' );

		$sqlModes				=	( $mode === 'my' ? array( 'owned', 'joined', 'invited' ) : array( $mode ) );
		$queries				=	array();

		foreach ( $sqlModes as $sqlMode ) {
			if ( ( ! $user->getInt( 'id', 0 ) ) && in_array( $sqlMode, array( 'approval', 'invited', 'joined', 'owned' ), true ) ) {
				continue;
			}

			$query				=	'SELECT COUNT(*)' . ( count( $sqlModes ) > 1 ? ' AS total' : null )
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' );

			if ( ! $isModerator ) {
				$query			.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c"
								.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'category' );
			}

			if ( ( $sqlMode === 'joined' ) || ( ( ! $isModerator ) && ( $sqlMode === 'all' ) && $user->getInt( 'id', 0 ) ) ) {
				$query			.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
								.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3';
			}

			if ( ( $sqlMode === 'invited' ) || ( ( ! $isModerator ) && ( $sqlMode === 'all' ) && $user->getInt( 'id', 0 ) ) ) {
				$query			.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
			}

			$query				.=	"\n WHERE cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

			if ( $groups ) {
				$query			.=	"\n AND g." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $groups ) );
			}

			if ( $categories ) {
				$query			.=	"\n AND g." . $_CB_database->NameQuote( 'category' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $categories ) );
			}

			switch ( $sqlMode ) {
				case 'approval':
					$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = -1";
					break;
				case 'invited':
					$query		.=	"\n AND i." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'joined':
					$query		.=	"\n AND u." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'owned':
					$query		.=	"\n AND g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );

					if ( ! $isModerator ) {
						$query	.=	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'all':
				default:
					if ( ! $isModerator ) {
						if ( $user->getInt( 'id', 0 ) ) {
							$query	.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
									.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
									.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
									.		' OR u.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL'
									.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )'
									.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						} else {
							$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3"
									.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						}
					}
					break;
			}

			$query					.=	$where;

			$queries[]				=	$query;
		}

		if ( count( $queries ) > 1 ) {
			$query					=	"SELECT SUM( " . $_CB_database->NameQuote( 'total' ) . " ) FROM ( " . implode( " UNION ALL ", $queries ) . " ) AS g";
		} else {
			$query					=	$queries[0];
		}

		$_CB_database->setQuery( $query );
		$total						=	(int) $_CB_database->loadResult();

		$pageNav					=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => $mode, 'categories' => $this->getInput()->getString( 'categories' ), 'groups' => $this->getInput()->getString( 'groups' ), $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		switch( $this->params->getInt( 'groups_orderby', 4 ) ) {
			case 1:
				$orderBy			=	'g.' . $_CB_database->NameQuote( 'ordering' ) . ' ASC';
				break;
			case 2:
				$orderBy			=	'g.' . $_CB_database->NameQuote( 'ordering' ) . ' DESC';
				break;
			case 3:
				$orderBy			=	'g.' . $_CB_database->NameQuote( 'date' ) . ' ASC';
				break;
			case 5:
				$orderBy			=	'g.' . $_CB_database->NameQuote( 'name' ) . ' ASC';
				break;
			case 6:
				$orderBy			=	'g.' . $_CB_database->NameQuote( 'name' ) . ' DESC';
				break;
			case 7:
				$orderBy			=	$_CB_database->NameQuote( '_users' ) . ' ASC';
				break;
			case 8:
				$orderBy			=	$_CB_database->NameQuote( '_users' ) . ' DESC';
				break;
			case 4:
			default:
				$orderBy			=	'g.' . $_CB_database->NameQuote( 'date' ) . ' DESC';
				break;
		}

		$users						=	'SELECT COUNT(*)'
									.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS uc"
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS uccb"
									.	' ON uccb.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS ucj"
									.	' ON ucj.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
									.	"\n WHERE uc." . $_CB_database->NameQuote( 'group' ) . " = g." . $_CB_database->NameQuote( 'id' )
									.	"\n AND uccb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
									.	"\n AND uccb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
									.	"\n AND ucj." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $isModerator ) {
			if ( $user->getInt( 'id', 0 ) ) {
				$users				.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
									.		' OR u.' . $_CB_database->NameQuote( 'status' ) . ' >= 2'
									.		' OR uc.' . $_CB_database->NameQuote( 'status' ) . ' >= 1 )';
			} else {
				$users				.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " >= 1";
			}
		}

		if ( ! $this->params->getInt( 'groups_users_owner', 1 ) ) {
			$users					.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " != 4";
		}

		$queries					=	array();

		foreach ( $sqlModes as $sqlMode ) {
			if ( ( ! $user->getInt( 'id', 0 ) ) && in_array( $sqlMode, array( 'approval', 'invited', 'joined', 'owned' ), true ) ) {
				continue;
			}

			$query					=	'SELECT g.*'
									.	', c.' . $_CB_database->NameQuote( 'name' ) . ' AS _category_name'
									.	', ' . ( $user->getInt( 'id', 0 ) && ( ( ! $isModerator ) || in_array( $sqlMode, array( 'all', 'joined' ), true ) ) ? 'u.' . $_CB_database->NameQuote( 'status' ) : 'NULL' ) . ' AS _user_status'
									.	', ' . ( $user->getInt( 'id', 0 ) && in_array( $sqlMode, array( 'all', 'invited' ), true ) ? 'i.' . $_CB_database->NameQuote( 'id' ) : 'NULL' ) . ' AS _invite_id'
									.	', ( ' . $users . ' ) AS _users'
									.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
									.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
									.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'user_id' )
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c"
									.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'category' );

			if ( $user->getInt( 'id', 0 ) && ( ( ! $isModerator ) || in_array( $sqlMode, array( 'all', 'joined' ), true ) ) ) {
				$query				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
									.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
									.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
									.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3';
			}

			if ( $user->getInt( 'id', 0 ) && in_array( $sqlMode, array( 'all', 'invited' ), true ) ) {
				$query				.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
									.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
									.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
									.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
									.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
			}

			$query					.=	"\n WHERE cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
									.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
									.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

			if ( $groups ) {
				$query				.=	"\n AND g." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $groups ) );
			}

			if ( $categories ) {
				$query				.=	"\n AND g." . $_CB_database->NameQuote( 'category' ) . " IN " . $_CB_database->safeArrayOfIntegers( explode( ',', $categories ) );
			}

			switch ( $sqlMode ) {
				case 'approval':
					$query			.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = -1";
					break;
				case 'invited':
					$query			.=	"\n AND i." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'joined':
					$query			.=	"\n AND u." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'owned':
					$query			.=	"\n AND g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );

					if ( ! $isModerator ) {
						$query		.=	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'all':
				default:
					if ( ! $isModerator ) {
						if ( $user->getInt( 'id', 0 ) ) {
							$query	.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
									.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
									.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
									.		' OR u.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL'
									.		' OR i.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )'
									.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						} else {
							$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3"
									.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
									.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
									.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
						}
					}
					break;
			}

			$query					.=	$where;

			$queries[]				=	$query;
		}

		if ( count( $queries ) > 1 ) {
			$query					=	"SELECT * FROM ( " . implode( " UNION ALL ", $queries ) . " ) AS g";
		} else {
			$query					=	$queries[0];
		}

		$query						.=	"\n ORDER BY " . $orderBy;
		if ( $this->params->getInt( 'groups_paging', 1 ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows						=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\GroupTable', array( $_CB_database ) );

		CBGroupJive::prefetchGroups( $rows );
		CBGroupJive::prefetchUsers( $rows );

		$input['search']			=	'<input type="text" name="' . htmlspecialchars( $prefix ) . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Groups...' ) ) . '" class="form-control" />';

		HTML_groupjiveGroups::showGroups( $mode, $rows, $pageNav, $searching, $input, $user, $this );
	}

	/**
	 * prepare frontend group render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showGroup( $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJive::getGroup( $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'category', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $row, $user ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		}

		CBGroupJive::getTemplate( 'group' );

		$groupInvite		=	CBGroupJive::getGroupInvited( $user, $row );

		$row->set( '_invite_id', $groupInvite );

		$userStatus			=	CBGroupJive::getGroupStatus( $user, $row );

		$row->set( '_user_status', $userStatus );

		$users				=	$this->showGroupUsers( $row, $user );
		$invites			=	$this->showGroupInvites( $row, $user );

		HTML_groupjiveGroup::showGroup( $row, $users, $invites, $user, $this );
	}

	/**
	 * prepare frontend group message render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showGroupMessage( $id, $user )
	{
		global $_CB_framework;

		$row					=	CBGroupJive::getGroup( $id );
		$returnUrl				=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) );

		if ( $row->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to messaging in this group.' ), 'error' );
		} elseif ( CBGroupJive::canAccessGroup( $row, $user ) ) {
			if ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ! $this->params->getInt( 'groups_message', 0 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to messaging in this group.' ), 'error' );
				} elseif ( ( $row->getInt( 'published', 0 ) === -1 ) || ( CBGroupJive::getGroupStatus( $user, $row ) < 3 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to messaging in this group.' ), 'error' );
				} elseif ( $row->params()->getString( 'messaged' ) ) {
					$seconds	=	$this->params->getInt( 'groups_message_delay', 60 );

					if ( $seconds && ( Application::Date( $row->params()->getString( 'messaged' ), 'UTC' )->add( $seconds . ' SECONDS' )->getTimestamp() >= Application::Date( 'now', 'UTC' )->getTimestamp() ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You can not send a message to this group at this time. Please wait awhile and try again.' ), 'error' );
					}
				}
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		}

		CBGroupJive::getTemplate( 'message' );

		$input					=	array();

		$subjectTooltip			=	cbTooltip( null, CBTxt::T( 'Optionally input a message subject.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['subject']		=	'<input type="text" id="subject" name="subject" value="' . htmlspecialchars( $this->getInput()->getString( 'post/subject' ) ) . '" class="form-control input-block"' . $subjectTooltip . ' />';

		$messageTooltip			=	cbTooltip( null, CBTxt::T( 'Input a message to send to this groups users.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		if ( $this->params->getBool( 'groups_message_html', false ) ) {
			$input['message']	=	Application::Cms()->displayCmsEditor( 'message', $this->getInput()->getHtml( 'post/message' ), null, 200, null, 10 );
		} else {
			$input['message']	=	'<textarea id="message" name="message" class="form-control input-block required" rows="10"' . $messageTooltip . '>' . htmlspecialchars( $this->getInput()->getString( 'post/message' ) ) . '</textarea>';
		}

		HTML_groupjiveMessage::showMessage( $row, $input, $user, $this );
	}

	/**
	 * prepare frontend group users render
	 *
	 * @param GroupTable $group
	 * @param UserTable  $user
	 * @return mixed
	 */
	private function showGroupUsers( &$group, $user )
	{
		global $_CB_framework, $_CB_database;

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			return null;
		}

		if ( ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
			 && ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) )
			 && ( ! $group->params()->getInt( 'users', 1 ) )
		) {
			return null;
		}

		CBGroupJive::getTemplate( 'users' );

		$canModerate			=	( CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) || ( CBGroupJive::getGroupStatus( $user, $group ) >= 2 ) );
		$prefix					=	'gj_group_' . $group->getInt( 'id', 0 ) . '_users_';
		$limit					=	$this->params->getInt( 'groups_users_limit', 15 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$where					=	null;

		if ( $search && $this->params->getInt( 'groups_users_search', 0 ) ) {
			$where				.=	"\n AND ( j." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR j." . $_CB_database->NameQuote( 'username' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );

		$query					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE u." . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $canModerate ) {
			$query				.=	"\n AND u." . $_CB_database->NameQuote( 'status' ) . " >= 1";
		}

		if ( ! $this->params->getInt( 'groups_users_owner', 1 ) ) {
			$query				.=	"\n AND u." . $_CB_database->NameQuote( 'status' ) . " != 4";
		}

		$query					.=	$where;
		$_CB_database->setQuery( $query );
		$total					=	(int) $_CB_database->loadResult();

		if ( ( ! $total ) && ( ! $searching ) ) {
			return null;
		}

		$pageNav				=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ), $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		$query					=	'SELECT u.*'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE u." . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $canModerate ) {
			$query				.=	"\n AND u." . $_CB_database->NameQuote( 'status' ) . " >= 1";
		}

		if ( ! $this->params->getInt( 'groups_users_owner', 1 ) ) {
			$query				.=	"\n AND u." . $_CB_database->NameQuote( 'status' ) . " != 4";
		}

		$query					.=	$where
								.	"\n ORDER BY IF( u." . $_CB_database->NameQuote( 'status' ) . " = 0, 999, u." . $_CB_database->NameQuote( 'status' ) . " ) DESC, u." . $_CB_database->NameQuote( 'date' ) . " DESC";
		if ( $this->params->getInt( 'groups_users_paging', 1 ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows					=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\UserTable', array( $_CB_database ) );

		CBGroupJive::prefetchGroupUsers( $rows );
		CBGroupJive::prefetchUsers( $rows );

		$input['search']		=	'<input type="text" name="' . htmlspecialchars( $prefix ) . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Users...' ) ) . '" class="form-control" />';

		$group->set( '_users', $pageNav->total );

		return HTML_groupjiveUsers::showUsers( $rows, $pageNav, $searching, $input, $group, $user, $this );
	}

	/**
	 * prepare frontend group invites render
	 *
	 * @param GroupTable $group
	 * @param UserTable  $user
	 * @return mixed
	 */
	private function showGroupInvites( &$group, $user )
	{
		global $_CB_framework, $_CB_database;

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			return null;
		}

		if ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
			if ( ( ! $this->params->getInt( 'groups_invites_display', 1 ) ) && ( $group->getInt( 'type', 0 ) !== 3 ) ) {
				return null;
			}

			if ( ( CBGroupJive::getGroupStatus( $user, $group ) < 1 ) ) {
				return null;
			}
		}

		CBGroupJive::getTemplate( 'invites' );

		$prefix					=	'gj_group_' . $group->getInt( 'id', 0 ) . '_invites_';
		$limit					=	$this->params->getInt( 'groups_invites_limit', 15 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$where					=	null;

		if ( $search && $this->params->getInt( 'groups_invites_search', 0 ) ) {
			$where				.=	"\n AND ( i." . $_CB_database->NameQuote( 'email' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR j." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR j." . $_CB_database->NameQuote( 'username' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );

		$query					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = i.' . $_CB_database->NameQuote( 'user' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = i.' . $_CB_database->NameQuote( 'user' )
								.	"\n WHERE i." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.	"\n AND i." . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
								.	"\n AND ( ( cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	' AND cb.' . $_CB_database->NameQuote( 'confirmed' ) . ' = 1'
								.	' AND j.' . $_CB_database->NameQuote( 'block' ) . ' = 0 )'
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = 0 )'
								.	$where;
		$_CB_database->setQuery( $query );
		$total					=	(int) $_CB_database->loadResult();

		if ( ( ! $total ) && ( ! $searching ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'invites' ) ) ) {
			return null;
		}

		$pageNav				=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ), $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		switch( $this->params->getInt( 'groups_invites_orderby', 1 ) ) {
			case 1:
				$orderBy		=	'i.' . $_CB_database->NameQuote( 'invited' ) . ' ASC';
				break;
			case 3:
				$orderBy		=	'i.' . $_CB_database->NameQuote( 'accepted' ) . ' ASC';
				break;
			case 4:
				$orderBy		=	'i.' . $_CB_database->NameQuote( 'accepted' ) . ' DESC';
				break;
			case 2:
			default:
				$orderBy		=	'i.' . $_CB_database->NameQuote( 'invited' ) . ' DESC';
				break;
		}

		$query					=	'SELECT i.*'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = i.' . $_CB_database->NameQuote( 'user' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = i.' . $_CB_database->NameQuote( 'user' )
								.	"\n WHERE i." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.	"\n AND i." . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
								.	"\n AND ( ( cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	' AND cb.' . $_CB_database->NameQuote( 'confirmed' ) . ' = 1'
								.	' AND j.' . $_CB_database->NameQuote( 'block' ) . ' = 0 )'
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = 0 )'
								.	$where
								.	"\n ORDER BY " . $orderBy;
		if ( $this->params->getInt( 'groups_invites_paging', 1 ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows					=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\InviteTable', array( $_CB_database ) );

		CBGroupJive::prefetchInvites( $rows );
		CBGroupJive::prefetchUsers( $rows );

		$input['search']		=	'<input type="text" name="' . htmlspecialchars( $prefix ) . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Invites...' ) ) . '" class="form-control" />';

		$group->set( '_invites', $pageNav->total );

		return HTML_groupjiveInvites::showInvites( $rows, $pageNav, $searching, $input, $group, $user, $this );
	}

	/**
	 * prepare frontend notifications render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showGroupNotifications( $id, $user )
	{
		global $_CB_framework;

		$group							=	CBGroupJive::getGroup( $id );
		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$returnUrl						=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ( ! $this->params->getInt( 'notifications', 1 ) ) || ( $group->getInt( 'type', 0 ) === 4 ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to notifications in this group.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ! CBGroupJive::canCreateGroupContent( $user, $group ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to notifications in this group.' ), 'error' );
			}
		}

		$row							=	new NotificationTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'group' => $group->getInt( 'id', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this users notifications.' ), 'error' );
		}

		CBGroupJive::getTemplate( 'notifications' );

		$input							=	array();

		$listEnable						=	array();
		$listEnable[]					=	moscomprofilerHTML::makeOption( 1, '<span class="fa fa-check"></span>', 'value', 'text', null, 'btn-success btn-sm gjToggleNotificationYes' );
		$listEnable[]					=	moscomprofilerHTML::makeOption( 0, '<span class="fa fa-times"></span>', 'value', 'text', null, 'btn-danger btn-sm gjToggleNotificationNo' );

		$input['user_join']				=	moscomprofilerHTML::radioListButtons( $listEnable, 'params[user_join]', null, 'value', 'text', $this->getInput()->getInt( 'post/params.user_join', $row->params()->getInt( 'user_join', $this->params->getInt( 'notifications_default_user_join', 0 ) ) ), 1, null, null, false );
		$input['user_leave']			=	moscomprofilerHTML::radioListButtons( $listEnable, 'params[user_leave]', null, 'value', 'text', $this->getInput()->getInt( 'post/params.user_leave', $row->params()->getInt( 'user_leave', $this->params->getInt( 'notifications_default_user_leave', 0 ) ) ), 1, null, null, false );
		$input['user_approve']			=	moscomprofilerHTML::radioListButtons( $listEnable, 'params[user_approve]', null, 'value', 'text', $this->getInput()->getInt( 'post/params.user_approve', $row->params()->getInt( 'user_approve', $this->params->getInt( 'notifications_default_user_approve', 0 ) ) ), 1, null, null, false );
		$input['user_cancel']			=	moscomprofilerHTML::radioListButtons( $listEnable, 'params[user_cancel]', null, 'value', 'text', $this->getInput()->getInt( 'post/params.user_cancel', $row->params()->getInt( 'user_cancel', $this->params->getInt( 'notifications_default_user_cancel', 0 ) ) ), 1, null, null, false );
		$input['invite_accept']			=	moscomprofilerHTML::radioListButtons( $listEnable, 'params[invite_accept]', null, 'value', 'text', $this->getInput()->getInt( 'post/params.invite_accept', $row->params()->getInt( 'invite_accept', $this->params->getInt( 'notifications_default_invite_accept', 0 ) ) ), 1, null, null, false );
		$input['invite_reject']			=	moscomprofilerHTML::radioListButtons( $listEnable, 'params[invite_reject]', null, 'value', 'text', $this->getInput()->getInt( 'post/params.invite_reject', $row->params()->getInt( 'invite_reject', $this->params->getInt( 'notifications_default_invite_reject', 0 ) ) ), 1, null, null, false );

		HTML_groupjiveNotifications::showNotifications( $row, $input, $group, $user, $this );
	}

	/**
	 * reject all group invites
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function rejectGroupInvites( $id, $user )
	{
		global $_CB_framework, $_CB_database;

		$group				=	CBGroupJive::getGroup( $id );

		if ( ! $user->getInt( 'id', 0 ) ) {
			$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'reject', 'id' => $group->getInt( 'id', 0 ) ) );

			cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $returnUrl ) ) ), CBTxt::T( 'Please Login or Register to reject invites.' ) );
		} else {
			$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

			if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			}
		}

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
		}

		$query				=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_invites' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
							.	"\n AND " . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
							.	"\n AND ( " . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
							.	' OR ' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
		$_CB_database->setQuery( $query );
		$rows				=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\InviteTable', array( $_CB_database ) );

		if ( ! $rows ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You have no invites to this group to reject.' ), 'error' );
		}

		CBGroupJive::prefetchInvites( $rows );
		CBGroupJive::prefetchUsers( $rows );

		/** @var InviteTable[] $rows */
		foreach ( $rows as $row ) {
			if ( ! $row->canDelete() ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_INVITE_FAILED_TO_REJECT', 'Group invites failed to reject. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
			}

			if ( ! $row->delete() ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_INVITE_FAILED_TO_REJECT', 'Group invites failed to reject. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
			}

			CBGroupJive::sendNotifications( 'invite_reject', CBTxt::T( 'Group invite rejected' ), CBTxt::T( 'Your group [group] invite to [user] has been rejected!' ), $group, $user, $row->getInt( 'user_id', 0 ) );
		}

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group invites rejected successfully!' ) );
	}

	/**
	 * cancel group join request
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function cancelGroupJoin( $id, $user )
	{
		global $_CB_framework;

		$group				=	CBGroupJive::getGroup( $id );

		if ( ! $user->getInt( 'id', 0 ) ) {
			$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'cancel', 'id' => $group->getInt( 'id', 0 ) ) );

			cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $returnUrl ) ) ), CBTxt::T( 'Please Login or Register to cancel join requests.' ) );
		} else {
			$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

			if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			}
		}

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to join this group.' ), 'error' );
		}

		$row				=	new \CB\Plugin\GroupJive\Table\UserTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'group' => $group->getInt( 'id', 0 ), 'status' => 0 ) );

		if ( ! $row->getInt( 'id', 0 ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You have no pending join request to this group to cancel.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_JOIN_FAILED_TO_CANCEL', 'Group join request failed to cancel. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_JOIN_FAILED_TO_CANCEL', 'Group join request failed to cancel. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		CBGroupJive::sendNotifications( 'user_cancel', CBTxt::T( 'User group join request cancelled' ), CBTxt::T( '[user] has cancelled their join request to the group [group]!' ), $group, $row->getInt( 'user_id', 0 ), null, null, 2 );

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group join request cancelled successfully!' ) );
	}

	/**
	 * join group safely
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function joinGroup( $id, $user )
	{
		global $_CB_framework, $_CB_database, $_PLUGINS;

		$group					=	CBGroupJive::getGroup( $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );

		if ( ! $user->getInt( 'id', 0 ) ) {
			$returnUrl			=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'join', 'id' => $group->getInt( 'id', 0 ) ) );

			cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $returnUrl ) ) ), CBTxt::T( 'Please Login or Register to join groups.' ) );
		} else {
			$returnUrl			=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

			if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			}
		}

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to join this group.' ), 'error' );
		}

		$row					=	new \CB\Plugin\GroupJive\Table\UserTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'group' => $group->getInt( 'id', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			switch ( $row->getInt( 'status', 0 ) ) {
				case -1:
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You have been banned from this group.' ), 'error' );
					break;
				case 0:
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Your group join request is currently pending approval.' ) );
					break;
				default:
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You have already joined this group.' ), 'error' );
					break;
			}
		}

		$query					=	'SELECT *'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_invites' )
								.	"\n WHERE " . $_CB_database->NameQuote( 'group' ) . " = " . $group->getInt( 'id', 0 )
								.	"\n AND " . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	"\n AND ( " . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR ' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )';
		$_CB_database->setQuery( $query );
		$invites				=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\InviteTable', array( $_CB_database ) );

		CBGroupJive::prefetchInvites( $invites );
		CBGroupJive::prefetchUsers( $invites );

		if ( ( ! $invites ) && ( ( $row->getInt( 'type', 0 ) === 3 ) || ( $row->getInt( 'type', 0 ) === 5 ) ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You have not been invited to join this group.' ), 'error' );
		}

		$modInvite				=	false;

		if ( $group->getInt( 'type', 0 ) === 2 ) {
			// Group requires approval, but if a group owner, admin, or mod invited them then just auto approve:
			foreach ( $invites as $invite ) {
				$inviteUser		=	CBuser::getUserDataInstance( $invite->getInt( 'user_id', 0 ) );

				if ( ( CBGroupJive::getGroupStatus( $inviteUser, $group ) < 2 ) ) {
					continue;
				}

				$modInvite		=	true;
				break;
			}
		}

		$row->set( 'user_id', $user->getInt( 'id', 0 ) );
		$row->set( 'group', $group->getInt( 'id', 0 ) );
		$row->set( 'status', ( $isModerator ? 1 : ( $group->getInt( 'type', 0 ) === 2 ? ( $modInvite ? 1 : 0 ) : 1 ) ) );

		$_PLUGINS->trigger( 'gj_onBeforeJoinGroup', array( &$row, $group, $user ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_JOIN_FAILED', 'Group join failed. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_JOIN_FAILED', 'Group join failed. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		$notified				=	array( $row->getInt( 'user_id', 0 ) );

		/** @var InviteTable[] $invites */
		foreach ( $invites as $invite ) {
			if ( $invite->accept() && ( ! in_array( $invite->getInt( 'user_id', 0 ), $notified, true ) ) ) {
				CBGroupJive::sendNotifications( 'invite_accept', CBTxt::T( 'Group invite accepted' ), CBTxt::T( 'Your group [group] invite to [user] has been accepted!' ), $group, $user, $invite->getInt( 'user_id', 0 ), $notified );

				$notified[]		=	$invite->getInt( 'user_id', 0 );
			}
		}

		if ( $row->getInt( 'status', 0 ) === 0 ) {
			CBGroupJive::sendNotifications( 'user_approve', CBTxt::T( 'User group join request awaiting approval' ), CBTxt::T( '[user] has joined the group [group] and is awaiting approval!' ), $group, $row->getInt( 'user_id', 0 ), null, array( $row->getInt( 'user_id', 0 ) ), 2 );
		} else {
			CBGroupJive::sendNotifications( 'user_join', CBTxt::T( 'User joined a mutual group' ), CBTxt::T( '[user] has joined the group [group]!' ), $group, $row->getInt( 'user_id', 0 ), null, $notified );
		}

		$_PLUGINS->trigger( 'gj_onAfterJoinGroup', array( $row, $group, $user ) );

		if ( $row->getInt( 'status', 0 ) === 0 ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Your group join request is currently pending approval!' ) );
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group joined successfully!' ) );
		}
	}

	/**
	 * leave group safely
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function leaveGroup( $id, $user )
	{
		global $_CB_framework, $_PLUGINS;

		$group						=	CBGroupJive::getGroup( $id );

		if ( ! $user->getInt( 'id', 0 ) ) {
			$returnUrl				=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'leave', 'id' => $group->getInt( 'id', 0 ) ) );

			cbRedirect( $_CB_framework->viewUrl( 'login', false, array( 'return' => base64_encode( $returnUrl ) ) ), CBTxt::T( 'Please Login or Register to leave groups.' ) );
		} else {
			$returnUrl				=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

			if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			}
		}

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to leave this group.' ), 'error' );
		}

		$row						=	new \CB\Plugin\GroupJive\Table\UserTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'group' => $group->getInt( 'id', 0 ) ) );

		if ( ! $row->getInt( 'id', 0 ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You can not leave a group you have not joined.' ), 'error' );
		} elseif ( $row->getInt( 'status', 0 ) === 4 ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You are the owner of this group and can not leave your own group.' ), 'error' );
		}

		$_PLUGINS->trigger( 'gj_onBeforeLeaveGroup', array( &$row, $group, $user ) );

		if ( ! $row->canDelete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_LEAVE_FAILED', 'Group leave failed. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_LEAVE_FAILED', 'Group leave failed. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		CBGroupJive::sendNotifications( 'user_leave', CBTxt::T( 'User left a mutual group' ), CBTxt::T( '[user] has left the group [group]!' ), $group, $row->getInt( 'user_id', 0 ) );

		$_PLUGINS->trigger( 'gj_onAfterLeaveGroup', array( $row, $group, $user ) );

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Left group successfully!' ) );
	}

	/**
	 * set group publish state status
	 *
	 * @param int       $state
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function stateGroup( $state, $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJive::getGroup( $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) );

		if ( CBGroupJive::canAccessGroup( $row, $user ) ) {
			if ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $row->getInt( 'published', 0 ) === -1 )
					 && $this->params->getInt( 'groups_create_approval', 0 )
					 && ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) )
				) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Your group is awaiting approval.' ), 'error' );
				} elseif ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish or unpublish this group.' ), 'error' );
				}
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		}

		$currentState		=	$row->getInt( 'published', 0 );

		$row->set( 'published', (int) $state );

		if ( $row->getError() || ( ! $row->store() ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_STATE_FAILED_TO_SAVE', 'Group state failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $state
			 && ( $currentState === -1 )
			 && ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) )
		) {
			CBGroupJive::sendNotification( 'group_approved', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Group create request accepted' ), CBTxt::T( 'Your group [group] create request has been accepted!' ), $row );
		}

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group state saved successfully!' ) );
	}

	/**
	 * delete group
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteGroup( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJive::getGroup( $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'show', 'id' => $row->getInt( 'category', 0 ) ) );

		if ( CBGroupJive::canAccessGroup( $row, $user ) ) {
			if ( ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this group.' ), 'error' );
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_FAILED_TO_DELETE', 'Group failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_FAILED_TO_DELETE', 'Group failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group deleted successfully!' ) );
	}

	/**
	 * prepare frontend group edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showGroupEdit( $id, $user )
	{
		global $_CB_framework;

		$row								=	CBGroupJive::getGroup( $id );
		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$categoryId							=	null;

		if ( $row->getInt( 'id', 0 ) ) {
			$categoryId						=	$this->getInput()->getInt( 'post/category' );

			if ( $categoryId !== null ) {
				$category					=	CBGroupJive::getCategory( $categoryId );
			} else {
				$category					=	$row->category();
			}

			$returnUrl						=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) );
		} else {
			$categoryId						=	$this->getInput()->getInt( 'post/category', $this->getInput()->getInt( 'get/category' ) );
			$category						=	CBGroupJive::getCategory( $categoryId );

			if ( $categoryId === null ) {
				$returnUrl					=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'all' ) );
			} elseif ( ( ! $categoryId ) && ( ! $this->params->getInt( 'groups_uncategorized', 1 ) ) ) {
				$returnUrl					=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'all' ) );
			} else {
				$returnUrl					=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'show', 'id' => $category->getInt( 'id', 0 ) ) );
			}
		}

		if ( ! $isModerator ) {
			if ( $categoryId
				 && ( ! $category->getInt( 'id', 0 ) )
				 && ( ! $this->params->getInt( 'groups_uncategorized', 1 ) )
			) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Category does not exist.' ), 'error' );
			} elseif ( $category->getInt( 'id', 0 ) && ( ( ! $category->getInt( 'published', 0 ) ) || ( ! CBGroupJive::canAccess( $category->getInt( 'access', 0 ), $user->getInt( 'id', 0 ) ) ) ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to this category.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 ) ) {
				if ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this group.' ), 'error' );
				}
			} elseif ( ! CBGroupJive::canCreateGroup( $user, ( $category->getInt( 'id', 0 ) ? $category : null ) ) ) {
				if ( $category->getInt( 'id', 0 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create a group in this category.' ), 'error' );
				} else {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create a group.' ), 'error' );
				}
			}
		}

		CBGroupJive::getTemplate( 'group_edit' );

		$input								=	array();

		$input['group_hidden']				=	'<input type="hidden" name="group" value="' . $row->getInt( 'id', 0 ) . '" />';

		$publishedTooltip					=	cbTooltip( null, CBTxt::T( 'Select publish state of this group. Unpublished groups will not be visible to the public.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['published']					=	moscomprofilerHTML::yesnoButtonList( 'published', $publishedTooltip, $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) );

		$categories							=	CBGroupJive::getCategoryOptions( $user );

		if ( $row->getInt( 'id', 0 ) && $category->getInt( 'id', 0 ) ) {
			$available						=	array();

			foreach ( $categories as $option ) {
				$available[]				=	(int) $option->value;
			}

			if ( ! in_array( $category->getInt( 'id', 0 ), $available, true ) ) {
				array_unshift( $categories, moscomprofilerHTML::makeOption( $category->getInt( 'id', 0 ), CBTxt::T( $category->getString( 'name' ) ) ) );
			}
		}

		if ( $categories ) {
			if ( $isModerator || $this->params->getInt( 'groups_uncategorized', 1 ) ) {
				array_unshift( $categories, moscomprofilerHTML::makeOption( 0, CBTxt::T( 'Uncategorized' ) ) );
			}

			if ( count( $categories ) > 15 ) {
				$js							=	"$( '.gjGroupCategory' ).cbselect({"
											.		"language: {"
											.			"errorLoading: function() {"
											.				"return " . json_encode( CBTxt::T( 'The results could not be loaded.' ), JSON_HEX_TAG ) . ";"
											.			"},"
											.			"inputTooLong: function() {"
											.				"return " . json_encode( CBTxt::T( 'Search input too long.' ), JSON_HEX_TAG ) . ";"
											.			"},"
											.			"inputTooShort: function() {"
											.				"return " . json_encode( CBTxt::T( 'Search input too short.' ), JSON_HEX_TAG ) . ";"
											.			"},"
											.			"loadingMore: function() {"
											.				"return " . json_encode( CBTxt::T( 'Loading more results...' ), JSON_HEX_TAG ) . ";"
											.			"},"
											.			"maximumSelected: function() {"
											.				"return " . json_encode( CBTxt::T( 'You cannot select any more choices.' ), JSON_HEX_TAG ) . ";"
											.			"},"
											.			"noResults: function() {"
											.				"return " . json_encode( CBTxt::T( 'No results found.' ), JSON_HEX_TAG ) . ";"
											.			"},"
											.			"searching: function() {"
											.				"return " . json_encode( CBTxt::T( 'Searching...' ), JSON_HEX_TAG ) . ";"
											.			"}"
											.		"}"
											.	"});";

				$_CB_framework->outputCbJQuery( $js, 'cbselect' );
			}

			$categoryTooltip				=	cbTooltip( null, CBTxt::T( 'Select the group category. This is the category a group will belong to and decide its navigation path.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

			$input['category']				=	moscomprofilerHTML::selectList( $categories, 'category', 'class="form-control gjGroupCategory"' . $categoryTooltip, 'value', 'text', $category->getInt( 'id', 0 ), 1, false, false );
		} else {
			$input['category']				=	null;

			if ( ! $this->params->getInt( 'groups_uncategorized', 1 ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create a group in any categories.' ), 'error' );
			}
		}

		$types								=	cbToArrayOfInt( explode( '|*|', $category->getString( 'types', '1|*|2|*|3|*|4|*|5' ) ) );
		$listType							=	array();
		$listTypeDesc						=	array();

		if ( $isModerator || ( ! $types ) || in_array( 1, $types, true ) || ( ! $category->getInt( 'id', 0 ) ) ) {
			$listType[]						=	moscomprofilerHTML::makeOption( '1', CBTxt::T( 'GROUP_TYPE_OPEN', 'Open' ) );
			$listTypeDesc[]					=	CBTxt::T( 'GROUP_TYPE_DESC_OPEN', '<strong>Open</strong>: All users can see this group, its content, and join it.' );
		}

		if ( $isModerator || ( ! $types ) || in_array( 5, $types, true ) || ( ! $category->getInt( 'id', 0 ) ) ) {
			$listType[]						=	moscomprofilerHTML::makeOption( '5', CBTxt::T( 'GROUP_TYPE_INVITE', 'Invite' ) );
			$listTypeDesc[]					=	CBTxt::T( 'GROUP_TYPE_DESC_INVITE', '<strong>Invite</strong>: All users can see this group and its content, but must be invited to join it.' );
		}

		if ( $isModerator || ( ! $types ) || in_array( 2, $types, true ) || ( ! $category->getInt( 'id', 0 ) ) ) {
			$listType[]						=	moscomprofilerHTML::makeOption( '2', CBTxt::T( 'GROUP_TYPE_APPROVAL', 'Approval' ) );
			$listTypeDesc[]					=	CBTxt::T( 'GROUP_TYPE_DESC_APPROVAL', '<strong>Approval</strong>: All users can see this group and its content, but require approval to join it.' );
		}

		if ( $isModerator || ( ! $types ) || in_array( 3, $types, true ) || ( ! $category->getInt( 'id', 0 ) ) ) {
			$listType[]						=	moscomprofilerHTML::makeOption( '3', CBTxt::T( 'GROUP_TYPE_PRIVATE', 'Private' ) );
			$listTypeDesc[]					=	CBTxt::T( 'GROUP_TYPE_DESC_PRIVATE', '<strong>Private</strong>: This group is only visible to users if they have already joined it or have been invited to join it.' );
		}

		if ( $isModerator || ( ! $types ) || in_array( 4, $types, true ) || ( ! $category->getInt( 'id', 0 ) ) ) {
			$listType[]						=	moscomprofilerHTML::makeOption( '4', CBTxt::T( 'GROUP_TYPE_PAGE', 'Page' ) );
			$listTypeDesc[]					=	CBTxt::T( 'GROUP_TYPE_DESC_PAGE', '<strong>Page</strong>: All users can see this group and its content, but no users can join it.' );
		}

		$input['type']						=	null;
		$input['type_hidden']				=	null;
		$input['type_desc']					=	implode( '<br />', $listTypeDesc );

		if ( count( $listType ) > 1 ) {
			$typeTooltip					=	cbTooltip( null, $input['type_desc'], null, null, null, null, null, 'data-hascbtooltip="true"' );

			$input['type']					=	moscomprofilerHTML::radioListButtons( $listType, 'type', $typeTooltip, 'value', 'text', $this->getInput()->getInt( 'post/type', $row->getInt( 'type', 1 ) ), 1, null, null, false );
		} else {
			$input['type_hidden']			=	'<input type="hidden" name="type" value="' . (int) $listType[0]->value . '" />';
		}

		$nameTooltup						=	cbTooltip( null, CBTxt::T( 'Input the group name. This is the name that will distinguish this group from others. Suggested to input something unique and intuitive.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['name']						=	'<input type="text" id="name" name="name" value="' . htmlspecialchars( $this->getInput()->getString( 'post/name', $row->getString( 'name' ) ) ) . '" class="form-control" size="25"' . $nameTooltup . ' />';

		$descriptionTooltip					=	cbTooltip( null, CBTxt::T( 'Optionally input the group description. The group description should be short and to the point; describing what your group is all about.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['description']				=	'<textarea id="description" name="description" class="form-control" cols="40" rows="5"' . $descriptionTooltip . '>' . htmlspecialchars( $this->getInput()->getString( 'post/description', $row->getString( 'description' ) ) ) . '</textarea>';

		$listMethods						=	array();
		$listMethods[]						=	moscomprofilerHTML::makeOption( 0, CBTxt::T( 'No Change' ) );
		$listMethods[]						=	moscomprofilerHTML::makeOption( 1, CBTxt::T( 'Upload' ) );
		$listMethods[]						=	moscomprofilerHTML::makeOption( 2, CBTxt::T( 'Delete' ) );

		$input['canvas_method']				=	moscomprofilerHTML::selectList( $listMethods, 'canvas_method', 'class="form-control"', 'value', 'text', $this->getInput()->getInt( 'post/canvas_method', 0 ), 1, false, false );

		$canvasMinFileSize					=	$this->params->getInt( 'canvas_min_size', 0 );
		$canvasMaxFileSize					=	$this->params->getInt( 'canvas_max_size', 1024 );

		$canvasValidation					=	array();

		if ( $canvasMinFileSize || $canvasMaxFileSize ) {
			$canvasValidation[]				=	cbValidator::getRuleHtmlAttributes( 'filesize', array( $canvasMinFileSize, $canvasMaxFileSize, 'KB' ) );
		}

		$canvasValidation[]					=	cbValidator::getRuleHtmlAttributes( 'extension', 'jpg,jpeg,gif,png' );

		$canvasTooltip						=	cbTooltip( null, CBTxt::T( 'Optionally select the group canvas. A canvas should represent the topic of your group; please be respectful and tasteful when selecting a canvas.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['canvas']					=	'<input type="file" id="canvas" name="canvas" value="" class="form-control"' . $canvasTooltip . implode( ' ', $canvasValidation ) . ' />';

		$input['canvas_limits']				=	array( CBTxt::T( 'CANVAS_UPLOAD_LIMITS_EXT', 'Your file must be of [ext] type.', array( '[ext]' => 'jpg, jpeg, gif, png' ) ) );

		if ( $canvasMinFileSize ) {
			$input['canvas_limits'][]		=	CBTxt::T( 'CANVAS_UPLOAD_LIMITS_MIN', 'Your file should exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $canvasMinFileSize * 1024 ) ) );
		}

		if ( $canvasMaxFileSize ) {
			$input['canvas_limits'][]		=	CBTxt::T( 'CANVAS_UPLOAD_LIMITS_MAX', 'Your file should not exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $canvasMaxFileSize * 1024 ) ) );
		}

		$input['logo_method']				=	moscomprofilerHTML::selectList( $listMethods, 'logo_method', 'class="form-control"', 'value', 'text', $this->getInput()->getInt( 'post/logo_method', 0 ), 1, false, false );

		$logoMinFileSize					=	$this->params->getInt( 'logo_min_size', 0 );
		$logoMaxFileSize					=	$this->params->getInt( 'logo_max_size', 1024 );

		$logoValidation						=	array();

		if ( $logoMinFileSize || $logoMaxFileSize ) {
			$logoValidation[]				=	cbValidator::getRuleHtmlAttributes( 'filesize', array( $logoMinFileSize, $logoMaxFileSize, 'KB' ) );
		}

		$logoValidation[]					=	cbValidator::getRuleHtmlAttributes( 'extension', 'jpg,jpeg,gif,png' );

		$logoTooltip						=	cbTooltip( null, CBTxt::T( 'Optionally select the group logo. A logo should represent the topic of your group; please be respectful and tasteful when selecting a logo.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['logo']						=	'<input type="file" id="logo" name="logo" value="" class="form-control"' . $logoTooltip . implode( ' ', $logoValidation ) . ' />';

		$input['logo_limits']				=	array( CBTxt::T( 'LOGO_UPLOAD_LIMITS_EXT', 'Your file must be of [ext] type.', array( '[ext]' => 'jpg, jpeg, gif, png' ) ) );

		if ( $logoMinFileSize ) {
			$input['logo_limits'][]			=	CBTxt::T( 'LOGO_UPLOAD_LIMITS_MIN', 'Your file should exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $logoMinFileSize * 1024 ) ) );
		}

		if ( $logoMaxFileSize ) {
			$input['logo_limits'][]			=	CBTxt::T( 'LOGO_UPLOAD_LIMITS_MAX', 'Your file should not exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $logoMaxFileSize * 1024 ) ) );
		}

		$usersTooltip						=	cbTooltip( null, CBTxt::T( 'Optionally enable or disable display of group users. Group owner and group administrators are exempt from this configuration and can always view group users.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['users']						=	moscomprofilerHTML::yesnoButtonList( 'params[users]', $usersTooltip, $this->getInput()->getInt( 'post/params.users', $row->params()->getInt( 'users', 1 ) ), CBTxt::T( 'Enable' ), CBTxt::T( 'Disable' ), null, false );

		$invitesTooltip						=	cbTooltip( null, CBTxt::T( 'Optionally enable or disable usage of invites. Invites allow group users to invite other users to join the group. Group owner and group administrators are exempt from this configuration and can always invite users. Note existing invites will still be accessible.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['invites']					=	moscomprofilerHTML::yesnoButtonList( 'params[invites]', $invitesTooltip, $this->getInput()->getInt( 'post/params.invites', $row->params()->getInt( 'invites', 1 ) ), CBTxt::T( 'Enable' ), CBTxt::T( 'Disable' ), null, false );

		$ownerTooltip						=	cbTooltip( null, CBTxt::T( 'Input the group owner id. Group owner determines the creator of the group specified as User ID.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['user_id']					=	'<input type="text" id="user_id" name="user_id" value="' . $this->getInput()->getInt( 'post/user_id', $this->getInput()->getInt( 'user', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) ) . '" class="digits required form-control" size="6"' . $ownerTooltip . ' />';

		HTML_groupjiveGroupEdit::showGroupEdit( $row, $input, $category, $user, $this );
	}

	/**
	 * save group
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveGroupEdit( $id, $user )
	{
		global $_CB_framework, $_PLUGINS;

		$input							=	$this->getInput();
		$files							=	$input->getNamespaceRegistry( 'files' );

		$row							=	CBGroupJive::getGroup( $this->getInput()->getInt( 'post/group', $id ) );

		$row->set( '_input', $input );
		$row->set( '_files', $files );

		$isModerator		=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );

		if ( $row->getInt( 'id', 0 ) ) {
			$categoryId		=	$this->getInput()->getInt( 'post/category' );

			if ( $categoryId !== null ) {
				$category	=	CBGroupJive::getCategory( $categoryId );
			} else {
				$category	=	$row->category();
			}

			$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) );
		} else {
			$categoryId		=	$this->getInput()->getInt( 'post/category', $this->getInput()->getInt( 'get/category' ) );
			$category		=	CBGroupJive::getCategory( $categoryId );

			if ( $categoryId === null ) {
				$returnUrl	=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'all' ) );
			} elseif ( ( ! $categoryId ) && ( ! $this->params->getInt( 'groups_uncategorized', 1 ) ) ) {
				$returnUrl	=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'all' ) );
			} else {
				$returnUrl	=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'categories', 'func' => 'show', 'id' => $category->getInt( 'id', 0 ) ) );
			}
		}

		if ( ! $isModerator ) {
			if ( ( ! $category->getInt( 'id', 0 ) ) && ( ! $this->params->getInt( 'groups_uncategorized', 1 ) ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Category does not exist.' ), 'error' );
			} elseif ( $category->getInt( 'id', 0 ) && ( ( ! $category->getInt( 'published', 0 ) ) || ( ! CBGroupJive::canAccess( $category->getInt( 'access', 0 ), $user->getInt( 'id', 0 ) ) ) ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to this category.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 ) ) {
				if ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this group.' ), 'error' );
				}
			} elseif ( ! CBGroupJive::canCreateGroup( $user, $category ) ) {
				if ( $category->getInt( 'id', 0 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create a group in this category.' ), 'error' );
				} else {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create a group.' ), 'error' );
				}
			}
		}

		if ( $isModerator ) {
			$row->set( 'user_id', $this->getInput()->getInt( 'post/user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) );
		} else {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		}

		$row->set( 'published', ( $isModerator || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( ! $this->params->getInt( 'groups_create_approval', 0 ) ) ? $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) : -1 ) );
		$row->set( 'category', $category->getInt( 'id', 0 ) );
		$row->set( 'type', $this->getInput()->getInt( 'post/type', $row->getInt( 'type', 1 ) ) );
		$row->set( 'name', $this->getInput()->getString( 'post/name', $row->getString( 'name' ) ) );
		$row->set( 'description', $this->getInput()->getString( 'post/description', $row->getString( 'description' ) ) );
		$row->set( 'ordering', $row->getInt( 'ordering', 1 ) );

		foreach ( $this->getInput()->subTree( 'params' ) as $k => $v ) {
			if ( is_array( $v ) || is_object( $v ) ) {
				continue;
			}

			$k				=	Get::clean( $k, GetterInterface::COMMAND );

			if ( $k ) {
				if ( is_numeric( $v ) ) {
					$v		=	$this->getInput()->getInt( 'post/params.' . $k );

					if ( ( $v === 2 ) && ( $row->getInt( 'type', 0 ) === 4 ) && in_array( $k, array( 'video', 'events', 'photo', 'file' ), true ) ) {
						$v	=	1;
					}
				} else {
					$v		=	$this->getInput()->getString( 'post/params.' . $k );
				}

				$row->params()->set( $k, $v );
			}
		}

		$row->set( 'params', $row->params()->asJson() );

		if ( ( ! $isModerator ) && $this->params->getInt( 'groups_create_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$_PLUGINS->trigger( 'onCheckCaptchaHtmlElements', array() );

			if ( $_PLUGINS->is_errors() ) {
				$row->setError( $_PLUGINS->getErrorMSG() );
			}
		}

		$new				=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_FAILED_TO_SAVE', 'Group failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showGroupEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_FAILED_TO_SAVE', 'Group failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showGroupEdit( $id, $user );
			return;
		}

		if ( $row->getInt( 'published', 0 ) === -1 ) {
			if ( $new ) {
				if ( $this->params->getInt( 'groups_create_approval_notify', 1 ) ) {
					CBGroupJive::sendNotification( 'group_pending', 3, $row->getInt( 'user_id', 0 ), null, CBTxt::T( 'Group create request awaiting approval' ), CBTxt::T( '[user] has created the group [group] and is awaiting approval!' ), $row );
				}

				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group created successfully and awaiting approval!' ) );
			} else {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group saved successfully and awaiting approval!' ) );
			}
		} elseif ( $new ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group created successfully!' ) );
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group saved successfully!' ) );
		}
	}

	/**
	 * send group message
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function sendGroupMessage( $id, $user )
	{
		global $_CB_framework, $_CB_database;

		$row					=	CBGroupJive::getGroup( $id );
		$returnUrl				=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ) );

		if ( $row->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to messaging in this group.' ), 'error' );
		} elseif ( CBGroupJive::canAccessGroup( $row, $user ) ) {
			if ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ! $this->params->getInt( 'groups_message', 0 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to messaging in this group.' ), 'error' );
				} elseif ( ( $row->getInt( 'published', 0 ) === -1 ) || ( CBGroupJive::getGroupStatus( $user, $row ) < 3 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to messaging in this group.' ), 'error' );
				} elseif ( $row->params()->getString( 'messaged' ) ) {
					$seconds	=	$this->params->getInt( 'groups_message_delay', 60 );

					if ( $seconds && ( Application::Date( $row->params()->getString( 'messaged' ), 'UTC' )->add( $seconds . ' SECONDS' )->getTimestamp() >= Application::Date( 'now', 'UTC' )->getTimestamp() ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You can not send a message to this group at this time. Please wait awhile and try again.' ), 'error' );
					}
				}
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		}

		$message				=	( $this->params->getBool( 'groups_message_html', false ) ? $this->getInput()->getHtml( 'post/message' ) : $this->getInput()->getString( 'post/message' ) );

		if ( ! $message ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_MESSAGE_FAILED_TO_SEND', 'Group message failed to send! Error: [error]', array( '[error]' => CBTxt::T( 'Message not specified!' ) ) ), 'error' );

			$this->showGroupMessage( $id, $user );
			return;
		}

		$query					=	'SELECT cb.*, j.*'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = u.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE u." . $_CB_database->NameQuote( 'user_id' ) . " != " . $user->getInt( 'id', 0 )
								.	"\n AND u." . $_CB_database->NameQuote( 'group' ) . " = " . $row->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0"
								.	"\n AND u." . $_CB_database->NameQuote( 'status' ) . " > 0";
		$_CB_database->setQuery( $query );
		$users					=	$_CB_database->loadObjectList( null, '\CB\Database\Table\UserTable', array( $_CB_database ) );

		if ( ! $users ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'This group has no users to message.' ) );
		} else {
			$subject			=	$this->getInput()->getString( 'post/subject' );

			if ( $subject && ( $this->params->getInt( 'groups_message_type', 2 ) === 1 ) && $this->params->getBool( 'groups_message_subject', false ) ) {
				$subject		=	CBTxt::T( 'GROUP_MESSAGE_SUBJECT', 'Group message - [subject]', array( '[subject]' => $subject ) );
			} else {
				$subject		=	CBTxt::T( 'Group message' );
			}

			CBGroupJive::prefetchUsers( $users );

			foreach ( $users as $usr ) {
				CBGroupJive::sendNotification( 'group_message', $this->params->getInt( 'groups_message_type', 2 ), $user, $usr, $subject, CBTxt::T( 'GROUP_MESSAGE', 'Group [group] has sent the following message.<p>[message]</p>', array( '[message]' => $message ) ), $row, array( 'message' => $message ) );
			}
		}

		$row->params()->set( 'messaged', Application::Database()->getUtcDateTime() );

		$row->set( 'params', $row->params()->asJson() );

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_FAILED_TO_SAVE', 'Group failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showGroupMessage( $id, $user );
			return;
		}

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group messaged successfully!' ) );
	}

	/**
	 * set group user status
	 *
	 * @param int       $status
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function statusUser( $status, $id, $user )
	{
		global $_CB_framework;

		$row						=	CBGroupJive::getUser( $id );
		$returnUrl					=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->group()->getInt( 'id', 0 ) ) );

		if ( $row->group()->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to users in this group.' ), 'error' );
		} elseif ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( $row->getInt( 'user_id', 0 ) === $row->group()->getInt( 'user_id', 0 ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You can not promote or demote the group owner.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You can not promote or demote your self.' ), 'error' );
				} elseif ( $user->getInt( 'id', 0 ) !== $row->group()->getInt( 'user_id', 0 ) ) {
					$userStatus		=	CBGroupJive::getGroupStatus( $user, $row->group() );

					if ( ( ( $userStatus <= 2 ) && ( $status === 2 ) )
						 || ( $row->getInt( 'status', 0 ) > $userStatus )
						 || ( ( $userStatus <= 1 ) && in_array( $status, array( -1, 1 ), true ) )
						 || in_array( $status, array( 0, 3, 4 ), true )
					) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to promote or demote this user.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'User does not exist.' ), 'error' );
		}

		$currentStatus				=	$row->getInt( 'status', 0 );

		$row->set( 'status', (int) $status );

		if ( $row->getError() || ( ! $row->store() ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_USER_STATUS_FAILED_TO_SAVE', 'User status failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $status && ( $currentStatus === 0 ) ) {
			if ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotification( 'user_accepted', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Group join request accepted' ), CBTxt::T( 'Your join request to group [group] has been accepted!' ), $row->group() );
			}

			CBGroupJive::sendNotifications( 'user_join', CBTxt::T( 'User joined a mutual group' ), CBTxt::T( '[user] has joined the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ) );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'User status saved successfully!' ) );
	}

	/**
	 * delete user
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteUser( $id, $user )
	{
		global $_CB_framework;

		$row						=	CBGroupJive::getUser( $id );
		$returnUrl					=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->group()->getInt( 'id', 0 ) ) );

		if ( $row->group()->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to users in this group.' ), 'error' );
		} elseif ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( $row->getInt( 'user_id', 0 ) === $row->group()->getInt( 'user_id', 0 ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You can not delete the group owner.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You can not delete your self.' ), 'error' );
				} elseif ( $user->getInt( 'id', 0 ) !== $row->group()->getInt( 'user_id', 0 ) ) {
					$userStatus		=	CBGroupJive::getGroupStatus( $user, $row->group() );

					if ( ( $userStatus < 3 ) || ( $row->getInt( 'status', 0 ) > $userStatus ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this user.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'User does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_USER_FAILED_TO_DELETE', 'User failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_USER_FAILED_TO_DELETE', 'User failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ( $row->getInt( 'status', 0 ) === 0 ) && ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) ) {
			CBGroupJive::sendNotification( 'user_rejected', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Group join request rejected' ), CBTxt::T( 'Your join request to group [group] has been rejected!' ), $row->group() );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'User deleted successfully!' ) );
	}

	/**
	 * prepare frontend invite edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showInviteEdit( $id, $user )
	{
		global $_CB_framework;

		$row							=	CBGroupJive::getInvite( $id );
		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId						=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group						=	$row->group();
		} else {
			$group						=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl						=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
		} elseif ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( $row->getInt( 'id', 0 ) && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this invite.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( $row->getInt( 'published', 0 ) === -1 ) || ( ( ! $this->params->getInt( 'groups_invites_display', 1 ) ) && ( $group->getInt( 'type', 0 ) !== 3 ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
			} elseif ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'invites' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create an invite in this group.' ), 'error' );
			}
		}

		CBGroupJive::getTemplate( 'invite_edit' );

		$input								=	array();

		$inviteBy							=	array();
		$inviteByLimit						=	cbToArrayOfInt( explode( '|*|', $this->params->getString( 'groups_invites_by', '1|*|2|*|3|*|4' ) ) );

		if ( ! $inviteByLimit ) {
			$inviteByLimit					=	array( 1, 2, 3, 4 );
		}

		if ( in_array( 1, $inviteByLimit, true ) ) {
			$inviteBy[]						=	CBTxt::T( 'User ID' );
		}

		if ( in_array( 2, $inviteByLimit, true ) ) {
			$inviteBy[]						=	CBTxt::T( 'Username' );
		}

		if ( in_array( 3, $inviteByLimit, true ) ) {
			$inviteBy[]						=	CBTxt::T( 'Name' );
		}

		if ( in_array( 4, $inviteByLimit, true ) ) {
			$inviteBy[]						=	CBTxt::T( 'Email Address' );
		}

		$input['invite_by']					=	$inviteBy;

		$listConnections					=	array();

		if ( Application::Config()->getInt( 'allowConnections' ) ) {
			$cbConnection					=	new cbConnection( $user->getInt( 'id', 0 ) );

			foreach( $cbConnection->getConnectedToMe( $user->getInt( 'id', 0 ) ) as $connection ) {
				$listConnections[]			=	moscomprofilerHTML::makeOption( (string) $connection->id, getNameFormat( $connection->name, $connection->username, Application::Config()->getInt( 'name_format', 3 ) ) );
			}
		}

		if ( $listConnections ) {
			array_unshift( $listConnections, moscomprofilerHTML::makeOption( '0', CBTxt::T( '- Select Connection -' ) ) );

			$listTooltip					=	cbTooltip( null, CBTxt::T( 'Select a connection to invite.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

			$input['list']					=	moscomprofilerHTML::selectList( $listConnections, 'selected', 'class="gjInviteConnection form-control"' . $listTooltip, 'value', 'text', $this->getInput()->getInt( 'post/selected', 0 ), 1, false, false );
		} else {
			$input['list']					=	null;
		}

		$toTooltup							=	cbTooltip( null, CBTxt::T( 'GROUP_INVITE_BY', 'Input the recipient as [invite_by].', array( '[invite_by]' => implode( ', ', $inviteBy ) ) ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['to']						=	'<input type="text" id="to" name="to" value="' . htmlspecialchars( $this->getInput()->getString( 'post/to', ( $row->getInt( 'user', 0 ) ? $row->getInt( 'user', 0 ) : $row->getString( 'email' ) ) ) ) . '" class="form-control" size="40"' . $toTooltup . ' />';

		$messageTooltip						=	cbTooltip( null, CBTxt::T( 'Optionally input private message to include with the invite.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['message']					=	'<textarea id="message" name="message" class="form-control" cols="40" rows="5"' . $messageTooltip . '>' . htmlspecialchars( $this->getInput()->getString( 'post/message', $row->getString( 'message' ) ) ) . '</textarea>';

		HTML_groupjiveInviteEdit::showInviteEdit( $row, $input, $group, $user, $this );
	}

	/**
	 * save invite
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveInviteEdit( $id, $user )
	{
		global $_CB_framework, $_CB_database, $_PLUGINS;

		$row							=	CBGroupJive::getInvite( $id );
		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId						=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group						=	$row->group();
		} else {
			$group						=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl						=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( $group->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
		} elseif ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( $row->getInt( 'id', 0 ) && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this invite.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( $group->getInt( 'published', 0 ) === -1 ) || ( ( ! $this->params->getInt( 'groups_invites_display', 1 ) ) && ( $group->getInt( 'type', 0 ) !== 3 ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
			} elseif ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'invites' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to create an invite in this group.' ), 'error' );
			}
		}

		$skipCaptcha					=	false;

		$row->set( 'message', $this->getInput()->getString( 'post/message', $row->getString( 'message' ) ) );

		if ( ! $row->getInt( 'id', 0 ) ) {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
			$row->set( 'group', $group->getInt( 'id', 0 ) );

			$to							=	$this->getInput()->getString( 'post/to' );
			$selected					=	$this->getInput()->getInt( 'post/selected', 0 );

			if ( $selected ) {
				$token					=	$this->getInput()->getString( 'post/token' );

				if ( $token ) {
					if ( $token === md5( $row->getInt( 'user_id', 0 ) . $to . $row->getInt( 'group', 0 ) . $row->getString( 'message' ) . $_CB_framework->getCfg( 'secret' ) ) ) {
						$skipCaptcha	=	true;

						$row->set( 'user', $selected );
					}
				} elseif ( $this->params->getInt( 'groups_invites_list', 0 ) ) {
					$connections		=	array();
					$cbConnection		=	new cbConnection( $user->getInt( 'id', 0 ) );

					foreach( $cbConnection->getConnectedToMe( $user->getInt( 'id', 0 ) ) as $connection ) {
						$connections[]	=	(int) $connection->id;
					}

					if ( in_array( $selected, $connections, true ) ) {
						$row->set( 'user', $selected );
					}
				}
			} elseif ( $to ) {
				$inviteByLimit			=	cbToArrayOfInt( explode( '|*|', $this->params->getString( 'groups_invites_by', '1|*|2|*|3|*|4' ) ) );

				if ( ! $inviteByLimit ) {
					$inviteByLimit		=	array( 1, 2, 3, 4 );
				}

				$recipient				=	new UserTable();

				if ( in_array( 1, $inviteByLimit, true ) && $recipient->load( (int) $to ) ) {
					$row->set( 'user', $recipient->getInt( 'id', 0 ) );
				} elseif ( in_array( 4, $inviteByLimit, true ) && cbIsValidEmail( $to ) ) {
					if ( $recipient->load( array( 'email' => $to ) ) ) {
						$row->set( 'user', $recipient->getInt( 'id', 0 ) );
					} else {
						$row->set( 'email', $to );
					}
				} elseif ( in_array( 2, $inviteByLimit, true ) && $recipient->load( array( 'username' => $to ) ) ) {
					$row->set( 'user', $recipient->getInt( 'id', 0 ) );
				} elseif ( in_array( 3, $inviteByLimit, true ) ) {
					$query				=	'SELECT cb.' . $_CB_database->NameQuote( 'id' )
										.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
										.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = cb.' . $_CB_database->NameQuote( 'id' )
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
										.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = cb.' . $_CB_database->NameQuote( 'id' )
										.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = ' . $group->getInt( 'id', 0 )
										.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
										.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = ' . $group->getInt( 'id', 0 )
										.	' AND i.' . $_CB_database->NameQuote( 'user' ) . ' = cb.' . $_CB_database->NameQuote( 'id' )
										.	"\n WHERE j." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $to, true ) . '%', false )
										.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
										.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
										.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0"
										.	"\n AND u." . $_CB_database->NameQuote( 'id' ) . " IS NULL"
										.	"\n AND i." . $_CB_database->NameQuote( 'id' ) . " IS NULL"
										.	"\n ORDER BY j." . $_CB_database->NameQuote( 'registerDate' ) . " DESC";
					$_CB_database->setQuery( $query, 0, 15 );
					$users				=	$_CB_database->loadResultArray();

					if ( $users ) {
						if ( count( $users ) > 1 ) {
							CBGroupJive::getTemplate( 'invite_list' );

							CBuser::advanceNoticeOfUsersNeeded( $users );

							HTML_groupjiveInviteList::showInviteList( $to, $users, $row, $group, $user, $this );
							return;
						}

						$row->set( 'user', (int) $users[0] );
					}
				}
			}
		}

		if ( ( ! $isModerator ) && $this->params->getInt( 'groups_create_captcha', 0 ) && ( ! $skipCaptcha ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$_PLUGINS->trigger( 'onCheckCaptchaHtmlElements', array() );

			if ( $_PLUGINS->is_errors() ) {
				$row->setError( $_PLUGINS->getErrorMSG() );
			}
		}

		$new							=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_INVITE_FAILED_TO_SAVE', 'Invite failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showInviteEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_INVITE_FAILED_TO_SAVE', 'Invite failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showInviteEdit( $id, $user );
			return;
		}

		if ( $new ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Invite created successfully!' ) );
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Invite saved successfully!' ) );
		}
	}

	/**
	 * delete invite
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteInvite( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJive::getInvite( $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->group()->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
		} elseif ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this invite.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( ! $this->params->getInt( 'groups_invites_display', 1 ) ) && ( $row->group()->getInt( 'type', 0 ) !== 3 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Invite does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_INVITE_FAILED_TO_DELETE', 'Invite failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_INVITE_FAILED_TO_DELETE', 'Invite failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Invite deleted successfully!' ) );
	}

	/**
	 * resend invite
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function sendInvite( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJive::getInvite( $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->group()->getInt( 'type', 0 ) === 4 ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
		} elseif ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to send this invite.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $row->group()->getInt( 'published', 0 ) === -1 ) || ( ( ! $this->params->getInt( 'groups_invites_display', 1 ) ) && ( $row->group()->getInt( 'type', 0 ) !== 3 ) ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to invites in this group.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Invite does not exist.' ), 'error' );
		}

		if ( ! $row->send() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_INVITE_FAILED_TO_SEND', 'Invite failed to send. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Invite sent successfully!' ) );
	}

	/**
	 * save notifications
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveNotifications( $id, $user )
	{
		global $_CB_framework;

		$group				=	CBGroupJive::getGroup( $id );
		$isModerator		=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$returnUrl			=	$_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ( ! $this->params->getInt( 'notifications', 1 ) ) || ( $group->getInt( 'type', 0 ) === 4 ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to notifications in this group.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ! CBGroupJive::canCreateGroupContent( $user, $group ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to notifications in this group.' ), 'error' );
			}
		}

		$row				=	new NotificationTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'group' => $group->getInt( 'id', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this users notifications.' ), 'error' );
		}

		$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		$row->set( 'group', $row->getInt( 'group', $group->getInt( 'id', 0 ) ) );

		foreach ( $this->getInput()->subTree( 'params' ) as $k => $v ) {
			if ( is_array( $v ) || is_object( $v ) ) {
				continue;
			}

			$k				=	Get::clean( $k, GetterInterface::COMMAND );

			if ( $k ) {
				if ( is_numeric( $v ) ) {
					$v		=	$this->getInput()->getInt( 'post/params.' . $k );
				} else {
					$v		=	$this->getInput()->getString( 'post/params.' . $k );
				}

				$row->params()->set( $k, $v );
			}
		}

		$row->set( 'params', $row->params()->asJson() );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_NOTIFICATIONS_FAILED_TO_SAVE', 'Notifications failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showGroupNotifications( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_NOTIFICATIONS_FAILED_TO_SAVE', 'Notifications failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showGroupNotifications( $id, $user );
			return;
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Notifications saved successfully!' ) );
	}
}