<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\Table\InviteTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveInviteList
{

	/**
	 * render frontend invite list
	 *
	 * @param string             $to
	 * @param UserTable[]        $users
	 * @param InviteTable        $invite
	 * @param GroupTable         $group
	 * @param UserTable          $user
	 * @param CBplug_cbgroupjive $plugin
	 */
	public static function showInviteList( $to, $users, $invite, $group, $user, $plugin )
	{
		global $_CB_framework;

		$js								=	"$( '.gjButtonInvite' ).on( 'click', function() {"
										.		"var from = $( this ).closest( 'form' );"
										.		"from.find( '#selected' ).val( $( this ).data( 'user-id' ) );"
										.		"from.find( '.gjButtonInvite' ).addClass( 'disabled' ).prop( 'disabled', true );"
										.		"from.submit();"
										.	"});";

		$_CB_framework->outputCbJQuery( $js );

		$_CB_framework->enqueueMessage( CBTxt::T( 'Multiple matching users found. Please select the user to invite. If you do not see the user you are looking for please be more specific.' ) );

		$pageTitle					=	CBTxt::T( 'INVITE_LIST_TO', 'Invite: [to]', array( '[to]' => $to ) );

		$_CB_framework->setPageTitle( $pageTitle );

		$return						=	'<div class="gjInviteList">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'invites', 'func' => 'save', 'group' => ( ! $invite->getInt( 'id', 0 ) ? $group->getInt( 'id' ) : null ), 'id' => $invite->getInt( 'id' ) ) ) . '" method="post" enctype="multipart/form-data" name="gjInviteListForm" id="gjInviteListForm" class="m-0 form-auto cb_form gjInviteListForm">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjInviteListTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null )
									.			'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjInviteListRows">';

		foreach ( $users as $userId ) {
			$cbUser					=	CBuser::getInstance( (int) $userId, false );

			$return					.=				'<div class="col-12 col-md-6 col-lg-4 pb-3 pl-2 pr-2 gjInviteListUser">'
									.					'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutSm">'
									.						'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
									.							'<div class="position-absolute cbCanvasLayoutBackground">'
									.								$cbUser->getField( 'canvas', null, 'html', 'none', 'profile', 0, true )
									.							'</div>'
									.							'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
									.								'<button type="button" class="btn btn-sm btn-success gjButton gjButtonInvite" data-user-id="' . (int) $userId . '">' . CBTxt::T( 'Invite' ) . '</button>'
									.							'</div>'
									.						'</div>'
									.						'<div class="position-relative cbCanvasLayoutBottom">'
									.							'<div class="position-absolute cbCanvasLayoutPhoto">'
									.								$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
									.							'</div>'
									.						'</div>'
									.						'<div class="card-body p-2 position-relative cbCanvasLayoutBody">'
									.							'<div class="text-truncate cbCanvasLayoutContent">'
									.								$cbUser->getField( 'onlinestatus', null, 'html', 'none', 'profile', 0, true, array( 'params' => array( 'displayMode' => 1 ) ) )
									.								' <span class="text-large">' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true, array( 'params' => array( 'fieldHoverCanvas' => false ) ) ) . '</span>'
									.							'</div>'
									.						'</div>'
									.					'</div>'
									.				'</div>';
		}

		$return						.=			'</div>'
									.			'<div class="mt-3 text-right">'
									.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel">' . CBTxt::T( 'Cancel' ) . '</a>'
									.			'</div>'
									.			'<input type="hidden" id="selected" name="selected" value="0" />';

		if ( ! $invite->getInt( 'id', 0 ) ) {
			$return					.=			'<input type="hidden" id="to" name="to" value="' . htmlspecialchars( $to ) . '" />'
									.			'<input type="hidden" id="group" name="group" value="' . $group->getInt( 'id', 0 ) . '" />'
									.			'<input type="hidden" id="message" name="message" value="' . htmlspecialchars( $invite->getString( 'message' ) ) . '" />';
		}

		$return						.=			'<input type="hidden" id="token" name="token" value="' . htmlspecialchars( md5( $invite->getInt( 'user_id', 0 ) . $to . $invite->getInt( 'group', 0 ) . $invite->getString( 'message' ) . $_CB_framework->getCfg( 'secret' ) ) ) . '" />'
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		echo $return;
	}
}