<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveFile\CBGroupJiveFile;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );

class CBplug_cbgroupjivefile extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		$format					=	$this->getInput()->getString( 'format' );

		if ( $format !== 'raw' ) {
			outputCbJs();
			outputCbTemplate();
		}

		$action					=	$this->getInput()->getString( 'action' );
		$function				=	$this->getInput()->getString( 'func' );
		$id						=	$this->getInput()->getInt( 'id', 0 );

		if ( $user === null ) {
			$user				=	CBuser::getMyUserDataInstance();
		}

		if ( $format !== 'raw' ) {
			ob_start();
		}

		if ( $action === 'file' ) {
			switch ( $function ) {
				case 'download':
					$this->outputFile( false, $id, $user );
					break;
				case 'publish':
					$this->stateFile( 1, $id, $user );
					break;
				case 'unpublish':
					$this->stateFile( 0, $id, $user );
					break;
				case 'delete':
					$this->deleteFile( $id, $user );
					break;
				case 'new':
					$this->showFileEdit( null, $user );
					break;
				case 'edit':
					$this->showFileEdit( $id, $user );
					break;
				case 'save':
					cbSpoofCheck( 'plugin' );
					$this->saveFileEdit( $id, $user );
					break;
				case 'preview':
				case 'show':
				default:
					$this->outputFile( true, $id, $user );
					break;
			}
		}

		if ( $format !== 'raw' ) {
			$html				=	ob_get_clean();

			$gjClass			=	CBGroupJive::getGlobalParams()->getString( 'general_class' );

			$return				=	'<div class="cbGroupJive' . ( $gjClass ? ' ' . htmlspecialchars( $gjClass ) : null ) . '">'
								.		$html
								.	'</div>';

			echo $return;
		}
	}

	/**
	 * prepare frontend file edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showFileEdit( $id, $user )
	{
		global $_CB_framework;

		$row							=	CBGroupJiveFile::getFile( (int) $id );
		$isModerator					=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId						=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group						=	$row->group();
		} else {
			$group						=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl						=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'file' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to upload a file in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this file.' ), 'error' );
			}
		}

		CBGroupJive::getTemplate( 'file_edit', true, true, $this->element );

		$minFileSize					=	$this->params->getInt( 'groups_file_min_size', 0 );
		$maxFileSize					=	$this->params->getInt( 'groups_file_max_size', 1024 );
		$extensions						=	explode( ',', $this->params->getString( 'groups_file_extensions', 'zip,rar,doc,pdf,txt,xls' ) );

		$fileValidation					=	array();

		if ( $minFileSize || $maxFileSize ) {
			$fileValidation[]			=	cbValidator::getRuleHtmlAttributes( 'filesize', array( $minFileSize, $maxFileSize, 'KB' ) );
		}

		if ( $extensions ) {
			$fileValidation[]			=	cbValidator::getRuleHtmlAttributes( 'extension', implode( ',', $extensions ) );
		}

		$input							=	array();

		$publishedTooltip				=	cbTooltip( null, CBTxt::T( 'Select publish state of this file. Unpublished files will not be visible to the public.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['published']				=	moscomprofilerHTML::yesnoButtonList( 'published', $publishedTooltip, $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) );

		$titleTooltup					=	cbTooltip( null, CBTxt::T( 'Optionally input a file title to display instead of filename.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['title']					=	'<input type="text" id="title" name="title" value="' . htmlspecialchars( $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) ) . '" class="form-control" size="35"' . $titleTooltup . ' />';

		$fileTooltip					=	cbTooltip( null, CBTxt::T( 'Select the file to upload.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['file']					=	'<input type="file" id="file" name="file" value="" class="form-control' . ( ! $row->getInt( 'id', 0 ) ? ' required' : null ) . '"' . ( $fileTooltip ? ' ' . $fileTooltip : null ) . ( $fileValidation ? implode( ' ', $fileValidation ) : null ) . ' />';

		$input['file_limits']			=	array();

		if ( $extensions ) {
			$input['file_limits'][]		=	CBTxt::T( 'GROUP_FILE_LIMITS_EXT', 'Your file must be of [ext] type.', array( '[ext]' => implode( ', ', $extensions ) ) );
		}

		if ( $minFileSize ) {
			$input['file_limits'][]		=	CBTxt::T( 'GROUP_FILE_LIMITS_MIN', 'Your file should exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $minFileSize * 1024 ) ) );
		}

		if ( $maxFileSize ) {
			$input['file_limits'][]		=	CBTxt::T( 'GROUP_FILE_LIMITS_MAX', 'Your file should not exceed [size].', array( '[size]' => CBGroupJive::getFormattedFileSize( $maxFileSize * 1024 ) ) );
		}

		$descriptionTooltip				=	cbTooltip( null, CBTxt::T( 'Optionally input a file description.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['description']			=	'<textarea id="description" name="description" class="form-control" cols="40" rows="5"' . ( $descriptionTooltip ? ' ' . $descriptionTooltip : null ) . '>' . htmlspecialchars( $this->getInput()->getString( 'post/description', $row->getString( 'description' ) ) ) . '</textarea>';

		$ownerTooltip					=	cbTooltip( null, CBTxt::T( 'Input the file owner id. File owner determines the creator of the file specified as User ID.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['user_id']				=	'<input type="text" id="user_id" name="user_id" value="' . $this->getInput()->getInt( 'post/user_id', $this->getInput()->getInt( 'user', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) ) . '" class="digits required form-control" size="6"' . $ownerTooltip . ' />';

		HTML_groupjiveFileEdit::showFileEdit( $row, $input, $group, $user, $this );
	}

	/**
	 * save file
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveFileEdit( $id, $user )
	{
		global $_CB_framework, $_PLUGINS;

		$row					=	CBGroupJiveFile::getFile( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'file' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to upload a file in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this file.' ), 'error' );
			}
		}

		if ( $isModerator ) {
			$row->set( 'user_id', $this->getInput()->getInt( 'post/user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) );
		} else {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		}

		$canModerate			=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );

		$row->set( 'published', ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( $group->params()->getInt( 'file', 1 ) !== 2 ) ? $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) : -1 ) );
		$row->set( 'group', $group->getInt( 'id', 0 ) );
		$row->set( 'title', $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) );
		$row->set( 'description', $this->getInput()->getString( 'post/description', $row->getString( 'description' ) ) );

		if ( ( ! $isModerator ) && $this->params->getInt( 'groups_file_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$_PLUGINS->trigger( 'onCheckCaptchaHtmlElements', array() );

			if ( $_PLUGINS->is_errors() ) {
				$row->setError( $_PLUGINS->getErrorMSG() );
			}
		}

		$new					=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_FILE_FAILED_TO_SAVE', 'File failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showFileEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_FILE_FAILED_TO_SAVE', 'File failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showFileEdit( $id, $user );
			return;
		}

		if ( $new ) {
			$extras				=	array(	'file_id'			=>	$row->getInt( 'id', 0 ),
											'file_title'		=>	htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ),
											'file_description'	=>	htmlspecialchars( $row->getString( 'description' ) ),
											'file_size'			=>	$row->size(),
											'file_type'			=>	$row->mimeType(),
											'file_extension'	=>	$row->extension(),
											'file_url'			=>	$_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'file', 'func' => 'download', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true ),
											'file_date'			=>	cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_FILE_DATE_FORMAT', 'M j, Y' ) ),
											'file'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabfile' ) ) . '">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>' );

			if ( $row->getInt( 'published', 0 ) === 1 ) {
				CBGroupJive::sendNotifications( 'file_new', CBTxt::T( 'New group file' ), CBTxt::T( '[user] has uploaded the file [file] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
			} elseif ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $row->group()->params()->getInt( 'file', 1 ) === 2 ) ) {
				CBGroupJive::sendNotifications( 'file_approve', CBTxt::T( 'New group file awaiting approval' ), CBTxt::T( '[user] has uploaded the file [file] in the group [group] and is awaiting approval!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 2, $extras );

				cbRedirect( $returnUrl, CBTxt::T( 'File uploaded successfully and awaiting approval!' ) );
			}

			cbRedirect( $returnUrl, CBTxt::T( 'File uploaded successfully!' ) );
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'File saved successfully!' ) );
		}
	}

	/**
	 * set file publish state status
	 *
	 * @param int       $state
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function stateFile( $state, $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJiveFile::getFile( (int) $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) {
					if ( ( $row->getInt( 'published', 0 ) === -1 )
						 && ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) )
						 && ( $row->group()->params()->getInt( 'file', 1 ) === 2 )
					) {
						cbRedirect( $returnUrl, CBTxt::T( 'Your file is awaiting approval.' ), 'error' );
					} elseif ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish or unpublish this file.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'File does not exist.' ), 'error' );
		}

		$currentState		=	$row->getInt( 'published', 0 );

		$row->set( 'published', (int) $state );

		if ( $row->getError() || ( ! $row->store() ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_FILE_STATE_FAILED_TO_SAVE', 'File state failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $state && ( $currentState === -1 ) ) {
			$extras			=	array(	'file_id'			=>	$row->getInt( 'id', 0 ),
										'file_title'		=>	htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ),
										'file_description'	=>	htmlspecialchars( $row->getString( 'description' ) ),
										'file_size'			=>	$row->size(),
										'file_type'			=>	$row->mimeType(),
										'file_extension'	=>	$row->extension(),
										'file_url'			=>	$_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'file', 'func' => 'download', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true ),
										'file_date'			=>	cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_FILE_DATE_FORMAT', 'M j, Y' ) ),
										'file'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabfile' ) ) . '">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>' );

			if ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotification( 'file_approved', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'File upload request accepted' ), CBTxt::T( 'Your file [file] upload request in the group [group] has been accepted!' ), $row->group(), $extras );
			}

			CBGroupJive::sendNotifications( 'file_new', CBTxt::T( 'New group file' ), CBTxt::T( '[user] has uploaded the file [file] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'File state saved successfully!' ) );
	}

	/**
	 * delete file
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteFile( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJiveFile::getFile( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this file.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'File does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_FILE_FAILED_TO_DELETE', 'File failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_FILE_FAILED_TO_DELETE', 'File failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'File deleted successfully!' ) );
	}

	/**
	 * output file
	 *
	 * @param bool      $preview
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function outputFile( $preview, $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJiveFile::getFile( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $row->getInt( 'published', 0 ) !== 1 ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to this file.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'File does not exist.' ), 'error' );
		}

		if ( $preview ) {
			$row->preview();
		} else {
			$row->download();
		}
	}
}