<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Registry\GetterInterface;
use CB\Database\Table\UserTable;
use CB\Plugin\ProfileBook\Table\EntryTable;
use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework;

/**
 * @var UserTable    $viewer
 * @var EntryTable[] $rows
 */
?>
<div class="<?php echo htmlspecialchars( $templateClass ); ?>">
	<div class="pbModuleRows">
		<?php
		foreach ( $rows as $row ) {
			$cbUser			=	CBuser::getInstance( $row->get( 'posterid', 0, GetterInterface::INT ), false );
			$cbUserOwner	=	CBuser::getInstance( $row->get( 'userid', 0, GetterInterface::INT ), false );
		?>
		<div class="mb-2 pbModuleRow">
			<div class="media pbModuleRowHeader">
				<div class="media-left pbModuleRowAvatar">
				<?php
				if ( ! $row->get( 'posterid', 0, GetterInterface::INT ) ) {
					echo '<img src="' . selectTemplate() . 'images/avatar/tnnophoto_n.png" class="cbImgPict cbThumbPict img-thumbnail" />';
				} else {
					echo $cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true );
				}
				?>
				</div>
				<div class="media-body pl-2 text-small pbModuleRowDetails">
					<div class="pbModuleRowAuthor">
						<strong class="text-muted">
						<?php
						if ( ! $row->get( 'posterid', 0, GetterInterface::INT ) ) {
							echo $row->get( 'postername', CBTxt::T( 'Anonymous' ), GetterInterface::STRING );
						} else {
							echo $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true );
						}
						?>
						</strong>
						<?php
						switch ( $row->get( 'mode', null, GetterInterface::STRING ) ) {
							case 'g':
								$url		=	$_CB_framework->userProfileUrl( $row->get( 'userid', 0, GetterInterface::INT ), false, 'getprofilebookTab' );

								if ( $viewer->get( 'id', 0, GetterInterface::INT ) == $row->get( 'userid', 0, GetterInterface::INT ) ) {
									echo CBTxt::T( 'SIGNED_YOUR_GUESTBOOK', 'signed your <a href="[url]">guestbook</a>', array( '[url]' => $url ) );
								} else {
									echo CBTxt::T( 'SIGNED_USER_GUESTBOOK', 'signed [user] <a href="[url]">guestbook</a>', array( '[url]' => $url, '[user]' => $cbUserOwner->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
								}
								break;
							case 'b':
								$url		=	$_CB_framework->pluginClassUrl( 'cb.profilebook', true, array( 'action' => 'entry', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) );
								$title		=	$row->get( 'postertitle', null, GetterInterface::STRING );

								if ( cbutf8_strlen( $title ) > 30 ) {
									$title	=	trim( cbutf8_substr( $title, 0, 30 ) ) . '...';
								}

								echo CBTxt::T( 'BLOGGED_BLOG', 'blogged <a href="[url]">[title]</a>', array( '[url]' => $url, '[title]' => $title ) );
								break;
							case 'w':
								$url		=	$_CB_framework->userProfileUrl( $row->get( 'userid', 0, GetterInterface::INT ), false, 'getprofilebookwallTab' );

								if ( $viewer->get( 'id', 0, GetterInterface::INT ) == $row->get( 'userid', 0, GetterInterface::INT ) ) {
									echo CBTxt::T( 'POSTED_ON_YOUR_WALL', 'posted on your <a href="[url]">wall</a>', array( '[url]' => $url ) );
								} else {
									echo CBTxt::T( 'POSTED_ON_USER_WALL', 'posted on [user] <a href="[url]">wall</a>', array( '[url]' => $url, '[user]' => $cbUserOwner->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) ) );
								}
								break;
						}
						?>
					</div>
					<div class="text-muted pbModuleRowDate">
						<?php echo cbFormatDate( $row->get( 'date', null, GetterInterface::STRING ), true, 'timeago' ); ?>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
	</div>
</div>