<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Gallery\CBGallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class plgContentcbgallerybot extends JPlugin
{

	/**
	 * Loads and returns cb gallery plugin
	 *
	 * @return bool|PluginTable
	 */
	private function loadGallery()
	{
		global $_PLUGINS;

		static $plugin		=	null;

		if ( $plugin === null ) {
			if ( ( ! file_exists( JPATH_SITE . '/libraries/CBLib/CBLib/Core/CBLib.php' ) ) || ( ! file_exists( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' ) ) ) {
				$plugin		=	false;

				return true;
			}

			include_once( JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php' );

			cbimport( 'cb.html' );
			cbimport( 'language.front' );

			$_PLUGINS->loadPluginGroup( 'user' );

			$plugin			=	$_PLUGINS->getLoadedPlugin( 'user', 'cbgallery' );

			outputCbJs();
			outputCbTemplate();
		}

		return $plugin;
	}

	/**
	 * @param string $context The context of the content being passed to the plugin.
	 * @param mixed  &$row    An object with a "text" property
	 * @param mixed  $params  Additional parameters. See {@see PlgContentContent()}.
	 * @param int    $page    Optional page number. Unused. Defaults to zero.
	 *
	 * @return mixed
	 */
	public function onContentAfterDisplay( $context, &$row, &$params, $page = 0 )
	{
		global $_CB_framework;

		if ( ( $context === 'com_finder.indexer' ) || ( ! $this->params->get( 'gallery' ) ) ) {
			return null;
		}

		$contexts					=	$this->params->get( 'include_context', 'com_content.article' );

		if ( ! $contexts ) {
			$contexts				=	'com_content.article';
		}

		$contexts					=	explode( ',', $contexts );
		$contextAllowed				=	false;

		foreach ( $contexts as $includeContext ) {
			if ( strpos( $context, $includeContext ) !== false ) {
				$contextAllowed		=	true;
			}
		}

		if ( ! $contextAllowed ) {
			return null;
		}

		$categoryId					=	( isset( $row->catid ) ? (int) $row->catid : 0 );
		$articleId					=	( isset( $row->id ) ? (int) $row->id : 0 );
		$authorId					=	( isset( $row->created_by ) ? (int) $row->created_by : 0 );

		$excludeCategories			=	$this->params->get( 'exclude_categories' );

		if ( $excludeCategories ) {
			$excludeCategories		=	explode( ',', $excludeCategories );

			if ( in_array( $categoryId, $excludeCategories, true ) ) {
				return null;
			}
		}

		$excludeArticles			=	$this->params->get( 'exclude_articles' );

		if ( $excludeArticles ) {
			$excludeArticles		=	explode( ',', $excludeArticles );

			if ( in_array( $articleId, $excludeArticles, true ) ) {
				return null;
			}
		}

		$excludeAuthors				=	$this->params->get( 'exclude_authors' );

		if ( $excludeAuthors ) {
			$excludeAuthors			=	explode( ',', $excludeAuthors );

			if ( in_array( $authorId, $excludeAuthors, true ) ) {
				return null;
			}
		}

		$plugin						=	$this->loadGallery();

		if ( ! $plugin ) {
			return null;
		}

		$asset						=	$this->params->get( 'asset' );

		if ( ! $asset ) {
			$asset					=	'article.' . $articleId;
		}

		$asset						=	str_replace( array( '[category_id]', '[article_id]', '[page_id]' ), array( $categoryId, $articleId, (int) $_CB_framework->itemid() ), $asset );

		$gallery					=	new Gallery( $asset, $authorId );

		$gallery->set( 'content.context', $context );
		$gallery->set( 'content.article', $articleId );
		$gallery->set( 'content.author', $authorId );
		$gallery->set( 'location', 'current' );

		$gallery->parse( $this->params->toArray(), 'gallery_' );

		if ( ( ! $gallery->folders( 'count' ) ) && ( ! $gallery->items( 'count' ) ) && ( ! CBGallery::canCreateFolders( $gallery ) ) && ( ! CBGallery::canCreateItems( 'all', 'both', $gallery ) ) ) {
			return null;
		}

		$return						=	'<div class="cb_template cb_template_' . selectTemplate( 'dir' ) . '">'
									.		$gallery->gallery()
									.	'</div>';

		return $return;
	}

	/**
	 * @param string $context The context of the content being passed to the plugin.
	 * @param mixed  &$row    An object with a "text" property
	 * @param mixed  $params  Additional parameters. See {@see PlgContentContent()}.
	 * @param int    $page    Optional page number. Unused. Defaults to zero.
	 *
	 * @return bool
	 */
	public function onContentPrepare( $context, &$row, &$params, $page = 0 )
	{
		if ( ( $context === 'com_finder.indexer' ) || ( ! isset( $row->text ) ) ) {
			return true;
		}

		$ignore			=	$this->params->get( 'ignore_context' );

		if ( $ignore ) {
			$ignore		=	explode( ',', $ignore );

			foreach ( $ignore as $ignoreContext ) {
				if ( strpos( $context, $ignoreContext ) !== false ) {
					return true;
				}
			}
		}

		if ( strpos( $row->text, '[cbgallery:' ) === false ) {
			return true;
		}

		$plugin			=	$this->loadGallery();

		if ( ! $plugin ) {
			return true;
		}

		$row->text		=	$this->substituteText( $row->text, $context, $row, $plugin );

		return true;
	}

	/**
	 * @param string      $text
	 * @param string      $context
	 * @param mixed       $row
	 * @param PluginTable $plugin
	 * @return mixed
	 */
	private function substituteText( $text, $context, $row, $plugin )
	{
		global $_CB_framework;

		$ignore		=	array();
		$ignoreId	=	0;
		$galleryId	=	0;

		$text		=	preg_replace_callback( '%\[cbgallery:ignore\](.*?)\[/cbgallery:ignore\]%si', function( array $matches ) use ( &$ignore, &$ignoreId )
							{
								$ignoreId++;

								$ignore[$ignoreId]		=	$matches[1];

								return '[cbgallery:ignored ' . $ignoreId . ']';
							},
							$text );

		$text		=	preg_replace_callback( '%\[cbgallery:(gallery|item|url)((?: [a-zA-Z_-]+=(?:"|&quot;)(?:(?!&quot;)[^"])+(?:"|&quot;))*) */\]%i', function( array $matches ) use ( $_CB_framework, &$galleryId, $context, $row, $plugin )
							{
								$galleryId++;

								$params							=	new Registry();

								if ( preg_match_all( '/(?:([a-zA-Z-_]+)=(?:"|&quot;)((?:(?!&quot;)[^"])+)(?:"|&quot;))+/i', $matches[2], $options, PREG_SET_ORDER ) ) {
									foreach( $options as $option ) {
										$k						=	( isset( $option[1] ) ? $option[1] : null );
										$v						=	( isset( $option[2] ) ? $option[2] : null );

										if ( $k ) {
											if ( is_numeric( $v ) ) {
												$v				=	(int) $v;
											} elseif ( $v === 'true' ) {
												$v				=	true;
											} elseif ( $v === 'false' ) {
												$v				=	false;
											}

											$params->set( $k, $v );
										}
									}
								}

								$asset							=	$params->getString( 'asset' );
								$itemId							=	$params->getInt( 'item', 0 );

								if ( $matches[1] === 'item' ) {
									if ( ! $itemId ) {
										$itemId					=	$params->getInt( 'id', 0 );
									}

									if ( ( ! $asset ) && $itemId ) {
										$asset					=	CBGallery::getAsset( 'item', $itemId );
									}
								}

								$articleId						=	0;
								$authorId						=	0;

								if ( strpos( $context, 'com_content' ) !== false ) {
									$articleId					=	( isset( $row->id ) ? (int) $row->id : 0 );
									$authorId					=	( isset( $row->created_by ) ? (int) $row->created_by : 0 );

									if ( $articleId && ( ! $asset ) ) {
										$asset					=	'article.' . $articleId;

										if ( ! $params->has( 'folders_paging' ) ) {
											$params->set( 'folders_paging', false );
										}

										if ( ! $params->has( 'folders_paging_limit' ) ) {
											$params->set( 'folders_paging_limit', 0 );
										}

										if ( ! $params->has( 'folders_search' ) ) {
											$params->set( 'folders_search', false );
										}

										if ( ! $params->has( 'items_paging' ) ) {
											$params->set( 'items_paging', false );
										}

										if ( ! $params->has( 'items_paging_limit' ) ) {
											$params->set( 'items_paging_limit', 0 );
										}

										if ( ! $params->has( 'items_search' ) ) {
											$params->set( 'items_search', false );
										}
									}
								}

								$asset							=	str_replace( '[article_id]', $articleId, $asset );

								$gallery						=	new Gallery( $asset, ( ! $authorId ? null : $authorId ) );

								$gallery->set( 'content.id', $galleryId );
								$gallery->set( 'content.context', $context );

								if ( strpos( $context, 'com_content' ) !== false ) {
									$gallery->set( 'content.article', $articleId );
									$gallery->set( 'content.author', $authorId );
								}

								$gallery->set( 'location', 'current' );

								if ( $itemId ) {
									if ( ! $params->has( 'folders' ) ) {
										$params->set( 'folders', false );
									}

									if ( ! $params->has( 'items_create' ) ) {
										$params->set( 'items_create', false );
									}

									if ( ! $params->has( 'items_paging' ) ) {
										$params->set( 'items_paging', false );
									}

									if ( ! $params->has( 'items_paging_limit' ) ) {
										$params->set( 'items_paging_limit', 0 );
									}

									if ( ! $params->has( 'items_search' ) ) {
										$params->set( 'items_search', false );
									}

									$gallery->set( 'id', $itemId );
								}

								$folderId						=	$params->getInt( 'folder', 0 );

								if ( $folderId ) {
									$gallery->set( 'folder', $folderId );
								}

								$gallery->parse( $params );

								$return							=	null;

								switch ( $matches[1] ) {
									case 'url':
										$gallery->cache();

										$view					=	$params->getString( 'view' );

										if ( ! $view ) {
											if ( $gallery->getInt( 'folder', 0 ) ) {
												$view			=	'folder';
											} elseif ( $gallery->getInt( 'id', 0 ) ) {
												$view			=	'item';
											}
										}

										switch ( $view ) {
											case 'folder':
												$return			=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'folder', 'id' => $gallery->getInt( 'folder', 0 ), 'gallery' => $gallery->id(), 'return' => CBGallery::getReturn() ) );
												break;
											case 'item':
												$return			=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'item', 'id' => $gallery->getInt( 'id', 0 ), 'gallery' => $gallery->id() ) );
												break;
											case 'new':
												if ( $gallery->getInt( 'folder', 0 ) ) {
													$return		=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'items', 'func' => 'new', 'folder' => $gallery->getInt( 'folder', 0 ), 'gallery' => $gallery->id(), 'return' => CBGallery::getReturn() ) );
												} else {
													$return		=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'items', 'func' => 'new', 'gallery' => $gallery->id(), 'return' => CBGallery::getReturn() ) );
												}
												break;
											case 'gallery':
											default:
												$return			=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'gallery' => $gallery->id() ) );
												break;
										}
										break;
									case 'item':
										if ( $gallery->getInt( 'id', 0 ) ) {
											$return				=	'<span class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbGalleryContentEmbed">'
																.		$gallery->gallery( 'item.embed', $gallery->getInt( 'id', 0 ) )
																.	'</span>';
										}
										break;
									case 'gallery':
									default:
										if ( ( ! $gallery->folders( 'count' ) ) && ( ! $gallery->items( 'count' ) ) && ( ! CBGallery::canCreateFolders( $gallery ) ) && ( ! CBGallery::canCreateItems( 'all', 'both', $gallery ) ) ) {
											return null;
										}

										$return					=	'<div class="cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbGalleryContentGallery">'
																.		$gallery->gallery()
																.	'</div>';
										break;
								}

								return $return;
							},
							$text );

		foreach ( $ignore as $id => $ignored ) {
			$text	=	str_replace( '[cbgallery:ignored ' . (int) $id . ']', $ignored, $text );
		}

		return $text;
	}
}