<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Activity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable     $row
 * @var UserTable         $viewer
 * @var Activity          $stream
 * @var CBplug_cbactivity $this
 *
 * @var array             $form
 * @var string            $rowId
 * @var int               $links
 * @var int               $tagged
 */

$menu			=	array();

if ( $form['themes'] ) {
	$menu[]		=	$form['themes'];
}

if ( $form['actions'] ) {
	$menu[]		=	$form['actions'];
}

if ( $form['locations'] ) {
	$menu[]		=	$form['locations'];
}

if ( $form['tags'] ) {
	$menu[]		=	'<button type="button" class="btn btn-sm ' . ( $tagged ? 'btn-info streamToggleOpen' : 'btn-light border' ) . ' streamToggle streamInputTag" data-cbactivity-toggle-target=".streamInputTagContainer" data-cbactivity-toggle-active-classes="btn-info" data-cbactivity-toggle-inactive-classes="btn-light border"' . $form['tags_tooltip'] . '><span class="fa fa-user"></span></button>';
}

if ( $form['links'] ) {
	$menu[]		=	'<button type="button" class="btn btn-sm ' . ( $links ? 'btn-info streamToggleOpen' : 'btn-light border' ) . ' streamToggle streamInputLink" data-cbactivity-toggle-target=".streamInputLinkContainer" data-cbactivity-toggle-active-classes="btn-info" data-cbactivity-toggle-inactive-classes="btn-light border"' . $form['links_tooltip'] . '><span class="fa fa-link"></span></button>';
}
?>
<div class="activityContainer activityContainerEdit">
	<form action="<?php echo $form['url']; ?>" method="post" enctype="multipart/form-data" name="streamItemForm<?php echo $rowId; ?>" class="m-0 streamItemForm streamItemEdit" onsubmit="event.preventDefault()">
		<div class="card-body p-0 streamPanelBody activityContainerContent">
			<div class="position-relative cb_form_line streamItemInputGroup streamInputMessageContainer<?php echo $form['themes_classes']; ?>"<?php echo $form['themes_styles']; ?>>
				<?php echo $form['message']; ?>
				<?php if ( $form['message_limit'] || $form['emotes'] || $form['reactions'] ) { ?>
				<div class="position-absolute text-right streamInputMessageActions">
					<?php if ( $form['reactions'] ) { ?>
					<div class="d-inline-block streamInputMessageReaction">
						<?php echo $form['reactions']; ?>
					</div>
					<?php } ?>
					<?php if ( $form['emotes'] ) { ?>
					<div class="d-inline-block streamInputMessageEmote">
						<?php echo $form['emotes']; ?>
					</div>
					<?php } ?>
					<?php if ( $form['message_limit'] ) { ?>
					<div class="d-inline-block badge badge-secondary font-weight-normal streamInputMessageLimit">
						<span class="streamInputMessageLimitCurrent"><?php echo cbutf8_strlen( $row->getString( 'message' ) ); ?></span> / <span class="streamInputMessageLimitMax"><?php echo (int) $form['message_limit']; ?></span>
					</div>
					<?php } ?>
				</div>
				<?php } ?>
			</div>
			<?php if ( $form['links'] ) { ?>
				<?php if ( $links ) { ?>
				<div class="p-2 border-top cb_form_line streamItemInputGroup streamInputAttachmentsContainer">
					<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'attachments/edit', false ); ?>
				</div>
				<?php } ?>
				<?php if ( ( ! $form['links_limit'] ) || ( $form['links_limit'] > 1 ) ) { ?>
				<div class="cb_form_line streamItemInputGroup streamInputLinkContainer cbRepeat<?php echo ( ! $links ? ' hidden' : null ); ?>" data-cbrepeat-sortable="false"<?php echo ( $form['links_limit'] ? ' data-cbrepeat-max="' . (int) $form['links_limit'] . '"' : null ); ?>>
					<?php foreach ( $form['links'] as $link ) { ?>
					<div class="d-flex border-top streamItemInputGroupRow cbRepeatRow">
						<div class="col-form-label flex-shrink-1 p-2 border-right streamItemInputGroupLabel">
							<a href="javascript: void(0);" class="d-block p-1 pl-2 pr-2 rounded border-success bg-success text-white cbRepeatRowAdd"><span class="fa fa-plus"></span></a>
						</div>
						<div class="flex-grow-1 streamItemInputGroupInput">
							<?php echo $link; ?>
						</div>
						<div class="d-flex flex-column justify-content-center flex-shrink-1 pl-1 pr-1 streamItemInputGroupAddon">
							<a href="javascript: void(0);" class="d-block p-1 pl-2 pr-2 rounded border-danger bg-danger text-white cbRepeatRowRemove"><span class="fa fa-minus"></span></a>
						</div>
					</div>
					<?php } ?>
				</div>
				<?php } else { ?>
				<div class="border-top cb_form_line streamItemInputGroup streamInputLinkContainer<?php echo ( ! $links ? ' hidden' : null ); ?>">
					<?php echo $form['links'][0]; ?>
				</div>
				<?php } ?>
			<?php } ?>
			<?php if ( $form['actions'] ) { ?>
			<div class="border-top d-flex cb_form_line streamItemInputGroup streamInputActionContainer<?php echo ( ! $row->params()->subTree( 'action' )->getInt( 'id', 0 ) ? ' hidden' : null ); ?>">
				<div class="d-none d-sm-block col-form-label flex-shrink-1 p-2 border-right font-weight-bold streamItemInputGroupLabel streamInputSelectToggleLabel"></div>
				<div class="flex-grow-1 streamItemInputGroupInput">
					<?php echo $form['actions_message']; ?>
				</div>
				<?php if ( $form['actions_emotes'] ) { ?>
				<div class="d-flex flex-column justify-content-center flex-shrink-1 p-2 streamItemInputGroupAddon">
					<?php echo $form['actions_emotes']; ?>
				</div>
				<?php } ?>
			</div>
			<?php } ?>
			<?php if ( $form['locations'] ) { ?>
			<div class="border-top d-flex cb_form_line streamItemInputGroup streamInputLocationContainer<?php echo ( ! $row->params()->subTree( 'location' )->getInt( 'id', 0 ) ? ' hidden' : null ); ?>">
				<div class="d-none d-sm-block col-form-label flex-shrink-1 p-2 border-right font-weight-bold streamItemInputGroupLabel streamInputSelectToggleLabel"></div>
				<div class="flex-grow-1 streamItemInputGroupInput">
					<div class="streamInputLocationContainerPlace">
						<?php echo $form['locations_place']; ?>
					</div>
					<div class="streamInputLocationContainerAddress">
						<?php echo $form['locations_addr']; ?>
					</div>
				</div>
				<?php if ( CBActivity::isHTTPS() ) { ?>
				<div class="d-flex flex-column justify-content-center flex-shrink-1 p-2 streamItemInputGroupAddon">
					<span class="fa fa-map-marker fa-lg streamFindLocation" data-cbactivity-location-target=".streamInputLocationAddress" data-cbactivity-location-error="<?php echo htmlspecialchars( CBTxt::T( 'Sorry, unable to find your location.' ) ); ?>"<?php echo $form['locations_tooltip']; ?>></span>
				</div>
				<?php } ?>
			</div>
			<?php } ?>
			<?php if ( $form['tags'] ) { ?>
			<div class="border-top cb_form_line streamItemInputGroup streamInputTagContainer<?php echo ( ! $tagged ? ' hidden' : null ); ?>">
				<?php echo $form['tags']; ?>
			</div>
			<?php } ?>
			<?php echo implode( '', $form['integrations'] ); ?>
		</div>
		<div class="card-footer p-2 row no-gutters streamPanelFooter activityContainerFooter">
			<div class="col-12 col-sm-auto row no-gutters flex-grow-1 activityContainerFooterRowActions">
				<?php if ( $menu || $form['buttons']['left'] ) { ?>
				<div class="col-auto pr-1 activityContainerFooterRowLeft">
					<?php echo implode( ' ', $menu ); ?>
					<?php echo implode( ' ', $form['buttons']['left'] ); ?>
				</div>
				<?php } ?>
				<?php if ( $form['buttons']['right'] || $form['system'] || $form['global'] ) { ?>
				<div class="col-auto pr-1 flex-grow-1 text-sm-right activityContainerFooterRowRight">
					<?php echo implode( ' ', $form['buttons']['right'] ); ?>
					<?php if ( $form['system'] ) { ?>
					<span class="btn btn-sm <?php echo ( $row->getBool( 'system', false ) ? 'btn-info streamToggleOpen' : 'btn-light border' ); ?> streamToggle streamInputCheckbox streamInputSystem" data-cbactivity-toggle-active-classes="btn-info" data-cbactivity-toggle-inactive-classes="btn-light border"<?php echo $form['system_tooltip']; ?>>
						<?php echo $form['system']; ?>
					</span>
					<?php } ?>
					<?php if ( $form['global'] ) { ?>
					<span class="btn btn-sm <?php echo ( $row->getBool( 'global', false ) ? 'btn-info streamToggleOpen' : 'btn-light border' ); ?> streamToggle streamInputCheckbox streamInputGlobal" data-cbactivity-toggle-active-classes="btn-info" data-cbactivity-toggle-inactive-classes="btn-light border"<?php echo $form['global_tooltip']; ?>>
						<?php echo $form['global']; ?>
					</span>
					<?php } ?>
				</div>
				<?php } ?>
			</div>
			<div class="col-12 col-sm-auto mt-2 mt-sm-0 text-sm-right activityContainerFooterRowButtons">
				<button type="submit" class="btn btn-primary btn-sm btn-sm-block activityButton activityButtonEditSave streamItemEditSave"><?php echo CBTxt::T( 'Done Editing' ); ?></button>
				<button type="button" class="btn btn-secondary btn-sm btn-sm-block activityButton activityButtonEditCancel streamItemEditCancel streamItemActionResponsesRevert"><?php echo CBTxt::T( 'Cancel' ); ?></button>
			</div>
		</div>
	</form>
	<?php echo CBActivity::reloadHeaders(); ?>
</div>