<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CB\Plugin\Activity\CBActivity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend blog activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */

global $_CB_framework;

$notification			=	( $stream instanceof NotificationsInterface );
$id						=	(int) $matches[1];
$type					=	( isset( $matches[2] ) ? $matches[2] : null );

switch ( $type ) {
	case 'comment':
		if ( $notification ) {
			$title		=	CBTxt::T( 'COMMENTED_ON_BLOG_TITLE', 'commented on blog <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->pluginClassUrl( 'cbblogs', true, array( 'action' => 'blogs', 'func' => 'show', 'id' => $id ) ), '[title]' => '#' . $id ) );
		} else {
			$title		=	CBTxt::T( 'commented on blog' );
		}
		break;
	case 'like':
		if ( $notification ) {
			$title		=	CBTxt::T( 'LIKED_BLOG_TITLE', 'liked blog <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->pluginClassUrl( 'cbblogs', true, array( 'action' => 'blogs', 'func' => 'show', 'id' => $id ) ), '[title]' => '#' . $id ) );
		} else {
			$title		=	CBTxt::T( 'liked blog' );
		}
		break;
	default:
		if ( $notification ) {
			$title		=	CBTxt::T( 'PUBLISHED_BLOG_TITLE', 'published article <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->pluginClassUrl( 'cbblogs', true, array( 'action' => 'blogs', 'func' => 'show', 'id' => $id ) ), '[title]' => '#' . $id ) );
		} else {
			$title		=	CBTxt::T( 'published a new blog' );
		}
		break;
}

if ( $notification ) {
	$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbblogs', false, array( 'action' => 'blogs', 'func' => 'show', 'id' => $id ) ) );
}

/** @var cbblogsBlogTable $blog */
$blog					=	$row->source();

if ( ( ! $blog ) || ( ! $blog->getInt( 'id', 0 ) ) ) {
	return;
}

if ( $notification ) {
	$row->set( 'link', cbblogsModel::getUrl( $blog, false, 'article' ) );

	$blogTitle			=	$blog->getString( 'title' );

	if ( ! $blogTitle ) {
		$blogTitle		=	$blog->getString( 'blog_intro' );
	}

	if ( cbutf8_strlen( $blogTitle ) > 50 ) {
		$blogTitle		=	trim( cbutf8_substr( $blogTitle, 0, 50 ) ) . '...';
	}

	if ( $blogTitle ) {
		switch ( $type ) {
			case 'comment':
				$title	=	CBTxt::T( 'COMMENTED_ON_BLOG_TITLE', 'commented on blog <a href="[url]">[title]</a>', array( '[url]' => cbblogsModel::getUrl( $blog, true, 'article' ), '[title]' => $blogTitle ) );
				break;
			case 'like':
				$title	=	CBTxt::T( 'LIKED_BLOG_TITLE', 'liked blog <a href="[url]">[title]</a>', array( '[url]' => cbblogsModel::getUrl( $blog, true, 'article' ), '[title]' => $blogTitle ) );
				break;
			default:
				$title	=	CBTxt::T( 'PUBLISHED_BLOG_TITLE', 'published blog <a href="[url]">[title]</a>', array( '[url]' => cbblogsModel::getUrl( $blog, true, 'article' ), '[title]' => $blogTitle ) );
				break;
		}
	}
} else {
	$insert				=	'<div class="bg-light border p-2 cbBlogsActivity cbMoreLess">'
						.		'<div class="streamItemContent cbMoreLessContent">'
						.			'<div><strong><a href="' . cbblogsModel::getUrl( $blog, true, 'article' ) . '">' . $blog->getString( 'title' ) . '</a></strong></div>'
						.			( CBActivity::getCBBlogs()->type === 2 ? $blog->getHtml( 'blog_intro' ) : Application::Cms()->prepareHtmlContentPlugins( $blog->getHtml( 'blog_intro' ) ) )
						.		'</div>'
						.		'<div class="fade-edge cbMoreLessOpen hidden">'
						.			'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'Read More...' ) . '</a>'
						.		'</div>'
						.	'</div>';

	if ( $type ) {
		$row->params()->set( 'overrides.tags_asset', 'article.' . $id );
		$row->params()->set( 'overrides.likes_asset', 'article.' . $id );
		$row->params()->set( 'overrides.comments_asset', 'article.' . $id );
	} else {
		$row->params()->set( 'overrides.tags_asset', 'asset' );
		$row->params()->set( 'overrides.likes_asset', 'asset' );
		$row->params()->set( 'overrides.comments_asset', 'asset' );
	}
}