<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend logout activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */

global $_CB_framework;

$notification	=	( $stream instanceof NotificationsInterface );

if ( $notification ) {
	$row->set( 'link', $_CB_framework->userProfileUrl( (int) $matches[1], false ) );
}

$title			=	CBTxt::T( 'has logged out' );

if ( $notification && ( $row instanceof ActivityTable ) ) {
	$title		=	CBTxt::T( 'logged out' );
}