<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\TagTable;
use CB\Plugin\Activity\Tags;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var TagTable[]        $rows
 * @var cbPageNav         $pageNav
 * @var UserTable         $viewer
 * @var Tags              $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var array             $integrations
 * @var int               $count
 */
?>
<div class="<?php echo ( $output === 'modal' ? 'p-2 ' : null ); ?>tagsStream streamBind streamContainer stream<?php echo htmlspecialchars( $stream->id() ); ?>" data-cbactivity-stream="<?php echo htmlspecialchars( $stream->id() ); ?>">
	<?php echo implode( '', $integrations ); ?>
	<?php if ( $output !== 'modal' ) { ?>
	<div class="row no-gutters mb-2 tagsStreamToolbar streamToolbar">
		<?php if ( $stream->getBool( 'count', true ) ) { ?>
		<div class="col-6"><span class="badge badge-light border font-weight-normal tagsStreamCount streamCount"><?php echo CBTxt::T( 'TAGGED_COUNT', '[tagged] Tag|[tagged] Tagged|%%COUNT%%', array( '%%COUNT%%' => $pageNav->total, '[tagged]' => CBActivity::getFormattedTotal( $pageNav->total ) ) ); ?></span></div>
		<?php } ?>
	</div>
	<?php } ?>
	<div class="row no-gutters tagsStreamItems streamItems">
		<?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'tags/rows', false ); ?>
	</div>
	<?php if ( $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block mt-2 tagsButton tagsButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayTagsStream', array( $rows, $pageNav, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( $output === 'modal' ? CBActivity::reloadHeaders() : null ); ?>
</div>