<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var array      $fieldGroups
 * @var array      $rows
 * @var array      $rowsTitles
 * @var array      $rowsDescriptions
 * @var array      $rowsFields
 *
 * @var FieldTable $field
 * @var UserTable  $user
 * @var string     $output
 * @var string     $reason
 * @var int        $list_compare_types
 */

if ( ! $rows ) {
	return;
}
?>
<div class="form-group mb-0 table-responsive cbFieldGroup cbFieldGroupTable">
	<table class="m-0 table<?php echo ( $reason == 'list' ? ' table-sm' : '' ); ?> table-bordered">
		<thead>
			<tr class="cbFieldGroupHeader">
				<th class="text-center">#</th>
				<th><?php echo implode( '</th><th>', $rowsTitles[0] ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php echo implode( '', $rows ); ?>
		</tbody>
	</table>
</div>
