<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Plugin\Privacy\CBPrivacy;
use CB\Plugin\Privacy\Privacy;
use CBLib\Registry\GetterInterface;
use CB\Plugin\Privacy\Table\PrivacyTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var CBplug_cbprivacy $this
 * @var PrivacyTable[]   $rows
 * @var array            $selected
 * @var string           $ajaxUrl
 * @var string           $usersUrl
 * @var UserTable        $viewer
 * @var Privacy          $privacy
 */

global $_CB_framework;

include_once CBPrivacy::getTemplate( $privacy->getString( 'template', '' ), 'edit_jquery', false );

$name					=	$privacy->name();

if ( ! $name ) {
	$name				=	md5( 'privacy_' . $privacy->asset() );
}

if ( ! $selected ) {
	$selected			=	explode( '|*|', $privacy->getString( 'options_default', '0' ) );
}

$selected				=	$this->input( $name, $selected, GetterInterface::RAW );
$layout					=	$privacy->getString( 'layout', 'button' );

switch ( $layout ) {
	case 'tags':
		$layoutClass	=	'cbPrivacySelectTags form-control';
		break;
	case 'icon':
		$layoutClass	=	'cbPrivacySelectIcon';
		break;
	case 'button':
	default:
		$layoutClass	=	'cbPrivacySelectButton btn btn-sm btn-light border';
		break;
}

$attributes				=	null;

if ( $ajaxUrl ) {
	$attributes			.=	' data-cbprivacy-ajax="' . $ajaxUrl . '"';
}

if ( $usersUrl ) {
	$attributes			.=	' data-cbprivacy-users="' . $usersUrl . '"';
}

$controls				=	moscomprofilerHTML::selectList( $privacy->rules(), $name . '[]', 'class="cbPrivacySelect ' . htmlspecialchars( $layoutClass ) . '" multiple="multiple" data-cbprivacy-layout="' . htmlspecialchars( $layout ) . '" data-cbselect-dropdown-css-class="cbPrivacySelectOptions"' . $attributes, 'value', 'text', $selected, 0, false, false, false );

if ( ! $privacy->name() ) {
	echo str_replace( $name . '__', md5( $privacy->id() . '_privacy_' . rand() ), $controls );
} else {
	echo $controls;
}
