<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveWall;

use CB\Plugin\GroupJiveWall\Table\WallTable;

defined('CBLIB') or die();

class CBGroupJiveWall
{
	/** @var WallTable[]  */
	private static $postCache	=	array();

	/**
	 * Caches a prefetched array of videos for reuse
	 *
	 * @param WallTable[] $posts
	 */
	public static function prefetchPosts( $posts )
	{
		foreach ( $posts as $post ) {
			$rowId						=	$post->getInt( 'id', 0 );

			if ( ! $rowId ) {
				continue;
			}

			self::$postCache[$rowId]	=	$post;
		}
	}

	/**
	 * returns a cached post object
	 *
	 * @param int $id
	 * @return WallTable
	 */
	public static function getPost( $id )
	{
		if ( ! $id ) {
			return new WallTable();
		}

		if ( ! isset( self::$postCache[$id] ) ) {
			$row					=	new WallTable();

			$row->load( (int) $id );

			self::$postCache[$id]	=	$row;
		}

		return self::$postCache[$id];
	}

	/**
	 * Checks if there's too many posts to be using xml based parent selection
	 * Note this is for XML purposes only
	 *
	 * @return bool
	 */
	public static function checkTooManyPosts()
	{
		global $_CB_database;

		static $cache	=	null;

		if ( $cache === null ) {
			$query		=	'SELECT ' . $_CB_database->NameQuote( 'id' )
						.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_wall' );
			$_CB_database->setQuery( $query, 0, 101 );
			$cache		=	count( $_CB_database->loadResultArray() );
		}

		return ( $cache > 100 );
	}
}