<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2015 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\ProfileBook\Table\EntryTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\GetterInterface;
use CB\Plugin\ProfileBook\CBProfileBook;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var bool         $isOwner
 * @var bool         $isModerator
 * @var UserTable    $user
 * @var UserTable    $viewer
 * @var TabTable     $tab
 * @var EntryTable[] $rows
 * @var cbPageNav    $pageNav
 */

global $_CB_framework, $_PLUGINS;

initToolTip();

$js		=	"$( '.pbBlogRowIntro.col-md-6' ).on( 'click', function() {"
		.		"$( this ).removeClass( 'col-md-6' );"
		.		"$( this ).find( '.cbMoreLessClosed .cbMoreLessButton' ).click();"
		.	"});"
		.	"$( '.pbBlog .cbMoreLess' ).cbmoreless();";

$_CB_framework->outputCbJQuery( $js, 'cbmoreless' );

$i		=	0;
?>
<div class="pbBlog">
	<?php echo implode( '', $_PLUGINS->trigger( 'pb_onBeforeDisplayBlog', array( &$rows, &$pageNav, $viewer, $user, $tab ) ) ); ?>
	<?php if ( $isOwner || $isModerator ) { ?>
	<div class="mb-3 pbBlogHeader">
		<button type="button" onclick="window.location.href='<?php echo $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'entry', 'func' => 'new', 'mode' => 'b', 'userid' => $user->get( 'id', 0, GetterInterface::INT ) ) ); ?>';" class="btn btn-success btn-sm-block pbButton pbButtonNew"><span class="fa fa-plus-circle"></span> <?php echo CBTxt::T( 'Create New Blog' ); ?></button>
	</div>
	<?php } ?>
	<?php if ( $rows ) { ?>
	<div class="ml-n2 mr-n2 mb-n3 row no-gutters pbBlogRows">
		<?php
		foreach ( $rows as $row ) {
			$_PLUGINS->trigger( 'pb_onDisplayBlog', array( &$row, $viewer, $user, $tab ) );

			$i++;

			$menu					=	null;

			if ( $isModerator || $isOwner ) {
				$menuItems			=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 pbBlogMenuItems">'
									.		'<li class="pbBlogMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'edit', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

				if ( $row->get( 'published' ) == 1 ) {
					$menuItems		.=		'<li class="pbBlogMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this blog?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'unpublish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
				} else {
					$menuItems		.=		'<li class="pbBlogMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'publish', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
				}

				$menuItems			.=		'<li class="pbBlogMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this blog?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'func' => 'delete', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>'
									.	'</ul>';

				$menu				=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm pbBlogMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );
			}
		?>
		<div class="col-12 pb-3 pl-2 pr-2<?php echo ( $i == 1 ? ' pbBlogRow pbBlogRowFeatured' : ' col-md-6 pbBlogRow pbBlogRowIntro' ); ?>">
			<div class="h-100 card">
				<div class="card-body p-2 pbBlogRowContainer">
					<div class="pbBlogRowHeader">
						<div class="text-center<?php echo ( $i == 1 ? ' text-large' : null ); ?> pbBlogRowTitle">
							<strong><a href="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'entry', 'id' => $row->get( 'id', 0, GetterInterface::INT ) ) ); ?>"><?php echo $row->get( 'postertitle', null, GetterInterface::STRING ); ?></a></strong>
						</div>
						<div class="text-center text-small text-muted pbBlogRowDate">
							<?php echo cbFormatDate( $row->get( 'date', null, GetterInterface::STRING ), true, false, CBTxt::T( 'PROFILEBLOG_DATE_FORMAT', 'M j, Y' ) ); ?>
							<?php if ( $row->get( 'editdate', null, GetterInterface::STRING ) && ( $row->get( 'editdate', null, GetterInterface::STRING ) != '0000-00-00 00:00:00' ) ) { ?>
								<span class="fa fa-edit pbBlogRowNewEdited" title="<?php echo htmlspecialchars( cbFormatDate( $row->get( 'editdate', null, GetterInterface::STRING ) ) ); ?>"></span>
							<?php } ?>
						</div>
					</div>
					<div class="pbBlogRowBlog cbMoreLess">
						<div class="cbMoreLessContent">
							<?php echo CBProfileBook::parseMessage( $row->get( 'postercomment', null, GetterInterface::HTML ), $tab ); ?>
						</div>
						<div class="fade-edge cbMoreLessOpen hidden">
							<a href="javascript: void(0);" class="pl-1 cbMoreLessButton"><?php echo CBTxt::T( 'Read More' ); ?></a>
						</div>
					</div>
				</div>
				<?php if ( $menu ) { ?>
				<div class="p-1 pbBlogMenu">
					<button type="button" <?php echo $menu; ?>><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>
				</div>
				<?php } ?>
			</div>
		</div>
		<?php } ?>
	</div>
	<?php } else { ?>
	<div class="pbBlogRow pbBlogEmpty">
		<?php echo ( $isOwner ? CBTxt::T( 'You currently have no blogs.' ) : CBTxt::T( 'This user currently has no blogs.' ) ); ?>
	</div>
	<?php } ?>
	<?php if ( $tab->params->get( 'pbPagingEngabbled', true, GetterInterface::BOOLEAN ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="text-center mt-3 pbBlogPaging">
		<?php echo $pageNav->getListLinks(); ?>
	</div>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'pb_onAfterDisplayBlog', array( $rows, $pageNav, $viewer, $user, $tab ) ) ); ?>
</div>