<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework, $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/Conditional/(.+)%i', __DIR__ . '/library/$1.php' );

$_CB_framework->addJQueryPlugin( 'cbcondition', '/components/com_comprofiler/plugin/user/plug_cbconditional/js/cbcondition.js' );

$_PLUGINS->loadPluginGroup( 'user' );

$_PLUGINS->registerFunction( 'onBeforeDisplayUsersList', 'listDisplay', '\CB\Plugin\Conditional\Trigger\UserlistTrigger' );

$_PLUGINS->registerFunction( 'onAfterPrepareViewTabs', 'tabsDisplay', '\CB\Plugin\Conditional\Trigger\TabTrigger' );
$_PLUGINS->registerFunction( 'onAfterEditATab', 'tabEdit', '\CB\Plugin\Conditional\Trigger\TabTrigger' );
$_PLUGINS->registerFunction( 'onAfterTabsFetch', 'tabsFetch', '\CB\Plugin\Conditional\Trigger\TabTrigger' );

$_PLUGINS->registerFunction( 'fieldgroups_onAfterFieldsFetch', 'fieldGroupsFieldsFetch', '\CB\Plugin\Conditional\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onAfterFieldsFetch', 'fieldsFetch', '\CB\Plugin\Conditional\Trigger\FieldTrigger' );
$_PLUGINS->registerFunction( 'onBeforegetFieldRow', 'fieldDisplay', '\CB\Plugin\Conditional\Trigger\FieldTrigger' );