<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * render frontend forum activity
 *
 * @var ActivityTable|NotificationTable $row
 * @var string                          $title
 * @var string                          $date
 * @var string                          $message
 * @var string                          $insert
 * @var string                          $footer
 * @var array                           $menu
 * @var Activity|Notifications          $stream
 * @var array                           $matches
 * @var CBplug_cbactivity               $this
 * @var string                          $output
 */

global $_CB_framework;

$notification			=	( $stream instanceof NotificationsInterface );
$id						=	(int) $matches[1];

if ( $matches[2] === 'reply' ) {
	if ( $notification ) {
		$title			=	CBTxt::T( 'REPLIED_TO_DISCUSSION_TITLE', 'replied to discussion <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_kunena&view=topic&mesid=' . $id, '[title]' => '#' . $id ) );
	} else {
		$title			=	CBTxt::T( 'replied to a discussion' );
	}
} else {
	if ( $notification ) {
		$title			=	CBTxt::T( 'STARTED_DISCUSSION_TITLE', 'started discussion <a href="[url]">[title]</a>', array( '[url]' => $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_kunena&view=topic&mesid=' . $id, '[title]' => '#' . $id ) );
	} else {
		$title			=	CBTxt::T( 'started a new discussion' );
	}
}

if ( $notification ) {
	$row->set( 'link', $_CB_framework->getCfg( 'live_site' ) . '/index.php?option=com_kunena&view=topic&mesid=' . $id );
}

/** @var KunenaForumMessage $post */
$post					=	$row->source();

if ( ( ! $post ) || ( ! $post->id ) ) {
	return;
}

if ( $notification ) {
	$row->set( 'link', cbforumsModel::getForumURL( null, $post->id ) );

	$postTitle			=	cbforumsClass::cleanPost( $post->subject );

	if ( ! $postTitle ) {
		$postTitle		=	cbforumsClass::cleanPost( $post->message );
	}

	if ( cbutf8_strlen( $postTitle ) > 50 ) {
		$postTitle		=	trim( cbutf8_substr( $postTitle, 0, 50 ) ) . '...';
	}

	if ( $postTitle ) {
		if ( $matches[2] === 'reply' ) {
			$title		=	CBTxt::T( 'REPLIED_TO_DISCUSSION_TITLE', 'replied to discussion <a href="[url]">[title]</a>', array( '[url]' => cbforumsModel::getForumURL( null, $post->id ), '[title]' => $postTitle ) );
		} else {
			$title		=	CBTxt::T( 'STARTED_DISCUSSION_TITLE', 'started discussion <a href="[url]">[title]</a>', array( '[url]' => cbforumsModel::getForumURL( null, $post->id ), '[title]' => $postTitle ) );
		}
	}
} else {
	$insert				=	'<div class="bg-light border p-2 cbForumsActivity cbMoreLess">'
						.		'<div class="streamItemContent cbMoreLessContent">'
						.			'<div><strong><a href="' . cbforumsModel::getForumURL( null, $post->id ) . '">' . cbforumsClass::cleanPost( $post->subject ) . '</a></strong></div>'
						.			cbforumsClass::cleanPost( $post->message )
						.		'</div>'
						.		'<div class="fade-edge cbMoreLessOpen hidden">'
						.			'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'Read More...' ) . '</a>'
						.		'</div>'
						.	'</div>';
}