<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Database\Table\Table;
use CB\Plugin\PMS\Table\MessageTable;
use CB\Plugin\PMS\UddeIM;
use CB\Plugin\Activity\CBActivity;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * Prepares the source objects for core/custom assets
 *
 * @var string $asset
 * @var mixed  $source
 */

global $_CB_database, $_PLUGINS;

if ( preg_match( '/^(?:(.+)\.)?article\.(\d+)/', $asset, $matches ) ) {
	$model				=	CBActivity::getCBArticles();

	if ( ! $model ) {
		return;
	}

	static $article		=	array();

	$id					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

	if ( ! isset( $article[$id] ) ) {
		if ( $model->type === 5 ) {
			$query		=	'SELECT a.*'
						.	', b.' . $_CB_database->NameQuote( 'id' ) . ' AS category'
						.	', b.' . $_CB_database->NameQuote( 'name' ) . ' AS category_title'
						.	', b.' . $_CB_database->NameQuote( 'published' ) . ' AS category_published'
						.	', b.' . $_CB_database->NameQuote( 'alias' ) . ' AS category_alias'
						.	"\n FROM " . $_CB_database->NameQuote( '#__k2_items' ) . " AS a"
						.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__k2_categories' ) . " AS b"
						.	' ON b.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'catid' )
						.	"\n WHERE a." . $_CB_database->NameQuote( 'id' ) . " = " . (int) $id;
			$_CB_database->setQuery( $query, 0, 1 );
			$details	=	$_CB_database->loadAssoc();

			$row		=	new Table( null, '#__k2_items', 'id' );
		} else {
			$query		=	'SELECT a.*'
						.	', b.' . $_CB_database->NameQuote( 'id' ) . ' AS category'
						.	', b.' . $_CB_database->NameQuote( 'title' ) . ' AS category_title'
						.	', b.' . $_CB_database->NameQuote( 'published' ) . ' AS category_published'
						.	', b.' . $_CB_database->NameQuote( 'alias' ) . ' AS category_alias'
						.	"\n FROM " . $_CB_database->NameQuote( '#__content' ) . " AS a"
						.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__categories' ) . " AS b"
						.	' ON b.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'catid' )
						.	"\n WHERE a." . $_CB_database->NameQuote( 'id' ) . " = " . (int) $id;
			$_CB_database->setQuery( $query, 0, 1 );
			$details	=	$_CB_database->loadAssoc();

			$row		=	new Table( null, '#__content', 'id' );
		}

		foreach ( $details as $k => $v ) {
			$row->set( $k, $v );
		}

		$article[$id]	=	$row;
	}

	$source				=	$article[$id];
} elseif ( preg_match( '/^(?:(.+)\.)?blog\.(\d+)/', $asset, $matches ) ) {
	$model				=	CBActivity::getCBBlogs();

	if ( ! $model ) {
		return;
	}

	static $blog		=	array();

	$id					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

	if ( ! isset( $blog[$id] ) ) {
		$row			=	new cbblogsBlogTable();

		$row->load( $id );

		$blog[$id]		=	$row;
	}

	$source				=	$blog[$id];
} elseif ( preg_match( '/^(?:(.+)\.)?page\.(\d+)/', $asset, $matches ) ) {
	static $page		=	array();

	$id					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

	if ( ! isset( $page[$id] ) ) {
		$page[$id]		=	CBActivity::getMenuItem( $id );
	}

	$source				=	$page[$id];
} elseif ( preg_match( '/^(?:(.+)\.)?kunena\.(\d+)/', $asset, $matches ) ) {
	if ( ! $_PLUGINS->getLoadedPlugin( 'user', 'cbforums' ) ) {
		return;
	}

	$model				=	cbforumsClass::getModel();

	if ( ! $model->file ) {
		return;
	}

	if ( ! class_exists( 'KunenaForumMessageHelper' ) ) {
		return;
	}

	static $post		=	array();

	$id					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

	if ( ! isset( $post[$id] ) ) {
		$post[$id]		=	KunenaForumMessageHelper::get( $id );
	}

	$source				=	$post[$id];
} elseif ( preg_match( '/^(?:(.+)\.)?pm\.(\d+)/', $asset, $matches ) ) {
	if ( ( ! $_PLUGINS->getLoadedPlugin( 'user', 'pms.mypmspro' ) ) || ( ! class_exists( '\CB\Plugin\PMS\PMSHelper' ) ) ) {
		return;
	}

	if ( UddeIM::isUddeIM() ) {
		return;
	}

	static $pm			=	array();

	$id					=	( isset( $matches[2] ) ? (int) $matches[2] : 0 );

	if ( ! isset( $pm[$id] ) ) {
		$row			=	new MessageTable();

		$row->load( $id );

		$pm[$id]		=	$row;
	}

	$source				=	$pm[$id];
}