<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CB\Plugin\AutoActions\Table\AutoActionTable;

\defined( 'CBLIB' ) or die();

interface ActionInterface
{
	
	/**
	 * Triggers the action checking access and conditions then returning its results
	 *
	 * @param UserTable $user
	 * @return mixed
	 */
	public function trigger( UserTable $user );

	/**
	 * Executes the action directly and returns its results
	 *
	 * @param UserTable $user
	 * @return mixed
	 */
	public function execute( UserTable $user );

	/**
	 * Gets the auto action associated with this action
	 *
	 * @return AutoActionTable
	 */
	public function autoaction(): AutoActionTable;

	/**
	 * Gets or sets substitution variables for this action
	 *
	 * @param null|array $substitutions
	 * @return array
	 */
	public function substitutions( ?array $substitutions = null ): array;

	/**
	 * Gets or sets action variables
	 *
	 * @param null|array $variables
	 * @return array
	 */
	public function variables( ?array $variables = null ): array;

	/**
	 * Parses a string through action substitutions
	 *
	 * @param null|UserTable  $user
	 * @param null|string     $string
	 * @param null|array|bool $htmlspecialchars
	 * @param null|bool       $translate
	 * @param null|bool       $format
	 * @param null|bool       $prepare
	 * @param null|bool       $substitutions
	 * @param array           $extras
	 * @return string
	 */
	public function string( ?UserTable $user, ?string $string, $htmlspecialchars = true, ?bool $translate = null, ?bool $format = null, ?bool $prepare = null, ?bool $substitutions = null, array $extras = [] ): string;

	/**
	 * Checks if the actions dependency is installed
	 *
	 * @return bool
	 */
	public function installed(): bool;

	/**
	 * Gets or sets action errors
	 *
	 * @param null|string $error
	 * @return array
	 */
	public function error( ?string $error = null ): array;
}