<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Privacy\Trigger;

use CB\Database\Table\UserTable;
use CB\Plugin\Privacy\CBPrivacy;
use CBLib\Application\Application;
use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;
use CB\Plugin\Privacy\Table\BlockedTable;

defined('CBLIB') or die();

class MenuTrigger extends \cbPluginHandler
{

	/**
	 * Displays block menu item on cb menu bar
	 *
	 * @param UserTable $user
	 */
	public function getBlock( $user )
	{
		global $_CB_framework;

		if ( ( ! $this->params->get( 'profile_blocking', true, GetterInterface::BOOLEAN ) )
			 || ( ! Application::MyUser()->getUserId() )
			 || ( Application::MyUser()->getUserId() == $user->get( 'id', 0, GetterInterface::INT ) )
			 || Application::User( $user->get( 'id', 0, GetterInterface::INT ) )->isGlobalModerator()
		) {
			return;
		}

		$blocked				=	new BlockedTable();

		$blocked->load( array( 'user_id' => Application::MyUser()->getUserId(), 'block' => $user->get( 'id', 0, GetterInterface::INT ) ) );

		$menu					=	array();

		if ( $blocked->get( 'id', 0, GetterInterface::INT ) ) {
			$menu['arrayPos']	=	array( '_UE_MENU_VIEW' => array( '_UE_MENU_PRIVACY_UNBLOCKUSER' => null ) );
			$menu['position']	=	'menuBar';
			$menu['caption']	=	htmlspecialchars( CBTxt::T( 'Unblock User' ) );
			$menu['url']		=	$_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'blocked', 'func' => 'unblock', 'id' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => CBPrivacy::getReturn() ) );
			$menu['target']		=	'';
			$menu['img']		=	'<span class="fa fa-check-circle-o"></span> ';
			$menu['tooltip']	=	htmlspecialchars( CBTxt::T( 'Unblock this user' ) );
		} else {
			$menu['arrayPos']	=	array( '_UE_MENU_VIEW' => array( '_UE_MENU_PRIVACY_BLOCKUSER' => null ) );
			$menu['position']	=	'menuBar';
			$menu['caption']	=	htmlspecialchars( CBTxt::T( 'Block User' ) );
			$menu['url']		=	'javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to block this user from accessing your profile and communicating with you?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'blocked', 'func' => 'block', 'id' => $user->get( 'id', 0, GetterInterface::INT ), 'return' => CBPrivacy::getReturn() ) ) ) . '\'; })';
			$menu['target']		=	'';
			$menu['img']		=	'<span class="fa fa-ban"></span> ';
			$menu['tooltip']	=	htmlspecialchars( CBTxt::T( 'Block this user' ) );
		}

		$this->addMenu( $menu );
	}
}