(function ($) {

    $.fn.phFileInput = function (options) {

        var settings = $.extend({
            fileList: true,
            iconClass: null,
            fileCount: 5,
            fileSizeLimit: 512000,
            lang: {}
        }, options);


        function formatBytes(bytes) {
            var decimals = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
            if (bytes === 0) return '0 B';
            var k = 1024;
            var dm = decimals < 0 ? 0 : decimals;
            var sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
            var i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
        }

        function inputValueChanged(e) {
            var input       = $(this);
            var container   = input.closest('.tower-file');
            var label       = container.find('label');
            var clear       = container.find('.tower-file-clear');
            var fileList    = container.find('.tower-file-list').empty().hide();
            var details     = container.find('.tower-file-details');
            if (!details.length) {
                container.append('<div class="tower-file-details"></div>');
                details = container.find('.tower-file-details');
            }

            var files = input[0].files;

            var iconHtml = '';
            if (settings.iconClass !== null && settings.iconClass.length > 0) {
                iconHtml = '<span class="'+ settings.iconClass +'"></span>';
            }

            // Test the file count
            if(files.length > settings.fileCount){
                alert(
                    settings.lang["COM_PHOCACART_ERROR_TOO_MANY_FILES_SELECTED"]
                    + " \n\n" + settings.lang["COM_PHOCACART_MAXIMUM_NUMBER_FILES_SELECTED_IS"] + ": " + settings.fileCount
                );
                files.value = '';
                clearInputAndDetails(false, container);
                return false;
            }



            if (files.length > 0) {

                if (settings.fileList && settings.fileCount > 0) {
                    if (!fileList.length) {
                        details.append('<div class="tower-file-list"></div>');
                        fileList = container.find('.tower-file-list');
                    }

                    for (var i = 0; i < files.length; i++) {

                        if (files[i].size > 0 && files[i].size > settings.fileSizeLimit) {

                            alert(
                            settings.lang["COM_PHOCACART_ERROR"]
                            + ": " + files[i].name
                            + " \n\n" + settings.lang["COM_PHOCACART_WARNFILETOOLARGE"]
                            + " \n\n" + settings.lang["COM_PHOCACART_FILE_SIZE"] + ": " + formatBytes(files[i].size)
                            + " \n" + settings.lang["COM_PHOCACART_FILE_SIZE_LIMIT"] + ": " + formatBytes(settings.fileSizeLimit)
                            );
                            files.value = '';
                            clearInputAndDetails(false, container);
                            return false;
                        }

                        var fileId = 'phFileUploadId' + this.id + i;
                        fileList.append('<div class="ph-file-upload-box"><img src="" alt="" id="'+ fileId  + '" /><div class="ph-file-upload-name">' + files[i].name + '</div></div>');

                        var img = $('#' + fileId);
                        img.attr('class', 'ph-file-upload-thumb');
                        img.attr('alt', files[i].name);
                        img.attr('title', files[i].name);
                        showImgPreview(files[i], img);
                    }
                    details.show();
                    fileList.show();
                } else {
                    fileList.hide();
                }
                label.html(iconHtml + files.length + ' ' + settings.lang["COM_PHOCACART_FILES_SELECTED"] );
                clear.attr('disabled', null);

            } else {
                // No Files Selected
                details.hide();
                label.html(label.data('default-text'));
                clear.attr('disabled', '');
            }
        }

        // Read the file data and insert the data URL into the src
        function showImgPreview(file, img) {
            var reader = new FileReader();
            reader.onload = function (e) {
                img.attr('src', reader.result).show();
            };
            reader.readAsDataURL(file);
        }

        function clearInputAndDetails(event, specificContainer) {

            if (event === false) {
                var container = specificContainer;
            } else {
                var container = $(this).closest('.tower-file');
            }

            container.find('input[type="file"]').val('');

            var iconHtml = '';
            if (settings.iconClass !== null && settings.iconClass.length > 0) {
                iconHtml = '<span class="'+ settings.iconClass +'"></span>';
            }

            var label = container.find('label');
            label.html(iconHtml + ' ' + label.data('default-text'));

            container.find('.tower-file-clear').attr('disabled', '');

            var details = container.find('.tower-file-details');
            details.hide();
        }

        this.filter('input[type="file"]').each(function () {
            var container = $(this).closest('.tower-file');

            var label = container.find('label');
            if (label.length) {
                label.attr('data-default-text', label.text().trim());
            }

            var clear = container.find('.tower-file-clear');
            if (clear.length) {
                clear.attr('disabled', '');
                clear.on('click', clearInputAndDetails);
            }

            $(this).on('change', inputValueChanged);
        });
    };

}(jQuery));