<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJivePhoto;

use CB\Plugin\GroupJivePhoto\Table\PhotoTable;
use CBLib\Registry\Registry;

defined('CBLIB') or die();

class CBGroupJivePhoto
{
	/** @var PhotoTable[]  */
	private static $photoCache	=	array();

	/**
	 * @return Registry
	 */
	public static function getGlobalParams()
	{
		global $_PLUGINS;

		static $params	=	null;

		if ( $params === null ) {
			$plugin		=	$_PLUGINS->getLoadedPlugin( 'user/plug_cbgroupjive/plugins', 'cbgroupjivephoto' );
			$params		=	new Registry();

			if ( $plugin ) {
				$params->load( $plugin->params );
			}
		}

		/** @var Registry $params */
		return $params;
	}

	/**
	 * Caches a prefetched array of photos for reuse
	 *
	 * @param PhotoTable[] $photos
	 */
	public static function prefetchPhotos( $photos )
	{
		foreach ( $photos as $photo ) {
			$rowId						=	$photo->getInt( 'id', 0 );

			if ( ! $rowId ) {
				continue;
			}

			self::$photoCache[$rowId]	=	$photo;
		}
	}

	/**
	 * returns a cached photo object
	 *
	 * @param int $id
	 * @return PhotoTable
	 */
	public static function getPhoto( $id )
	{
		if ( ! $id ) {
			return new PhotoTable();
		}

		if ( ! isset( self::$photoCache[$id] ) ) {
			$row					=	new PhotoTable();

			$row->load( (int) $id );

			self::$photoCache[$id]	=	$row;
		}

		return self::$photoCache[$id];
	}
}